<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
# This function supports adding incidents
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;
 
$db = cmsms()->GetDb();

if (!$this->CheckPermission('Use ServiceDesk'))
{
	echo $this->ShowErrors($this->Lang('accessdenied', array('Use ServiceDesk')));
	return;
}

if (isset($params['cancel']))
{
	$params = array('active_tab' => 'incidents');
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
}

$product = '';
if (isset($params['product']))
{
	$product = $params['product'];
}

$usedcategory = 0;
if (isset($params['cat_id']))
{
	$usedcategory = $params['cat_id'];
}

$usedrequestor = 0;
if (isset($params['requestor_id']))
{
	$usedrequestor = $params['requestor_id'];
}

$usedstatus = $this->GetPreference('defaultstatus', 'OP');
if (isset($params['status']))
{
	$usedstatus = $params['status'];
}

$sendmail = 0;
if (isset($params['sendmail']))
{
	$sendmail = $params['sendmail'];
}

$requestor_ref = '';
if (isset($params['requestor_ref']))
{
	$requestor_ref = $params['requestor_ref'];
}

$detail_description = '';
if (isset($params['detail_description']))
{
	$detail_description = $params['detail_description'];
}

$usedowner_id = $this->GetPreference('defaultowner', 0);
if (isset($params['owner_id']))
{
	$usedowner_id = $params['owner_id'];
}

$usedpriority = '5';
if (isset($params['priority']))
{
	$usedpriority = $params['priority'];
}

$usedpriorityseq = 5;
if (isset($params['priorityseq']))
{
	$usedpriorityseq = $params['priorityseq'];
}

$description = '';
$errmessage = '';
if (isset($params['description']) )
{
	$description = $params['description'];
	if ($description != '')
	{
		$incident_id = $db->GenID(cms_db_prefix()."module_servicedesk_incidents_seq");
		$now = trim($db->DBTimeStamp(time()), "'");
		$query = 'INSERT INTO '.cms_db_prefix().'module_servicedesk_incidents (incident_id, 
			description, product, cat_id, requestor_id, status, sendmail, 
			requestor_ref, detail_description, owner_id, priority, priorityseq, create_date,
			modified_date, start_date, end_date)
			VALUES (?,?,?,?,?,?,?,
				?,?,?,?,?,?,
				?,?,?)';
		$db->Execute($query, array($incident_id, $description, $product, $usedcategory, 
			$usedrequestor, $usedstatus, $sendmail, $requestor_ref, $detail_description, 
			$usedowner_id, $usedpriority, $usedpriorityseq,
			$now, NULL, $now, NULL));

		if ($usedstatus == 'CL') {
			// Status set to closed, set the end date
			$this->CloseIncident($incident_id);
		}

		$params = array('tab_message'=> 'incidentadded', 'active_tab' => 'incidents');
		$this->Redirect($id, 'defaultadmin', $returnid, $params);
	}
	else
	{
		$errmessage = $this->Lang('noincidentdescgiven');
		echo $this->ShowErrors($errmessage);
	}
}

// Prepare a list of categories
$categorylist = array();
$categorylist = $this->GetListCategories();

// Prepare a list of requestors
$requestorlist = array();
$requestorlist = $this->GetListRequestors($this->Lang('newrequestor'));

// Prepare a list of statusses
$statuslist = array();
$statuslist = $this->GetListStatusses();

// Prepare a list of internal users (one of which will be the owner)
$ownerlist = array();
$ownerlist = $this->GetListOwners();

// Prepare the various priorities
$prioritydropdown = array();
$prioritydropdown = $this->GetListPriorities();

// Prepare the various priorities scores
$priorityseqdropdown = array();
$priorityseqdropdown = $this->GetListPrioritySeq();

// Make sure there is no index warning when running in debug mode
$this->smarty->assign('incident_id', -1);

#Display template
$this->smarty->assign('startform', $this->CreateFormStart($id, 'addincident', $returnid));
$this->smarty->assign('endform', $this->CreateFormEnd());
$this->smarty->assign('descriptiontext', $this->Lang('incidentdescription'));
$this->smarty->assign('descriptioninput', $this->CreateInputText($id, 'description', $description, 80, 80, 'class="defaultfocus"'));
$this->smarty->assign('producttext', $this->Lang('product'));
$this->smarty->assign('productinput', $this->CreateInputText($id, 'product', $product, 20, 20));
$this->smarty->assign('categorytext', $this->Lang('category'));
$this->smarty->assign('categoryinput', $this->CreateInputDropdown($id, 'cat_id', $categorylist, -1, $usedcategory));
$this->smarty->assign('requestortext', $this->Lang('requestor'));
$this->smarty->assign('requestorinput', $this->CreateInputDropdown($id, 'requestor_id', $requestorlist, -1, $usedrequestor));
$this->smarty->assign('requestor_reftext', $this->Lang('requestor_reference'));
$this->smarty->assign('requestor_refinput', $this->CreateInputText($id, 'requestor_ref', $requestor_ref, 25, 25));
$this->smarty->assign('detaildesctext', $this->Lang('detaildescription'));
$this->smarty->assign('detaildescinput', $this->CreateTextArea($this->GetPreference('enableeditor', true),
	$id, $detail_description, 'detail_description', '', '', '', '', '80', '3'));
$this->smarty->assign('prioritytext', $this->Lang('priority'));
$this->smarty->assign('priorityinput', $this->CreateInputDropdown($id, 'priority', $prioritydropdown, -1, $usedpriority));
$this->smarty->assign('priorityseqtext', $this->Lang('priorityseq'));
$this->smarty->assign('priorityseqinput', $this->CreateInputDropdown($id, 'priorityseq', $priorityseqdropdown, -1, $usedpriorityseq));
$this->smarty->assign('statustext', $this->Lang('status'));
$this->smarty->assign('statusinput', $this->CreateInputDropdown($id, 'status', $statuslist, -1, $usedstatus));
$this->smarty->assign('sendmailtext',$this->Lang('sendmailincident'));
$this->smarty->assign('sendmailinput', $this->CreateInputCheckbox($id, 'sendmail', true, $this->GetPreference('sendmailincident', true)));
$this->smarty->assign('ownertext', $this->Lang('owner'));
$this->smarty->assign('ownerinput', $this->CreateInputDropdown($id, 'owner_id', $ownerlist, $this->GetPreference('defaultowner', -1), $usedowner_id));

$this->smarty->assign('hidden', '');
$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
echo $this->ProcessTemplate('editincident.tpl');
?>