<?php
#-------------------------------------------------------------------------
# Module: servicedesk - Service desk to support incidents and requests
# Version: 0.1, Duketown
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2009 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
# This file originally created by ModuleMaker module, version 0.3.1
# Copyright (c) 2009 by Samuel Goldstein (sjg@cmsmadesimple.org) 
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class servicedesk extends CMSModule
{

	function GetName()
	{
		return 'ServiceDesk';
	}

	function GetFriendlyName()
	{
		// Set the version in a preference, for speed and check in various other service desk programs
		$this->SetPreference('servicedeskversion', 'free');
		$fn = cms_join_path(dirname(__FILE__),'gold');
		if (file_exists( $fn ) ) {
			$this->SetPreference('servicedeskversion', 'gold');
			return $this->Lang('friendlynamegold');
		}
		$fn = cms_join_path(dirname(__FILE__),'silver');
		if (file_exists( $fn ) ) {
			$this->SetPreference('servicedeskversion', 'silver');
			return $this->Lang('friendlynamesilver');
		}
		return $this->Lang('friendlyname');
	}

	function GetVersion()
	{
		return '0.5';
	}

	function GetHelp()
	{
		return $this->Lang('help');
	}

	function GetAuthor()
	{
		return 'Duketown';
	}

	function GetAuthorEmail()
	{
		return '';
	}

	function GetChangeLog()
	{
		return file_get_contents(dirname(__FILE__).'/changelog.inc');
	}

	function IsPluginModule()
	{
		return true;
	}

	function HasAdmin()
	{
		return true;
	}

	function GetAdminSection()
	{
		return 'extensions';
	}

	function GetAdminDescription()
	{
		return $this->Lang('admindescription');
	}

	function VisibleToAdminUser()
	{
        return $this->CheckPermission('Use ServiceDesk');
	}
	

	/*---------------------------------------------------------
	   CheckAccess()
	   This wrapper function will check against the specified permission,
	   and display an error page if the user doesn't have adequate permissions.
	  ---------------------------------------------------------*/
	function CheckAccess($perm = 'Use ServiceDesk')
		{
		return $this->CheckPermission($perm);
		}
	
	/*---------------------------------------------------------
	   DisplayErrorPage()
	   This is a simple function for generating error pages.
	  ---------------------------------------------------------*/
    function DisplayErrorPage($id, &$params, $return_id, $message='')
    {
		$this->smarty->assign('title_error', $this->Lang('error'));
		$this->smarty->assign_by_ref('message', $message);

        // Display the populated template
        echo $this->ProcessTemplate('error.tpl');
    }
	


	/*---------------------------------------------------------
	   GetDependencies()
	   Your module may need another module to already be installed
	   before you can install it.
	   This method returns a list of those dependencies and
	   minimum version numbers that this module requires.
	   
	   It should return an hash, eg.
	   return array('somemodule'=>'1.0', 'othermodule'=>'1.1');
	  ---------------------------------------------------------*/
	function GetDependencies()
	{
		return array('FrontEndUsers'=>'1.12.1', 'CMSMailer'=>'1.73.0');
	}

	function MinimumCMSVersion()
	{
		return '1.9.4';
	}

	function MaximumCMSVersion()
	{
		return '1.10.9';
	}

	/*---------------------------------------------------------
	   InstallPostMessage()
	   After installation, there may be things you want to
	   communicate to your admin. This function returns a
	   string which will be displayed.
	  ---------------------------------------------------------*/
	function InstallPostMessage()
	{
		return $this->Lang('postinstall');
	}

	/*---------------------------------------------------------
	   UninstallPostMessage()
	   After removing a module, there may be things you want to
	   communicate to your admin. This function returns a
	   string which will be displayed.
	  ---------------------------------------------------------*/
	function UninstallPostMessage()
	{
		return $this->Lang('postuninstall');
	}

	/*---------------------------------------------------------
	   UninstallPreMessage()
	   This allows you to display a message along with a Yes/No dialog box. If the user responds
	   in the affirmative to your message, the uninstall will proceed. If they respond in the
	   negative, the uninstall will be canceled. Thus, your message should be of the form
	   "All module data will be deleted. Are you sure you want to uninstall this module?"
	  
	   If you don't want the dialog, have this method return a FALSE, which will cause the
	   module to uninstall immediately if the user clicks the "uninstall" link.
	  ---------------------------------------------------------*/
	function UninstallPreMessage()
	{
		return $this->Lang('really_uninstall');
	}
	
	/*---------------------------------------------------------
	   SetParameters()
	   Description of the available parameters for the front end
	  ---------------------------------------------------------*/
	function SetParameters()
	{
		$this->RestrictUnknownParams();
		$this->RegisterRoute('/[sS]ervice[dD]esk\/(?P<incident_id>[0-9]+)\/(?P<returnid>[0-9]+)$/');
		
		$this->CreateParameter('detailpage', '', $this->Lang('helpdetailpage'));

		$this->SetParameterType('currentuser',CLEAN_INT);
		$this->SetParameterType('detailpage',CLEAN_STRING);
		$this->SetParameterType('detailtemplate',CLEAN_STRING);
		$this->SetParameterType('lang',CLEAN_STRING);
		$this->SetParameterType('moretext',CLEAN_STRING);
		$this->SetParameterType('pagelimit',CLEAN_INT);
		$this->SetParameterType('pagenumber',CLEAN_INT);
		$this->SetParameterType('printtemplate',CLEAN_STRING);
		$this->SetParameterType('start',CLEAN_INT);
		$this->SetParameterType('status',CLEAN_STRING);
		$this->SetParameterType('statusnot',CLEAN_STRING);
		$this->SetParameterType('template',CLEAN_STRING);

		// Form parameters
		$this->SetParameterType('cat_id',CLEAN_INT);
		$this->SetParameterType('description',CLEAN_STRING);
		$this->SetParameterType('detail_description',CLEAN_STRING);
		$this->SetParameterType('priority',CLEAN_INT);
		$this->SetParameterType('product',CLEAN_STRING);
		$this->SetParameterType('requestor_ref',CLEAN_STRING);
		$this->SetParameterType('submit',CLEAN_STRING);
		$this->SetParameterType('cancel',CLEAN_STRING);

	}

	function InitializeAdmin()
	{
	  $this->SetParameters();
	}

	/*---------------------------------------------------------
	   CloseIncident($incident_id)
	   This function is used update an incident and set end date.
	   It has been prepared here, so it is callable from add and edit incident (or else)
	   This end date is used in statistical calculations.
	  ---------------------------------------------------------*/
	function CloseIncident($incident_id = -1)
	{
		if ($incident_id != -1) {
			// Initialize the Database
			$db = cmsms()->GetDb();
	
			$now = trim($db->DBTimeStamp(time()), "'");
			$query = 'UPDATE '.cms_db_prefix().'module_servicedesk_incidents SET 
				end_date = ? 
				WHERE incident_id = ?';
			$db->Execute($query, array($now, $incident_id));
		}
		return true;
	}

	/*---------------------------------------------------------
	   GetDashboardOutput()
	   This function is used by Admin\dashboard.php.
	   The string that is prepared in this function is displayed on the dashboard.
	  ---------------------------------------------------------*/
	function GetDashboardOutput()
	{
		// Initialize the Database
		$db = cmsms()->GetDb();

		$query = "SELECT count(*) FROM ".cms_db_prefix ()."module_servicedesk_incidents WHERE 
			status != ?";
		$row = &$db->GetRow($query, array('CL'));
		$countincidents = $row['count(*)'];
		switch ($countincidents) {
			case 0:
				$output = $this->Lang('openincidentsnone');
				break;
			case 1:
				$output = $this->Lang('openincidentsone');
				break;
			default:
				$output = $this->Lang('openincidents', $countincidents);
				break;
		}
		return $output;
	}

	/*---------------------------------------------------------
	   GetFEUUseremail()
	   This function retrieves the email of the logged in user
	  ---------------------------------------------------------*/
	function GetFEUUseremail($userid)
	{
		$useremail = false;
		global $CMS_VERSION;
		if (version_compare($CMS_VERSION,'1.10-beta0','>') &&
			version_compare($CMS_VERSION,'1.11','<')) {
			$modops = cmsms()->GetModuleOperations();
			$feu = $modops->get_module_instance('FrontEndUsers');
		}
		else {
			$feu =& $this->GetModuleInstance('FrontEndUsers');
		}
		if( !$feu ) return false;
		$useremail = $feu->GetEmail($userid);
		return $useremail;
	}

	/*---------------------------------------------------------
	   GetFEUUsername()
	   This function retrieves the name of the logged in user
	  ---------------------------------------------------------*/
	function GetFEUUsername($userid)
	{
		$username = false;
		global $CMS_VERSION;
		if (version_compare($CMS_VERSION,'1.10-beta0','>') &&
			version_compare($CMS_VERSION,'1.11','<')) {
			$modops = cmsms()->GetModuleOperations();
			$feu = $modops->get_module_instance('FrontEndUsers');
		}
		else {
			$feu =& $this->GetModuleInstance('FrontEndUsers');
		}
		if( !$feu ) return false;
		$username = $feu->GetUserName($userid);
		return $username;
	}

	/*---------------------------------------------------------
	   GetFEUProperty()
	   This function retrieves a passed property of the logged in user
	  ---------------------------------------------------------*/
	function GetFEUProperty($propname)
	{
		$txt = false;
		if( $this->_uid != -1 )
		{
		global $CMS_VERSION;
		if (version_compare($CMS_VERSION,'1.10-beta0','>') &&
			version_compare($CMS_VERSION,'1.11','<')) {
			$modops = cmsms()->GetModuleOperations();
			$feu = $modops->get_module_instance('FrontEndUsers');
		}
		else {
			$feu =& $this->GetModuleInstance('FrontEndUsers');
		}
			if( !$feu ) return false;
			$txt = $feu->GetUserPropertyFull($propname,$this->_uid);
		}
		return $txt;
	}

	/*---------------------------------------------------------
	   GetFEUUserid()
	   This function retrieves the user id of the logged in user
	  ---------------------------------------------------------*/
	function GetFEUUserid()
	{
		if( $this->_uid == -1 || $this->_uid == NULL )
		{
		global $CMS_VERSION;
		if (version_compare($CMS_VERSION,'1.10-beta0','>') &&
			version_compare($CMS_VERSION,'1.11','<')) {
			$modops = cmsms()->GetModuleOperations();
			$feu = $modops->get_module_instance('FrontEndUsers');
		}
		else {
			$feu =& $this->GetModuleInstance('FrontEndUsers');
		}
			if( !$feu ) return 0;
			$this->_uid = $feu->LoggedInId();
		}
		return $this->_uid;
	}

	/*---------------------------------------------------------
	   GetHeaderHTML()
	   This function inserts javascript (and links) into header of HTML
	  ---------------------------------------------------------*/
	function GetHeaderHTML()
	{
		$javascript = '';
		// Include javascript so easy date selection is possible
		$javascript .= '<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.3.2/jquery.min.js"></script>';
		$javascript .= '<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.7.2/jquery-ui.min.js"></script>';
		$javascript .= '<link type="text/css" rel="stylesheet" href="http://ajax.googleapis.com/ajax/libs/jqueryui/1.7.2/themes/smoothness/jquery-ui.css" />';

		$javascript .= '<script type="text/javascript">
			$(document).ready(function() {
				$(function() {$(\'div.datepicker input\').datepicker({dateFormat: \''.$this->GetPreference('dateformat', 'd-m-yy').'\'});});
				});
				</script>';
		// Include script so sorting of tables in backend is possible
		$javascript .= '<script type="text/javascript" src="../modules/JQueryTools/lib/jquery.tablesorter.js"></script>'."\n";
		$javascript .= '<link rel="stylesheet" type="text/css" href="../modules/JQueryTools/lib/css/JQueryTools.css" media="screen" />'."\n";
		$javascript .= '<script type="text/javascript" id="js">jQuery(document).ready(function() 
		{ 
			jQuery(".cms_sortable")
				.tablesorter( 
				); 
		} 
		); 
		</script>';
		return $javascript;
	}

	/* --------------------------------------------------------
		GetIncidentDetail($incident_id = -1)
		A function to return all information of an incident in an array
		--------------------------------------------------------*/	
	function GetIncidentDetail($incident_id = -1)
	{
		// Initialize the Database
		$db = cmsms()->GetDb();

		$row = array();
		$query = 'SELECT * FROM '.cms_db_prefix().'module_servicedesk_incidents 
			WHERE incident_id = ?';
		$row = $db->GetRow($query, array($incident_id));
		
		if ($row) {
			return $row;
		}
		else {
			return false;
		}
	}

	/* --------------------------------------------------------
		GetListCategories()
		A function to return all possible categories in an array
		--------------------------------------------------------*/	
	function GetListCategories()
	{
		// Initialize the Database
		$db = cmsms()->GetDb();

		$categorylist = array();
		$query = 'SELECT * FROM '.cms_db_prefix().'module_servicedesk_categories 
			ORDER BY description';
		$dbresult = $db->Execute($query);
		while ($dbresult && $row = $dbresult->FetchRow())
		{
			$categorylist[$row['description']] = $row['cat_id'];
		}
		
		return $categorylist;
	}

	/* --------------------------------------------------------
		GetListContent()
		A function to return all possible pages in an array
		--------------------------------------------------------*/	
	function GetListContent()
	{
		// Initialize the Database
		$db = cmsms()->GetDb();

		$contentlist = array();
		$query = 'SELECT * FROM '.cms_db_prefix().'content 
			WHERE active = 1
			ORDER BY menu_text';
		$dbresult = $db->Execute($query);
		while ($dbresult && $row = $dbresult->FetchRow())
		{
			$contentlist[$row['menu_text']] = $row['content_alias'];
		}
		
		return $contentlist;
	}

	/* --------------------------------------------------------
		GetListFETemplates()
		A function to return all possible FE Templates in an array
		--------------------------------------------------------*/	
	function GetListFETemplates()
	{
		// Initialize the Database
		$db = cmsms()->GetDb();

		$fetemplatelist = array();
		$query = 'SELECT * from '.cms_db_prefix().'module_templates WHERE module_name = ? 
			AND template_name LIKE "form%" ORDER BY template_name ASC';
		$dbresult = $db->Execute($query, array($this->GetName()));
		while ($dbresult && $row = $dbresult->FetchRow()) {
			$fetemplatelist[$row['template_name']] = $row['template_name'];
		}
		
		return $fetemplatelist;
	}

	/* --------------------------------------------------------
		GetListOwners()
		A function to return all possible owners in an array
		--------------------------------------------------------*/	
	function GetListOwners()
	{
		// Initialize the Database
		$db = cmsms()->GetDb();

		$ownerlist = array();
		$query = 'SELECT * FROM '.cms_db_prefix().'users ORDER BY first_name';
		$dbresult = $db->Execute($query);
		while ($dbresult && $row = $dbresult->FetchRow()) {
			if ($row['first_name'] . $row['last_name'] == '') {
				$ownerlist[$row['username']] = $row['user_id'];
			}
			else {
				$ownerlist[$row['first_name'].' '.$row['last_name']] = $row['user_id'];
			}
		}

		return $ownerlist;
	}

	/* --------------------------------------------------------
		GetListPageLimit()
		A function to return fill array with possible pagelimits
		--------------------------------------------------------*/	
	function GetListPageLimit()
	{
		$pagelimitlist = array();
		$pagelimitlist['5'] = 5;
		$pagelimitlist['10'] = 10;
		$pagelimitlist['25'] = 25;
		$pagelimitlist['50'] = 50;
		$pagelimitlist['100'] = 100;
		$pagelimitlist[$this->Lang('unlimited')] = 99999999;
		
		return $pagelimitlist;
	}

	/* --------------------------------------------------------
		GetListPeriods()
		A function to return all possible periods in an array
		--------------------------------------------------------*/	
	function GetListPeriods()
	{
		$periodlist = array();
		for ($i = 0; $i < 12; $i++) {
			$periodlist[$i + 1] = $i;
		}

		return $periodlist;
	}

	/* --------------------------------------------------------
		GetListPriorities()
		A function to return all possible priorities in an array
		--------------------------------------------------------*/	
	function GetListPriorities()
	{
		$prioritydropdown = array();
		$prioritydropdown[$this->Lang('prioritylow')] = '1';
		$prioritydropdown[$this->Lang('prioritymedium')] = '5';
		$prioritydropdown[$this->Lang('priorityhigh')] = '9';

		return $prioritydropdown;
	}

	/* --------------------------------------------------------
		GetListPrioritySeq()
		A function to return all possible priorities sequences in an array
		--------------------------------------------------------*/	
	function GetListPrioritySeq()
	{
		$priorityseqdropdown = array();
		$i = 1;
		while ($i <= 12) {
			$priorityseqdropdown[$i] = $i;
			$i++;
		}

		return $priorityseqdropdown;
	}

	/* --------------------------------------------------------
		GetListRequestors()
		A function to return all requestors in an array
		--------------------------------------------------------*/	
	function GetListRequestors($firstvalue = '')
	{
		// Initialize the Database
		$db = cmsms()->GetDb();

		$requestorlist = array();
		if ($firstvalue != '') {
			$requestorlist[$firstvalue] = 0;
		}
		$query = 'SELECT * FROM '.cms_db_prefix().'module_feusers_users ORDER BY username';
		$dbresult = $db->Execute($query);
		while ($dbresult && $row = $dbresult->FetchRow()) {
			$requestorlist[$row['username']] = $row['id'];
		}
		
		return $requestorlist;
	}

	/* --------------------------------------------------------
		GetListStatusses()
		A function to return all statusses in an array
		--------------------------------------------------------*/	
	function GetListStatusses($inclstatus = '')
	{
		// Initialize the Database
		$db = cmsms()->GetDb();

		$statuslist = array();
		if ($inclstatus == '*') {
			$statuslist[$this->Lang('allopen')] = '*';
		}
		$query = 'SELECT * FROM '.cms_db_prefix().'module_servicedesk_statusses 
			ORDER BY description';
		$dbresult = $db->Execute($query);
		while ($dbresult && $row = $dbresult->FetchRow())
		{
			$statuslist[$row['description']] = $row['status'];
		}
		
		return $statuslist;
	}

	/* --------------------------------------------------------
		GetListTemplates($contains = '%')
		A function to return all templates of this module in an array
		--------------------------------------------------------*/	
	function GetListTemplates($contains = '%')
	{
		// Initialize the Database
		$db = cmsms()->GetDb();

		$templatelist = array();
		
		// Prepare list of availabe templates
		$query = 'SELECT * from '.cms_db_prefix().'module_templates 
			WHERE module_name = ? AND template_name LIKE ? 
			ORDER BY template_name ASC';
		$dbresult = $db->Execute($query, array($this->GetName(), $contains));
		
		while ($dbresult && $row = $dbresult->FetchRow()) {
			$templatelist[$row['template_name']] = $row['template_name'];
		}
		
		return $templatelist;
	}

	/* --------------------------------------------------------
		GetListYears()
		A function to return all possible years in an array
		--------------------------------------------------------*/	
	function GetListYears()
	{
		$yearlist = array();
		$i = date("Y");
		for ($year = date("Y"); $year > $i-12; $year--) {
			$yearlist[$year] = $year;
		}

		return $yearlist;
	}

	/* --------------------------------------------------------
		GetPossibleMailVars($mailpart)
		A function to return all usable variables in an array
		$mailpart is key to which parms are usable
		--------------------------------------------------------*/	
	function GetPossibleMailVars($mailpart = '')
	{
		// Prepare a list of possible values for the user to use in the template
		$mailparms = array();
		switch ($mailpart) {
		case 'statussubject':
			$mailparms[] = '{$incident_id}';
			$mailparms[] = '{$yourref}';
			break;
		case 'statusbody':
			$mailparms[] = '{$startdate}';
			$mailparms[] = '{$description}';
			$mailparms[] = '{$incident_id}';
			$mailparms[] = '{$product}';
			$mailparms[] = '{$yourref}';
			$mailparms[] = '{$name}';
			break;
		default:
			break;
		}
		return $mailparms;
	}

	/* --------------------------------------------------------
		GetRequestor()
		Return the name of a requestor
		--------------------------------------------------------*/	
	function GetRequestor($requestor_id = -1)
	{
		// Initialize the Database
		$db = cmsms()->GetDb();
			
		$requestorname = '';
		if ($requestor_id == -1) {
		}
		else {
			$query = 'SELECT * FROM '.cms_db_prefix().'module_feusers_users 
				WHERE id = ?';
			$row = $db->GetRow($query, array($requestor_id));
		
			if ($row ) {
				$requestorname = $row['username'];
			}
		}
		return $requestorname;
	}
}

?>