<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2009 by Duketown
#
# This function supports the back end for the module servicedesk
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

$query = '';
$dbresult = '';
$query = 'SELECT * FROM '.cms_db_prefix().'module_servicedesk_statusses
	ORDER BY description';
$dbresult = $db->Execute($query);
$rowclass = 'row1';
$entryarray = array();

while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();

	$onerow->id = $row['stat_id'];
	$onerow->status = $this->CreateLink($id, 'editstatus', $returnid, $row['status'], array('stat_id'=>$row['stat_id']));
	$onerow->description = $this->CreateLink($id, 'editstatus', $returnid, $row['description'], array('stat_id'=>$row['stat_id']));

	$onerow->editlink = $this->CreateLink($id, 'editstatus', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('stat_id'=>$row['stat_id']));
	if ($row['status'] != 'CL') {
		$onerow->deletelink = $this->CreateLink($id, 'deleterow', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('table'=>'Statusses','stat_id'=>$row['stat_id']), $this->Lang('areyousurestatus'));
	}
	else {
		$onerow->deletelink = '';
	}

	$onerow->rowclass = $rowclass;

	$entryarray[] = $onerow;

	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}
$this->smarty->assign_by_ref('items', $entryarray);
$this->smarty->assign('itemcount', count($entryarray));

// Setup links
$this->smarty->assign('addstatuslink', $this->CreateLink($id, 'addstatus', $returnid, $this->Lang('addstatus'), array(), '', false, false, 'class="pageoptions"'));
$this->smarty->assign('addstatuslink', $this->CreateLink($id, 'addstatus', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addstatus'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addstatus', $returnid, $this->Lang('addstatus'), array(), '', false, false, 'class="pageoptions"'));

$this->smarty->assign('descriptiontext', $this->Lang('statusdescription'));
$this->smarty->assign('statustext', $this->Lang('status'));

// Display the statusses
echo $this->ProcessTemplate('liststatusses.tpl');

?>
