<?php

#-------------------------------------------------------------------------------
#
# Smarty Plugin : {xajax_tools}
# Purpose       : a tool for CMS Made Simple to integrate xajax functions to the
#                 frontend
#                 CMS Made Simple is (c) 2004-2011 by Ted Kulp
#                 The projects homepage is: www.cmsmadesimple.org
# Author        : Georg Busch (NaN)
# Copyright     : 2011 Georg Busch (NaN)
# Version       : 0.3.1
# License       : GPL
#
#-------------------------------------------------------------------------------

global $CMS_ADMIN_PAGE;
if(!isset($CMS_ADMIN_PAGE) || $CMS_ADMIN_PAGE != 1)
{
	/**
	 * Class definition and methods for xajax_tools
	 *
	 * @author Georg Busch (NaN)
	 * @copyright 2011 Georg Busch (NaN)
	 * @version 0.3.1
	 *
	 * @package xajax_tools
	 * @license GPL
	 */
	class smarty_cms_function_xajax_tools
	{
		private static $_xajax;
		
		/**
		 * @ignore
		 */
		final private function __construct() {}
		
		/**
		 * Returns the xajax object instance with some basic settings
		 */
		final public static function &GetXajax()
		{
			if(!self::$_xajax)
			{
				$config = cmsms()->GetConfig();
				@define('XAJAX_DEFAULT_CHAR_ENCODING', $config['default_encoding']);
				require_once($config['root_path'] . '/lib/xajax/xajax_core/xajax.inc.php');
				self::$_xajax = new xajax();
				self::$_xajax->configure('requestURI', $config['root_url'] . '/plugins/function.xajax_tools.php');
				self::$_xajax->configure('javascript URI', $config['root_url'] . '/lib/xajax/');
			}
			return self::$_xajax;
		}
		
		/**
		 * xajax request params debug function:
		 */
		final public static function _print_r($array, $depth = 0)
		{
			if(!@is_array($array))
				return $array;
			
			$result = '';
			$indent = '';
			for($i = 0; $i < $depth; $i++)
			{
				$indent .= "\t";
			}
			foreach($array as $k => $v)
			{
				if(@is_array($v))
				{
					$v = "array(\n" . $indent . self::_print_r($v, $depth + 1) . ")";
				}
				$result .= $indent . "[$k] => $v\n";
			}
			return $result;
		}
		
		/**
		 * Returns the xajax response
		 */
		final public static function &GetResponse($actions = array())
		{
			$response = new xajaxResponse();
			foreach($actions as $one_action)
			{
				if($one_action['error'])
				{
					if(!$_SESSION['xajax_tools']['debug'])
					{
						continue;
					}
					$response->alert($one_action['result']);
				}
				else
				{
					$response->assign($one_action['target_id'], $one_action['target_property'], $one_action['result']);
				}
			}
			return $response;
		}
		
		
		#-----------------------------------------------------------------------
		# xajax_tools actions
		#-----------------------------------------------------------------------
		
		/**
		 * Process a module action
		 */
		final public static function xajax_module_action($params)
		{
			if(!@is_array($params))
			{
				$params = array('module' => $params);
			}
			
			if((!empty($_SESSION['xajax_tools']['modules']) 
				&& !in_array($params['module'], $_SESSION['xajax_tools']['modules']))
				|| !$module =& cms_utils::get_module($params['module']))
			{
				return array(
					'error'  => true, 
					'result' => "XAJAX ERROR!\n\n" .
						"Module '" . $params['module'] . "' not found or not allowed!\n" .
						"passed xajax arguments:\n\n" . self::_print_r($params) . "\n" .
						"passed plugin params:\n\n" . self::_print_r($_SESSION['xajax_tools'])
				);
			}
			
			$params             =  isset($params['params']) && @is_array($params['params']) ? $params['params'] : array();
			$params['action']   = isset($params['action'])   ? $params['action']   : 'default';
			$params['returnid'] = isset($params['returnid']) ? $params['returnid'] : get_pageid_or_alias_from_url();
			$params['inline']   = true;
			$params['module']   = $module->GetName();
			
			$ob_content = @ob_get_clean();
			$config     = cmsms()->GetConfig();
			if( isset($config['output_compression']) && ($config['output_compression']) && $config['debug'] != true )
			{
				@ob_start('ob_gzhandler');
			}
			else
			{
				@ob_start();
			}
			
			$module->DoAction($params['action'], 'mx_', $params, $params['returnid']);
			$output = @ob_get_clean();
			
			if( isset($config['output_compression']) && ($config['output_compression']) && $config['debug'] != true )
			{
				@ob_start('ob_gzhandler');
			}
			else
			{
				@ob_start();
			}
			echo $ob_content;
			return array('error' => false, 'result' => $output);
		}
		
		
		/**
		 * Process a plugin
		 */
		final public static function xajax_plugin($params)
		{
			$config = cmsms()->GetConfig();
			
			if(!@is_array($params))
			{
				$params = array('plugin' => $params);
			}
			
			if((!empty($_SESSION['xajax_tools']['plugins']) 
				&& !@in_array($params['plugin'], $_SESSION['xajax_tools']['plugins']))
				|| $params['plugin'] == 'xajax_tools' 
				|| !@is_file($config['root_path'] . '/plugins/function.' . $params['plugin'] . '.php'))
			{
				return array(
					'error'  => true,
					'result' => "XAJAX ERROR!\n\n" . 
						"Plugin '" . $params['plugin'] . "' not found or not allowed!\n\n" . 
						"passed xajax arguments:\n\n" . self::_print_r($params) . "\n" .
						"passed plugin params:\n\n" . self::_print_r($_SESSION['xajax_tools'])
				);
			}
			
			$smarty_plugin = 'smarty_function_' . $params['plugin'];
			$cms_plugin    = 'smarty_cms_function_' . $params['plugin'];
			if(!@function_exists($smarty_plugin) && !@function_exists($cms_plugin) && $cms_plugin != 'smarty_cms_function_xajax_tools')
			{
				require_once($config['root_path'] . '/plugins/function.' . $params['plugin'] . '.php');
			}
			$plugin = !@function_exists($smarty_plugin) ? $cms_plugin : $smarty_plugin;
			
			$params             = isset($params['params']) && @is_array($params['params']) ? $params['params'] : array();
			$params['returnid'] = isset($params['returnid']) ? $params['returnid'] : get_pageid_or_alias_from_url();
			$params['xajax']    =& self::GetXajax();
			
			$ob_content = @ob_get_clean();
			if( isset($config['output_compression']) && ($config['output_compression']) && $config['debug'] != true )
			{
				@ob_start('ob_gzhandler');
			}
			else
			{
				@ob_start();
			}
			
			$smarty = cmsms()->GetSmarty();
			$output = $plugin($params, $smarty);
			$output = @ob_get_clean() . $output;
			
			if( isset($config['output_compression']) && ($config['output_compression']) && $config['debug'] != true )
			{
				@ob_start('ob_gzhandler');
			}
			else
			{
				@ob_start();
			}
			echo $ob_content;
			return array('error' => false, 'result' => $output);
		}
		
		
		/**
		 * Process a user defined tag
		 */
		final public static function xajax_udt($params)
		{
			if(!@is_array($params))
			{
				$params = array('udt' => $params);
			}
			$udt = $_SESSION['xajax_tools']['udt_prefix'] . $params['udt'];
			
			$udtOps =& cmsms()->GetUserTagOperations();
			if((!empty($_SESSION['xajax_tools']['udts']) 
				&& !@in_array($params['udt'], $_SESSION['xajax_tools']['udts']))
				|| !$udtOps->UserTagExists($udt))
			{
				return array(
					'error'  => true,
					'result' => "XAJAX ERROR!\n\n" .
						"UDT '" . $udt . "' not found or not allowed!\n\n" .
						"passed xajax arguments:\n\n" . self::_print_r($params) . "\n" .
						"passed plugin params:\n\n" . self::_print_r($_SESSION['xajax_tools'])
				);
			}
			
			$params             = isset($params['params']) && @is_array($params['params']) ? $params['params'] : array();
			$params['returnid'] = isset($params['returnid']) ? $params['returnid'] : get_pageid_or_alias_from_url();
			$params['xajax']    =& self::GetXajax();
			
			$ob_content = @ob_get_clean();
			$config     = cmsms()->GetConfig();
			if( isset($config['output_compression']) && ($config['output_compression']) && $config['debug'] != true )
			{
				@ob_start('ob_gzhandler');
			}
			else
			{
				@ob_start();
			}
			
			$output = $udtOps->CallUserTag($udt, $params);
			$output = @ob_get_clean() . $output;
			
			if( isset($config['output_compression']) && ($config['output_compression']) && $config['debug'] != true )
			{
				@ob_start('ob_gzhandler');
			}
			else
			{
				@ob_start();
			}
			echo $ob_content;
			return array('error' => false, 'result' => $output);
		}
	}
	
	# --- end class ---
	
	
	/**
	 * xajax request function.
	 * This is called from template using the javascript function xajax_tools()
	 * @ToDo: make target_id, target_property, target_value an array to toggle multiple things at once
	 */
	function smarty_cms_function_xajax_tools_process_request()
	{
		$line         = (__LINE__ - 2);
		$params       = @func_get_args();
		$actions      = array();
		$action_array = array(
			'action'          => NULL,
			'params'          => NULL,
			'target_id'       => NULL,
			'target_property' => 'innerHTML',
			'target_value'    => NULL,
			'error'           => false
		);
		if(isset($params[0]) && @is_array($params[0]))
		{
			if(isset($params[0]['action']))
			{
				$actions[] = @array_merge($action_array, $params[0]);
			}
			else
			{
				foreach($params[0] as $_p)
				{
					if(@is_array($_p))
					{
						$actions[] = @array_merge($action_array, $_p);
					}
					else
					{
						$actions[] = array(
							'action'          => $_p,
							'params'          => isset($params[1]) ? $params[1] : NULL, 
							'target_id'       => isset($params[2]) ? $params[2] : NULL, 
							'target_property' => isset($params[3]) ? $params[3] : 'innerHTML', 
							'target_value'    => isset($params[4]) ? $params[4] : NULL,
							'error'           => false
						);
					}
				}
			}
		}
		else
		{
			$actions[] = array(
				'action'          => isset($params[0]) ? $params[0] : NULL,
				'params'          => isset($params[1]) ? $params[1] : NULL,
				'target_id'       => isset($params[2]) ? $params[2] : NULL,
				'target_property' => isset($params[3]) ? $params[3] : 'innerHTML',
				'target_value'    => isset($params[4]) ? $params[4] : NULL,
				'error'           => false
			);
		}
		foreach($actions as $k => $one_action)
		{
			$method = 'xajax_' . $one_action['action'];
			
			if(!@method_exists('smarty_cms_function_xajax_tools', $method)
				|| (!empty($_SESSION['xajax_tools']['actions']) 
				&& !@in_array($one_action['action'], $_SESSION['xajax_tools']['actions'])))
			{
				$actions[$k]['error']  = true;
				$actions[$k]['result'] = "XAJAX ERROR!\n\nInsufficient arguments!\n\n" . 
					(isset($one_action['action']) ? 
						'Call to undefined action \'' . $one_action['action'] . '\' or action is not allowed ' :
						'Missing argument 1 for xajax function process_request() (method expected) '
					) . "\n\n" . 
					"passed xajax arguments:\n\n" . smarty_cms_function_xajax_tools::_print_r($one_action) . "\n" .
					"passed plugin params:\n\n" . smarty_cms_function_xajax_tools::_print_r($_SESSION['xajax_tools']);
			}
			else
			{
				$actions[$k] = array_merge($actions[$k], smarty_cms_function_xajax_tools::$method($one_action['params']));
			}
		}
		return smarty_cms_function_xajax_tools::GetResponse($actions);
	}
	
	
	/**
	 * Do the plugin action (print out the xajax javascripts)
	 */
	function smarty_cms_function_xajax_tools($params, &$smarty) 
	{
		global $CMS_ADMIN_PAGE;
		$config = cmsms()->GetConfig();
		$xajax =& smarty_cms_function_xajax_tools::GetXajax();
		$xajax->register(XAJAX_FUNCTION, 'tools');
		$_SESSION['xajax_tools'] = array(
			'actions'    => isset($params['actions'])    ? explode(',', $params['actions']) : array(),
			'modules'    => isset($params['modules'])    ? explode(',', $params['modules']) : array(),
			'plugins'    => isset($params['plugins'])    ? explode(',', $params['plugins']) : array(),
			'udts'       => isset($params['udts'])       ? explode(',', $params['udts'])    : array(),
			'udt_prefix' => isset($params['udt_prefix']) &&  trim($params['udt_prefix']) != '' ? trim($params['udt_prefix']) : 'xajax_tools_',
			'debug'      => isset($params['debug'])      ? intval($params['debug'])         : 0,
			'request_id' => md5($config['root_url'] . (isset($CMS_ADMIN_PAGE) ? $CMS_ADMIN_PAGE : 0) . $_SERVER['REMOTE_ADDR'] . (isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : 'dummy') . true)
		);
		echo $xajax->getJavascript();
		
?>

<script type="text/javascript" charset="<?php echo $config['default_encoding']; ?>">
function xajax_tools_loadURL(url) {
			
	var callBack     = (arguments[1] && typeof arguments[1] == 'function' ? arguments[1] : function(){}),
		response     = (arguments[2] && typeof arguments[2] == 'string'   ? arguments[2] : ''),
		debug        = (arguments[3] && typeof arguments[3] == 'boolean'  ? arguments[3] : this.debug),
		moduleParams = this.xajax_tools_parseUri(url).queryKey,
		regExp       = /(\w+),(\w+),(\w+),\d/,
		result       = regExp.exec(moduleParams.mact);
	
	delete moduleParams.mact;
	
	if(result != null){
		var module = result[1];
		for(var i in moduleParams) {
			moduleParams[i.replace(new RegExp(result[2],'g'),'')] = moduleParams[i];
			delete moduleParams[i];
		}
		moduleParams.action = result[3];
	}
	
	xajax_tools({
		action: 'module_action', 
		params: {
			module: module, 
			params: moduleParams
		}
	}, callBack, response, debug);
	
	return false;
}
// parseUri 1.2.2
// (c) Steven Levithan <stevenlevithan.com>
// MIT License
// (mod by NaN)
function xajax_tools_parseUri(str) {
	
	var options = {
		strictMode: false,
		key: ["source","protocol","authority","userInfo","user","password","host","port","relative","path","directory","file","query","anchor"],
		q:   {
			name:   "queryKey",
			parser: /(?:^|&)([^&=]*)=?([^&]*)/g
		},
		parser: {
			strict: /^(?:([^:\/?#]+):)?(?:\/\/((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?))?((((?:[^?#\/]*\/)*)([^?#]*))(?:\?([^#]*))?(?:#(.*))?)/,
			loose:  /^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/
		}
	};
	
	var	m   = options.parser[options.strictMode ? "strict" : "loose"].exec(str),
		uri = {},
		i   = 14;
	
	while (i--) uri[options.key[i]] = m[i] || "";
	
	uri[options.q.name] = {};
	uri[options.key[12]].replace(options.q.parser, function ($0, $1, $2) {
		if ($1) uri[options.q.name][$1] = $2;
	});
	
	return uri;
}
</script>

<?php
		
	}
	
	
	/**
	 * Process the xajax request
	 */
	if(isset($_POST['xjxfun']) && $_POST['xjxfun'] == 'tools')
	{
		@session_regenerate_id();
		
		$dirname = @dirname(@dirname(__FILE__));
		
		require_once($dirname.'/fileloc.php');
		
		@clearstatcache();
		
		require_once($dirname.'/include.php');
		
		global $CMS_ADMIN_PAGE;
		$config     = cmsms()->GetConfig();
		$request_id = md5($config['root_url'] . (isset($CMS_ADMIN_PAGE) ? $CMS_ADMIN_PAGE : 0) . $_SERVER['REMOTE_ADDR'] . (isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : 'dummy') . startswith(isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : 'dummy', $config['root_url']));
		if(!isset($_SESSION['xajax_tools']) || $_SESSION['xajax_tools']['request_id'] != $request_id) {
			exit;
		}
		
		$_REQUEST['xjxfun'] = $_POST['xjxfun'] = $_GET['xjxfun'] = 'smarty_cms_function_xajax_tools_process_request';
		$_SERVER['SCRIPT_FILENAME'] = $_SERVER['REQUEST_URI'] = $_SERVER['SCRIPT_NAME'] = $_SERVER['PHP_SELF'] = substr($config['root_path'], strlen($_SERVER['DOCUMENT_ROOT'])) . '/index.php';
		
		$xajax =& smarty_cms_function_xajax_tools::GetXajax();
		$xajax->register(XAJAX_FUNCTION, 'smarty_cms_function_xajax_tools_process_request');
		
		$config = cmsms()->GetConfig();
		@chdir($config['root_path']);
		
		$xajax->processRequest();
	}
}
else
{
	/**
	 * Do backend stuff ...
	 */
	 
	function smarty_cms_function_xajax_tools($params, &$smarty) 
	{
		echo '<!-- {xajax_tools} is no admin plugin -->';
	}
	
	function smarty_cms_help_function_xajax_tools()
	{
		
?>

<div style="float:right">
	<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
		<input type="hidden" name="cmd" value="_s-xclick" />
		<input type="hidden" name="hosted_button_id" value="QEMYGPTELNKGN" />
		<input type="image" src="https://www.paypal.com/en_GB/i/btn/btn_donate_LG.gif" border="0" name="submit" alt="PayPal - The safer, easier way to pay online." />
		<img alt="" border="0" src="https://www.paypal.com/de_DE/i/scr/pixel.gif" width="1" height="1" />
	</form>
</div>

<h3>What does this do?</h3>
<p>This provides Xajax functionality to the frontend.</p>
<h3>How is it used?</h3>
<p>Copy the file function.xajax_tools.php to your /plugins/ directory.<br />
Make sure you have access to the file directly from the browser.<br />
Example .htaccess file for your plugins directory:
<pre>
# To deny PHPs
&lt;Files ~ "\.(php|php3|php4|php5|phtml|pl|cgi)$"&gt;
	order deny,allow
	deny from all
&lt;/Files&gt;

# To allow xajax_tools
&lt;Files "function.xajax_tools.php"&gt; 
	order allow,deny
	allow from all
&lt;/Files&gt;
</pre></p>
<p>Simply insert <tt>{xajax_tools <em>[params]</em>}</tt> in the &lt;head&gt; section of your page template.<br />
This prints out all the required xajax javascripts.<br/>
Additionally there is a javascript function called <tt>xajax_tools()</tt> that may process all your ajax requests</p>
<p><strong>Parameters:</strong></p>
<ul>
	<li>
		<em>(csv)</em> <tt>actions</tt> <em>(optional)</em>
		<ul>
			<li>
				A comma separated list of allowed actions. (module_action, plugin, udt, ... more to come ... )<br />
				If empty all available plugin actions may be called.
			</li>
		</ul>
		<br />
	</li>
	<li>
		<em>(csv)</em> <tt>modules</tt> <em>(optional)</em>
		<ul>
			<li>
				A comma separated list of allowed modules.<br />
				If empty all available modules with frontend actions may be processed.<br />
			</li>
		</ul>
		<br />
	</li>
	<li>
		<em>(csv)</em> <tt>plugins</tt> <em>(optional)</em>
		<ul>
			<li>
				A comma separated list of allowed plugins.<br />
				If empty all available plugins may be processed.<br />
				Make sure you only allow/create plugins that are as secure as possible to be used in frontend!
			</li>
		</ul>
		<br />
	</li>
	<li>
		<em>(csv)</em> <tt>udts</tt> <em>(optional)</em>
		<ul>
			<li>
				A comma separated list of allowed udts.<br />
				Due to security this plugin will not process all available udts but only those where the name of the udt starts with a certain prefix.<br />
				The prefix can be set with the param <tt>udt_prefix</tt>.<br />
				You must not specify the prefix in the udt list.<br/>
				So if empty all available udts with a certain prefix may be processed.<br />
				Make sure you only allow/create udts that are as secure as possible to be used in frontend!
			</li>
		</ul>
		<br />
	</li>
	<li>
		<em>(string)</em> <tt>udt_prefix</tt> <em>(optional)</em>
		<ul>
			<li>
				A prefix for the name of all udts that may be processed via xaxjax requests in frontend.<br />
				Default is <tt>'xajax_tools_'</tt><br />
			</li>
		</ul>
		<br />
	</li>
	<li>
		<em>(boolean)</em> <tt>debug</tt> <em>(optional)</em>
		<ul>
			<li>
				Set to true for debugging<br />
			</li>
		</ul>
		<br />
	</li>
</ul>
<p><strong>Usage of the javascript function xajax_tools():</strong></p>
<p><tt>xajax_tools(<em>action, params, target_id, target_property, target_value</em>)</tt></p>
<ul>
	<li>
		<em>(mixed)</em> <tt>action</tt> <em>(required)</em>
		<ul>
			<li>
				This is the serverside action you want to process.<br />
				This can be a string or an array with multiple actions.<br />
				The array may consist of just function names or js objects with individual options for each action.<br /><br />
				<strong>Example:</strong><br /><br />
				<tt>xajax_tools('module_action', further arguments)</tt><br />
				<tt>xajax_tools(['module_action','plugin', ... ], further arguments)</tt><br />
				<tt>xajax_tools({action: 'module_action', params: {...} }, further arguments)</tt><br />
				<tt>xajax_tools([{action: 'module_action', params: {...} },{action: 'plugin', params: {...} }, ... ], further arguments)</tt><br /><br />
				If you pass an js object as argument it will be handled like an associative array.<br />
				The action object consists of the following options:<br />
<pre>{
	action: 'The name of the action (string - required)',
	params: 'The action params (string, array, object - optional but may be required for certain actions)',
	target_id: 'The id of the html dom element where the result will be displayed (string - optional; if not used no result will be seen)',
	target_property: 'The property of the html dom element that will be changed (string - optional; default is innerHTML; may be any property of a html dom element)',
	target_value: 'if specified this will be used instead of the result (not ready yet)'
}</pre>
			</li>
		</ul>
		<br />
	</li>
	<li>
		<em>(mixed)</em> <tt>params</tt> <em>(optional)</em>
		<ul>
			<li>
				The action params (string, array, object - optional but may be required for certain actions).<br />
			</li>
		</ul>
		<br />
	</li>
	<li>
		<em>(string)</em> <tt>target_id</tt> <em>(optional)</em>
		<ul>
			<li>
				The id of the html dom element where the result will be displayed.<br />
				If not used no result will be seen.<br />
			</li>
		</ul>
		<br />
	</li>
	<li>
		<em>(string)</em> <tt>target_property</tt> <em>(optional)</em>
		<ul>
			<li>
				The property of the html dom element that will be changed.<br />
				May be any property of a html dom element (e.g. 'style.backgroundColor').<br />
				Default is 'innerHTML'<br />
			</li>
		</ul>
		<br />
	</li>
	<li>
		<em>(string)</em> <tt>target_value</tt> <em>(optional)</em>
		<ul>
			<li>
				if specified this will be used instead of the result. (not ready yet)<br />
			</li>
		</ul>
		<br />
	</li>
</ul>
<p><strong>Usage of the javascript function xajax_tools_loadURL():</strong></p>
<p><tt>xajax_tools_loadURL(<em>url, callBack, responseType, debug</em>)</tt></p>
<ul>
	<li>
		<em>(string)</em> <tt>url</tt> <em>(required)</em>
		<ul>
			<li>
				The url to be loaded.<br />
				<em><strong>Note:</strong> this only works with module URLs such as index.php?mact=News,cntnt01,default,1 ...</em>
			</li>
		</ul>
		<br />
	</li>
</ul>
<p><strong>Available actions:</strong></p>
<ul>
	<li>
		<tt>module_action</tt>
		<ul>
			<li>
				This action performs any kind of action of a CMSms module.<br />
				This function expects the params to be an array that contains at least one index 'module' that contains the name of the module to process:<br />
<pre>{
	module: 'Name of the module (required)',
	params: {
		action: 'Action of the module (optional - default is the default module action)',
		any_valid_module_param: 'any valid value',
		...
	}
}</pre>
			</li>
		</ul>
		<br />
	</li>
	<li>
		<tt>plugin</tt>
		<ul>
			<li>
				This action processes any plugin that is allowed to be processed.<br />
				This action expects the params to be an array that contains at least one index 'plugin' that contains the name of the plugin to process:<br />
<pre>{
	plugin: 'Name of the plugin (required)',
	params: {
		any_valid_plugin_param: 'any valid value',
		...
	}
}</pre>
			</li>
		</ul>
		<br />
	</li>
	<li>
		<tt>udt</tt>
		<ul>
			<li>
				This action processes any allowed udt that is prefixed with a certain value.<br />
				You must not specify the prefix when calling the xajax_tools javascript function in frontend!<br/>
				It is recommended to hide the prefix from the public!<br />
				This action expects the params to be an array that contains at least one index 'udt' that contains the name of the udt to process:<br />
<pre>{
	plugin: 'Name of the udt (required - no udt prefix here!)',
	params: {
		any_valid_udt_param: 'any valid value',
		...
	}
}</pre>
			</li>
		</ul>
		<br />
	</li>
	<li>
		<tt>will be continued ... </tt>
	</li>
	<br />
</ul>
<p><strong>Example usage:</strong>
<pre><code>&lt;head&gt;
	...
	{xajax_tools}
&lt;/head&gt;
&lt;body&gt;
	...
	&lt;label for="toggle_news"&gt;Toggle the News Module:&nbsp;&lt;/label&gt;
	&lt;input id="toggle_news" name="toggle_news" type="checkbox" value="1" <strong>onchange="if(this.checked){ xajax_tools('module_action', {module: 'News', params:{articleid:-1,action:'detail'}}, 'news_container') } else { document.getElementById('news_container').innerHTML = 'This is where the news will be loaded into';}"</strong> /&gt;
	&lt;div id="news_container"&gt;This is where the news will be loaded into&lt;/div&gt;
	...
&lt;/body&gt;</code></pre></p>
<h3>Support</h3>
<p>This plugin does not include commercial support. However, there are a number of resources available to help you with it:</p>
<ul>
	<li>The projects homepage is <a href="http://dev.cmsmadesimple.org/projects/xajax_tools/">http://dev.cmsmadesimple.org/projects/xajax_tools/</a></li>
	<li>Additional discussion of this plugin may also be found in the CMS Made Simple Forums:<br />
	<a href="http://forum.cmsmadesimple.de">http://forum.cmsmadesimple.de</a><br />
	<a href="http://forum.cmsmadesimple.org">http://forum.cmsmadesimple.org</a></li>
</ul>
<br />
<p>Please report any kind of feedback.</p>
<h3>Copyright and License</h3>
<p>
	As per the GPL, this software is provided as-is.<br />
	This program is distributed in the hope that it will be useful,<br />
	but WITHOUT ANY WARRANTY; without even the implied warranty of<br />
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.<br />
	See the GNU General Public License for more details.<br />
	You should have received a copy of the GNU General Public License<br />
	along with this program; if not, write to the Free Software<br />
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA<br />
	Or read it online: <a href="http://www.gnu.org/licenses/licenses.html#GPL">http://www.gnu.org/licenses/licenses.html#GPL</a><br />
	Please read the text of the license for the full disclaimer.
</p>
<p>Copyright &copy; 2011, Georg Busch (NaN). All Rights Are Reserved.</p>
<p>This plugin has been released under the <a href="http://www.gnu.org/licenses/licenses.html#GPL">GNU Public License</a>. You must agree to this license before using the plugin.</p>
<br />

<?php
		
	}
	
	function smarty_cms_about_function_xajax_tools()
	{
		
?>

<p>Author: Georg Busch (NaN)</p>
<p>Version 0.3.1:<br />
 - minor bugfixes<br />
 - added js function xajax_tools_loadURL() using parseUri 1.2.2 (c) Steven Levithan &lt;stevenlevithan.com&gt;
</p>
<p>Version 0.3:<br />
 - added udt action<br/>
 - added params<br/>
 - fixed session handling<br/>
 - released plugin in the CMSms forge<br/>
</p>
<p>Version 0.2.1:<br />
 - fixed a working dir issue<br/>
</p>
<p>Version 0.2:<br />
 - added plugin action<br/>
</p>
<p>Version 0.1 - initial release</p>

<?php
		
	}
}
?>
