<?php

$gCms = cmsms(); if( !is_object($gCms) ) exit;

$this->AdminStyle('h3 {color:red}');

// Tabs
if (FALSE == empty($params['active_tab']))
{
  $tab = $params['active_tab'];
} else {
  $tab = '';
}
if ($this->CheckPermission('Use GoogleMaps'))
{

  if (isset($params['submit_address_query'])) {
    require_once('lib'.DIRECTORY_SEPARATOR.'GoogleMapAPI-'.$this->_googleapi_version.DIRECTORY_SEPARATOR.'GoogleMapAPI.class.php');
    $query_map = new GoogleMapAPI(0, $this->GetPreference('yahooappid', '1234'));
    $query_map->setLookupService( $this->GetPreference('lookupservice', 'GOOGLE') );
    $geocode = $query_map->getGeocode($params['address']);

    if( $geocode === false )
    {
		echo $this->ShowErrors($this->Lang('e_badaddress'));
    }
    else
    {
		echo $this->ShowMessage($this->Lang('location_for').' <b>'. $params['address'] .'</b> '. $this->Lang('is').':<br/>
		<dl>
			<dt>'.$this->Lang('t_lan').':&nbsp;'.$geocode['lat'] .'</dt>
			<dt>'.$this->Lang('t_lon').':&nbsp;'.$geocode['lon'] .'</dd>
		</dl>');
	}
  }

  //tabs  
  echo $this->StartTabHeaders();
	  echo $this->SetTabHeader('maps',$this->Lang('maps'), ('maps' == $tab)?true:false);
	  echo $this->SetTabHeader('markers',$this->Lang('markers'), ('markers' == $tab)?true:false);
	  echo $this->SetTabHeader('polylines',$this->Lang('polylines'), ('polylines' == $tab)?true:false);
	  echo $this->SetTabHeader('address',$this->Lang('query_address'), ('address' == $tab)?true:false);
	  echo $this->SetTabHeader('settings',$this->Lang('settings'), ('settings' == $tab)?true:false);
  echo $this->EndTabHeaders();
  //end tabs

  //The content of the tabs
  echo $this->StartTabContent();
  
  // maps tab
  echo $this->StartTab('maps', $params);
	include(dirname(__FILE__).'/function.admin_mapstab.php');
  echo $this->EndTab();
  //end maps tab

  // Start markers tab
	echo $this->StartTab('markers', $params);
	include(dirname(__FILE__).'/function.admin_markerstab.php');
	echo $this->EndTab();
  // end markers tab

  // Start polylines tab
	echo $this->StartTab('polylines', $params);
	include(dirname(__FILE__).'/function.admin_polylinestab.php');
	echo $this->EndTab();
  // end polylines tab

  // Start address tab
  echo $this->StartTab('address', $params);
  echo $this->CreateFormStart($id, 'defaultadmin', $returnid,'','',true);
  echo $this->CreateFieldsetStart($id, 'Address queries', 'Address queries' );
  echo $this->CreateInputTextWithLabel($id, 'address', '', 100, 1024,  '', $this->Lang('address_lookup').':&nbsp;' );
  echo $this->CreateFieldsetEnd();
  echo $this->CreateInputHidden($id, 'module', 'googlemaps');
  echo $this->CreateInputSubmit($id, 'submit_address_query', $this->Lang('Submit'));
  echo $this->CreateFormEnd();

  echo $this->EndTab();
  //end address tab

  //Settings tab
  echo $this->StartTab('settings', $params);

  echo $this->CreateFormStart($id, 'savesettings', $returnid);
  echo $this->CreateFieldsetStart($id, 'general', 'General settings' );
  echo "<p>";
  echo $this->CreateLabelForInput($id, 'usecache', $this->Lang('usecache'));
  echo $this->CreateInputCheckbox($id, 'usecache', $this->GetPreference("usecache", 0) , '1');
  echo "</p>";
  echo '<p>';
  echo $this->CreateLabelForInput($id, 'usemarkershadows', $this->Lang('usemarkershadows'));
  echo $this->CreateInputCheckbox($id, 'usemarkershadows', $this->GetPreference('usemarkershadows', 0) , '1');
  echo "</p>"; 

  echo "<p>"; 
  echo $this->CreateLabelForInput($id, 'lookupservice', $this->Lang('lookupservice'));
  $lookupservices = array();
  $lookupservices["YAHOO"] = "YAHOO";
  $lookupservices["GOOGLE"] = "GOOGLE";
  echo $this->CreateInputDropdown($id, 'lookupservice', $lookupservices, -1, $this->GetPreference("lookupservice"));
  echo "</p>"; 

  echo "<p>"; 
  echo $this->CreateInputTextWithLabel($id, 'yahooapid', $this->GetPreference("yahooapid", '') , 100, 1024, '', $this->Lang('yahooappid') );
  echo "</p>"; 
  echo $this->CreateFieldsetEnd();

  // Prepare the settings for easy locator
  echo $this->CreateFieldsetStart($id, 'easylocator', $this->Lang('easylocatorsettings') );
  echo '<p>';
  $easylocatordropdown = array();
  for ($i= 1; $i<=20;$i++) {
		$easylocatordropdown[$i] = $i;		
	}
  echo $this->CreateLabelForInput($id, 'easylocatorlevel', $this->Lang('easylocatorlevel'));
  echo $this->CreateInputDropdown($id, 'easylocatorlevel', $easylocatordropdown, 2, $this->GetPreference('easylocatorlevel'));
  echo '</p>';
  echo '<p>';
	// Prepare a list of map types
	$typelist = array();
	$typelist = $this->GetMapTypes();
  echo $this->CreateLabelForInput($id, 'defaultmaptype', $this->Lang('defaultmaptype'));
  echo $this->CreateInputDropdown($id, 'defaultmaptype', $typelist, 0, $this->GetPreference('defaultmaptype'));
  echo '</p>';
  echo '<p>';
  echo $this->CreateInputTextWithLabel($id, 'easylocatorlat', $this->GetPreference('easylocatorlat', 37) , 15, 15, '', $this->Lang('easylocatorlat') );
  echo '</p>';
  echo '<p>';
  echo $this->CreateInputTextWithLabel($id, 'easylocatorlon', $this->GetPreference('easylocatorlon', -74) , 15, 15, '', $this->Lang('easylocatorlon') );
  echo '</p>';
  echo '<p>';
  echo $this->CreateLabelForInput($id, 'easylocatorsavelast', $this->Lang('easylocatorsavelast'));
  echo $this->CreateInputCheckbox($id, 'easylocatorsavelast', '1', $this->GetPreference('easylocatorsavelast', 0));
  echo '</p>';
	// Prepare a list of cursor types
	$easylocatorcursorlist = array();
	$easylocatorcursorlist = googlemaps_utils::get_easylocatorcursorlist();
  echo '<p>';
  echo $this->CreateLabelForInput($id, 'title_easylocatorcursor', $this->Lang('title_easylocatorcursor'));
  echo $this->CreateInputDropdown($id, 'easylocatorcursor', $easylocatorcursorlist, 0, $this->GetPreference('easylocatorcursor', 'crosshair'));
  echo '</p>';
  echo $this->CreateFieldsetEnd();
  echo '<p>';
  echo $this->CreateInputTextWithLabel($id, 'seqincrement', $this->GetPreference('seqincrement', 10) , 5, 5, '', $this->Lang('title_seqincrement') );
  echo '</p>';
  echo '<p>';
  echo $this->CreateInputTextWithLabel($id, 'locationprecision', $this->GetPreference('locationprecision', 7) , 2, 2, '', $this->Lang('title_locationprecision') );
  echo '</p>';
	// Prepare a list of distance uom
	$distanceuomlist = array();
	$distanceuomlist = googlemaps_utils::get_distance_uom();
  echo '<p>';
  echo $this->CreateLabelForInput($id, 'title_distanceuomdefault', $this->Lang('title_distanceuomdefault'));
  echo $this->CreateInputDropdown($id, 'distanceuom', $distanceuomlist, 0, $this->GetPreference('distanceuom', 'K'));
  echo '</p>';
	// Prepare a list of route types
	$gpxexporttypelist = array();
	$gpxexporttypelist = googlemaps_utils::get_gpxexporttypelist();
  echo '<p>';
  echo $this->CreateLabelForInput($id, 'title_gpxexporttype', $this->Lang('title_gpxexporttype'));
  echo $this->CreateInputDropdown($id, 'gpxexporttype', $gpxexporttypelist, 0, $this->GetPreference('gpxexporttype', 'trk'));
  echo '</p>';
  

	echo $this->CreateInputSubmit($id, 'submit_general', $this->Lang('Submit') );
  echo $this->CreateFormEnd();

  echo $this->EndTab();
  //END Settings tab

  echo $this->EndTabContent();  
}  
?>