<?php

/*---------------------------------------------------------
   DisplayModuleOutput($id, $params, $returnid, $message)
   NOT PART OF THE MODULE API
   This is an example of a simple method to display
   something where a page or template has a tag calling
   this module.
   
   Note that it uses a template, and is thus very powerful,
   even if it's simple.
  ---------------------------------------------------------*/

$gCms = cmsms(); if( !is_object($gCms) ) exit;

#Avoid float problem in locale
$currentLocale = setlocale(LC_ALL, 0);
setlocale(LC_ALL, 'en_US');

$query = "SELECT * FROM ". cms_db_prefix() ."module_googlemaps_maps 
	WHERE name LIKE '". $params['map']. "' LIMIT 1";
$map_data = array();
$map_data =& $db->GetRow($query);

if(!isset($map_data['map_id'])) {
  $smarty->assign('error', $this->Lang('nomap'));
  $smarty->assign('title', $this->Lang('error'));
  echo $this->ProcessTemplate('error.tpl');
  return;
}
$map_id = $map_data['map_id'];

// Now that a check is done if all seems ok, handle the overrides that are passed
if (isset($params['width'])) $map_data['width'] = $params['width'];
if (isset($params['height'])) $map_data['height'] = $params['height'];
if (isset($params['controls'])) {	// Tried to use intval($params['controls']), but smarty still fell over that
	$params['controls'] == '1' ? $map_data['controls'] = 1 : $map_data['controls'] = 0;
}
if (isset($params['type_controls'])) {
	$params['type_controls'] == '1' ? $map_data['type_controls'] = 1 : $map_data['type_controls'] = 0;
}
if (isset($params['zoom'])) $map_data['zoom'] = $params['zoom'];
if (isset($params['controls_size'])) $map_data['controls_size'] = $params['controls_size'];
if (isset($params['type'])) $map_data['type'] = $params['type'];
if (isset($params['sidebar'])) {
	$params['sidebar'] == '1' ? $map_data['sidebar'] = 1 : $map_data['sidebar'] = 0;
}
if (isset($params['directions'])) {
	$params['directions'] == '1' ? $map_data['directions'] = 1 : $map_data['directions'] = 0;
}
if (isset($params['zoom_scrollwheel'])) {
	$params['zoom_scrollwheel'] == '1' ? $map_data['zoom_scrollwheel'] = 1 : $map_data['zoom_scrollwheel'] = 0;
}
if (isset($params['pan_control'])) {
	$params['pan_control'] == '1' ? $map_data['pan_control'] = 1 : $map_data['pan_control'] = 0;
}
if (isset($params['zoom_encompass'])) {
	$params['zoom_encompass'] == '1' ? $map_data['zoom_encompass'] = 1 : $map_data['zoom_encompass'] = 0;
}
if (isset($params['scale_control'])) {
	$params['scale_control'] == '1' ? $map_data['scale_control'] = 1 : $map_data['scale_control'] = 0;
}
if (isset($params['streetview'])) {
	$params['streetview'] == '1' ? $map_data['streetViewControl'] = 1 : $map_data['streetViewControl'] = 0;
}
if (isset($params['bounds_fudge'])) $map_data['bounds_fudge'] = $params['bounds_fudge'];
if (isset($params['info_window'])) {
	$params['info_window'] == '1' ? $map_data['info_window'] = 1 : $map_data['info_window'] = 0;
}
if (isset($params['centerlon'])) $map_data['center_lon'] = $params['centerlon'];
if (isset($params['centerlat'])) $map_data['center_lat'] = $params['centerlat'];
if (isset($params['info_trigger'])) $map_data['info_trigger'] = $params['info_trigger'];
if (isset($params['language'])) $map_data['language'] = $params['language'];
	
require_once('lib/GoogleMapAPI-'.$this->_googleapi_version.'/GoogleMapAPI.class.php');
$map = new GoogleMapAPI($this->GetName().$map_data['map_id'], $this->GetName());

// set values for displaying
$map->setLookupService( $this->GetPreference('lookupservice', 'GOOGLE') );

$map->setWidth($map_data['width']);
$map->setHeight($map_data['height']);

if ($map_data['controls'] == 0) {
  $map->disableMapControls();
}
if ($map_data['type_controls'] == 0) {
  $map->disableTypeControls($map_data['type_controls']);
}
if ($map_data['pan_control'] == 1) {
  $map->enablePanControl($map_data['pan_control']);
}
if ($map_data['streetViewControl'] == 1) {
  $map->enableStreetViewControl($map_data['streetViewControl']);
}

$map->setZoomLevel($map_data['zoom']);
$map->setControlSize($map_data['controls_size']);

$map->setMapType($map_data['type']);

// not in vs 3.0 $map->setLanguage($map_data['language']);

if ($map_data['sidebar'] == 0) {
  $map->disableSidebar();
}

if ($map_data['directions'] == 0) {
  $map->disableDirections();
}

/* not in vs 3.0
if($map_data['zoomscrollwheel'] == 0) {
  $map->disableZoomScrollWheel();
}
else
{
  $map->enableZoomScrollWheel();
}
*/

if($map_data['zoom_encompass'] == 0) {
  $map->disableZoomEncompass();
}

if ($map_data['scale_control'] == 0) {
  $map->disableScaleControl();
}

$map->setBoundsFudge($map_data['bounds_fudge']);

if($map_data['info_window'] == 0) {
  $map->disableInfoWindow();
}

$map->setInfoWindowTrigger($map_data['info_trigger']);

// get markers for this map
$query = "SELECT * FROM ". cms_db_prefix() ."module_googlemaps_markers 
	WHERE map = '". $map_data['map_id'] ."'";
$dbresult =& $db->Execute($query);

$error = '';
while ($dbresult && $map_marker = $dbresult->FetchRow()) {
  
  $lat = '';
  $lon = '';
  
  if($map_marker['lat'] == '' && $map_marker['lat'] == '') {
    //find address
    $geocode = '';
    if($map_marker['address'] != '') {
      $geocode = $map->getGeocode($map_marker['address']);
    }
    $lat = $geocode['lat'];
    $lon = $geocode['lon'];
  } else {
    // use provided lat lon
    $lat = $map_marker['lat'];
    $lon = $map_marker['lon'];
  }
  
  if($lat != '' && $lon != '') {
	// Add the correct icon
	$config = $gCms->GetConfig();
    // use relative paths for markers
    // this will help with hosts that dont allow getimagesize to use absolute urls
    // 20100123 - tsw
	if ($map_marker['icon'] != '') {
 		// Prepare the url to the marker
  		$icontouse = cms_join_path('uploads',$this->getName(),'markers',$map_marker['icon']);
  		
	} else {
  		$icontouse = cms_join_path('uploads',$this->getName(),'markers','default.png');
	}
	// Now check if a shadow is to be included
	if ($this->GetPreference('usemarkershadows', 0) == 0) {
		$map->addIcon($icontouse);
		$shadowtouse = '';
	}
	else {
		// Build the name of the shadow icon. Split name in first part and extension
		$filenamesplit = array();
		$filenamesplit = strtok($map_marker['icon'], '.');
		$shadowtouse = cms_join_path('uploads',$this->getName(),'markershadows',$filenamesplit.'s.png');
  		// Check if the shadow icon exists
  		if (!file_exists($shadowtouse)) {
			$shadowtouse = cms_join_path('uploads',$this->getName(),'markershadows','defaults.png');
		}
		$map->addIcon($icontouse, $shadowtouse);
	}
	// Check if a global content block (GCB) is in use (feature request 4616)
	$matches = array();
	$matchfnd = preg_match_all('/{global_content\sname=["\'](\w+)["\']\}/', $map_marker['info'], $matches);
	if ($matchfnd)
	{
		$query = 'SELECT htmlblob_id, html FROM '.cms_db_prefix().'htmlblobs 
			WHERE htmlblob_name = ?';
		$idx = 0;
		foreach ($matches[1] as $name)
		{
			$row = $db->GetRow($query, array($name));
			$map_marker['info'] = str_replace($matches[0][$idx], $row['html'], $map_marker['info']);
			$idx++;
		}
	}
	$map_marker['info'] = $this->ProcessTemplateFromData($map_marker['info']);
	$map->addMarkerByCoords(
			str_replace(',', '.', $lon), 
			str_replace(',', '.', $lat), 
			$map_marker['name'], 
			$map_marker['info'],
			'',   // No tooltip (yet)
			$icontouse,
			$shadowtouse
			);

  } 
}

// Get polylines for this map
$query = 'SELECT * FROM '. cms_db_prefix() .'module_googlemaps_polylines 
	WHERE map_id = ?';
$dbresult =& $db->Execute($query, array($map_data['map_id']));

while ($dbresult && $pl = $dbresult->FetchRow())
{
	$polyline_array = array();
	// One or more polylines are available
	$query = 'SELECT * FROM '.cms_db_prefix().'module_googlemaps_polylineparts 
		WHERE polyline_id = ?
		ORDER BY seq';
	$dbresult2 = $db->Execute($query, array($pl['polyline_id']));
	$entryarray = array();
	while ($dbresult2 && $plpart = $dbresult2->FetchRow())
	{
		$polyline_array[] = array('lat'=>$plpart['lat'], 'long'=>$plpart['lon']);
	}
	$map->addPolylineByCoordsArray(
			$polyline_array, 
			false,
			$pl['strokecolor'],
			$pl['strokeweight'],
			$pl['strokeopacity']
		);
}

// Center the map if center coordinates are set!
if ( $map_data['center_lat'] && $map_data['center_lon'] ) {
  $map->setCenterCoords(
			str_replace(',', '.', $map_data['center_lon']), 
			str_replace(',', '.', $map_data['center_lat'])
			);
}

// assign Smarty variables;
$smarty->assign('google_map_header',$map->getHeaderJS());
$smarty->assign('google_map_js',$map->getMapJS());
$smarty->assign('google_map_sidebar',$map->getSidebar());
$smarty->assign('google_map',$map->getMap());
$smarty->assign('map_description', $map_data['description']);

// Display the populated template
echo $this->ProcessTemplate('map.tpl');

#Set back locale again
setlocale(LC_ALL, $currentLocale);
?>
