<?php
# GoogleMaps (if you don't know this one :-) Google it!). A module for CMS - CMS Made Simple
# Copyright (c) 2010 by Duketown 
#
# This function supports adding a marker
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/googlemaps
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;
$db = cmsms()->GetDb();

$user_id = '';
if (get_userid() ) {
	$user_id = get_userid();
}

if (!$this->CheckPermission('Use GoogleMaps'))
{
	echo $this->ShowErrors($this->Lang('accessdenied', array('Use GoogleMaps')));
	return;
}

$usedmap = '';
if (isset($params['map'])) {
	$usedmap = $params['map'];
}

$info = '';
if (isset($params['info'])) {
	$info = $params['info'];
}

$address = '';
if (isset($params['address'])) {
	$address = $params['address'];
}

$lat = '';
if (isset($params['lat'])) {
	$lat = $params['lat'];
}
else {
	$easylocatorlat = $this->GetPreference('easylocatorlat', 44);
}

$lon = '';
if (isset($params['lon'])) {
	$lon = $params['lon'];
}
else {
	$easylocatorlon = $this->GetPreference('easylocatorlon', -63);
}


$icon = '';
if (isset($params['icon'])) {
	$icon = $params['icon'];
}

if (isset($params['cancel']))
{
	$params = array('active_tab' => 'markers');
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
}

$name = '';
if (isset($params['name']))
{
	$name = $params['name'];
	if ($name != '')
	{
		$marker_id = $db->GenID(cms_db_prefix().'module_googlemaps_markers_seq');
		$query = 'INSERT INTO '.cms_db_prefix().'module_googlemaps_markers
			(marker_id, map, name, info, address, lat, lon, icon)
			VALUES (?,?,?,?,?,?,?,?)';
		$db->Execute($query, array($marker_id, $usedmap, $name, $info, $address, $lat, $lon, $icon));
		$this->SaveEasyLocator($center_lat, $center_lon);

		$params = array('tab_message'=> 'markeradded', 'active_tab' => 'markers');
		$this->Redirect($id, 'defaultadmin', $returnid, $params);
	}
	else
	{
		echo $this->ShowErrors($this->Lang('nonamegiven'));
	}
}

// Prepare default settings
switch ($this->GetPreference('defaultmaptype')) {
	case 'hybrid':
		$smarty->assign('maptype', 'HYBRID');
		break;
	case 'satellite':
		$smarty->assign('maptype', 'SATELLITE');
		break;
	case 'terrain':
		$smarty->assign('maptype', 'TERRAIN');
		break;
	default:
		$smarty->assign('maptype', 'ROADMAP');
		break;
}
$smarty->assign('used_lat', 0);
$smarty->assign('used_lon', 0);
$smarty->assign('used_icon', 0);

// Prepare a list of maps
$maplist = array();
$maplist = googlemaps_utils::get_list_maps();

// Check what user setting is for Global Content Block wysiwyg
$allow_wysiwyg = get_preference( $user_id, 'gcb_wysiwyg' );

// Prepare a list of icons
// Read the directory that contain the images of the markers
$path = '..'.DIRECTORY_SEPARATOR.'uploads'.DIRECTORY_SEPARATOR.$this->getName().DIRECTORY_SEPARATOR.'markers';
// Open this directory 
$markerdirectory = opendir($path);
$iconlist = array();

// Get each entry
while($file = readdir($markerdirectory)) {
	$pattern="(jpg|png|jpeg|gif)";
	if (preg_match($pattern, $file)) {
	//if ($file != '.' && $file != '..') {
		$iconlist['<img src="'.$path.DIRECTORY_SEPARATOR.$file.'" alt="'.$file.'">'] = $file;
	}
}

// Close the directory
closedir($markerdirectory);

#Display template
$smarty->assign('startform', $this->CreateFormStart($id, 'addmarker', $returnid));
$smarty->assign('endform', $this->CreateFormEnd());
$smarty->assign('title_name', $this->Lang('title_name'));
$smarty->assign('input_name', $this->CreateInputText($id, 'name', $name, 40, 80, 'class="defaultfocus"'));
$smarty->assign('title_belongstomap', $this->Lang('belongstomap'));
$smarty->assign('input_belongstomap', $this->CreateInputDropdown($id, 'map', $maplist, -1, $usedmap));
$smarty->assign('title_info', $this->Lang('title_info'));
$smarty->assign('input_info', $this->CreateTextArea($allow_wysiwyg, $id, $info, 'info', '', '', '', '', '80', '3'));
$smarty->assign('title_address', $this->Lang('address'));
$smarty->assign('input_address', $this->CreateInputText($id, 'address', $address, 40, 255));
// Pass the id, so it can be used in the java script of the easylocator 
$smarty->assign('id',$id);
$smarty->assign('title_lat', $this->Lang('latitude'));
$smarty->assign('input_lat', $this->CreateInputText($id, 'lat', $lat, 40, 100));
$smarty->assign('title_lon', $this->Lang('longitude'));
$smarty->assign('input_lon', $this->CreateInputText($id, 'lon', $lon, 40, 100));
$smarty->assign('title_icon', $this->Lang('markericon'));
$smarty->assign('input_icon', $this->CreateInputRadioGroup ($id, 'icon', $iconlist, -1, '', '&nbsp;'));
$smarty->assign('locationprecision',  $this->GetPreference('locationprecision', 7));

// Prepare the settings for the easylocator
$smarty->assign('title_easylocator', $this->Lang('title_easylocator'));
$smarty->assign('easylocatorlat', $this->GetPreference('easylocatorlat', 44));
$smarty->assign('easylocatorlon', $this->GetPreference('easylocatorlon', -63));
$smarty->assign('easylocatorlevel', $this->GetPreference('easylocatorlevel'), 1);
$smarty->assign('easylocatorcursor', $this->GetPreference('easylocatorcursor', 'crosshair'));

$smarty->assign('hidden', '');
$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
echo $this->ProcessTemplate('editmarker.tpl');
?>