<?php
#-------------------------------------------------------------------------
# Module: GoogleMaps - Module for GoogleMaps
# Version: 0.1, tsw
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------


class GoogleMaps extends CMSModule                           
{
	var $_googleapi_version = '3.0';

	function GetName()
	{
		return 'GoogleMaps';
	}
	function GetFriendlyName()
	{
		return $this->Lang('friendlyname');
	}
	function GetVersion()
	{
		return '0.2.0';
	}
	function GetHelp()
	{
		return $this->Lang('help');
	}
	function GetAuthor()
	{
		return 'tsw';
	}
	function GetAuthorEmail()
	{
		return 'tatu.wikman [at] gmail.com';
	}
	function GetChangeLog()
	{
		return file_get_contents(dirname(__FILE__).'/changelog.inc');
	}
	function IsPluginModule()
	{
		return true;
	}
	function HasAdmin()
	{
		return true;
	}
  /*	function GetAdminSection()
	{
		return 'Extensions';
	}*/
	function GetAdminDescription()
	{
		return $this->Lang('moddescription');
	}

	function VisibleToAdminUser()
	{
	  return $this->CheckPermission('Use GoogleMaps');
	}

	function GetDependencies()
	{
		return array();
	}

	function MinimumCMSVersion()
	{
		return '1.8';
	}

	function MaximumCMSVersion()
	{
		return '1.10.9';
	}	
	
	/*---------------------------------------------------------
	   SetParameters()
	   This function enables you to create mappings for
	   your module when using "Pretty Urls".
	   
	   Typically, modules create internal links that have
	   big ugly strings along the lines of:
	   index.php?mact=ModName,cntnt01,actionName,0&cntnt01param1=1&cntnt01param2=2&cntnt01returnid=3
	   
	   You might prefer these to look like:
	   /ModuleFunction/2/3
	   
	   To do this, you have to register routes and map
	   your parameters in a way that the API will be able
	   to understand.

	   Also note that any calls to CreateLink will need to
	   be updated to pass the pretty url parameter.
	   
	   Since the Skeleton doesn't really create any links,
	   the section below is commented out, but you can
	   use it to figure out pretty urls.
	   
	   ---------------------------------------------------------*/
	function SetParameters()
	{
		$this->RestrictUnknownParams();

		$this->CreateParameter('bounds_fudge', '', $this->lang('help_param_bounds_fudge'), false);
		$this->CreateParameter('centerlat', '', $this->lang('help_param_centerlat'), false);
		$this->CreateParameter('centerlon', '', $this->lang('help_param_centerlon'), false);
		$this->CreateParameter('controls', '', $this->lang('help_param_controls'), false);
		$this->CreateParameter('controls_size', '', $this->lang('help_param_controls_size'), false);
		$this->CreateParameter('directions', '', $this->lang('help_param_directions'), false);
		$this->CreateParameter('height', '', $this->lang('help_param_height'), false);
		$this->CreateParameter('info_trigger', '', $this->lang('help_param_info_trigger'), false);
		$this->CreateParameter('info_window', '', $this->lang('help_param_info_window'), false);
		$this->CreateParameter('map', 'test', $this->lang('help_param_map'), false);
		$this->CreateParameter('pan_control', '', $this->lang('help_param_pan'), false);
		$this->CreateParameter('language', '', $this->lang('help_param_language'), false);
		$this->CreateParameter('scale_control', '', $this->lang('help_param_scale'), false);
		$this->CreateParameter('sidebar', '', $this->lang('help_param_sidebar'), false);
		$this->CreateParameter('streetview', '', $this->lang('help_param_streetview'), false);
		$this->CreateParameter('type', '', $this->lang('help_param_type'), false);
		$this->CreateParameter('type_controls', '', $this->lang('help_param_type_controls'), false);
		$this->CreateParameter('width', '', $this->lang('help_param_width'), false);
		$this->CreateParameter('zoom', '', $this->lang('help_param_zoom'), false);
		$this->CreateParameter('zoom_encompass', '', $this->lang('help_param_zoom_encompass'), false);
		
		$this->SetParameterType('bounds_fudge',CLEAN_STRING);
		$this->SetParameterType('centerlat',CLEAN_STRING);
		$this->SetParameterType('centerlon',CLEAN_STRING);
		$this->SetParameterType('controls',CLEAN_STRING);
		$this->SetParameterType('controls_size',CLEAN_STRING);
		$this->SetParameterType('directions',CLEAN_STRING);
		$this->SetParameterType('height',CLEAN_STRING);
		$this->SetParameterType('info_trigger',CLEAN_STRING);
		$this->SetParameterType('info_window',CLEAN_STRING);
		$this->SetParameterType('language',CLEAN_STRING);
		$this->SetParameterType('map',CLEAN_STRING);
		$this->SetParameterType('pan_control',CLEAN_STRING);
		$this->SetParameterType('scale_control',CLEAN_STRING);
		$this->SetParameterType('sidebar',CLEAN_STRING);
		$this->SetParameterType('streetview',CLEAN_STRING);
		$this->SetParameterType('type',CLEAN_STRING);
		$this->SetParameterType('type_controls',CLEAN_STRING);
		$this->SetParameterType('width',CLEAN_STRING);
		$this->SetParameterType('zoom',CLEAN_STRING);
		$this->SetParameterType('zoom_encompass',CLEAN_STRING);
	}


  /*---------------------------------------------------------
   GetEventDescription()
   If your module can create events, you will need
   to provide the API with documentation of what
   that event does. This method wraps up a simple
   return of the localized description.
   ---------------------------------------------------------*/
  /*  function GetEventDescription ( $eventname )
  {
    return $this->Lang('event_info_'.$eventname );
  }*/


  /*---------------------------------------------------------
   GetEventHelp()
   If your module can create events, you will need
   to provide the API with documentation of how to
   use the event. This method wraps up a simple
   return of the localized description.
   ---------------------------------------------------------*/
  /*  function GetEventHelp ( $eventname )
  {
    return $this->Lang('event_help_'.$eventname );
  }*/

	

	function InstallPostMessage()
	{
		return $this->Lang('postinstall');
	}
	function UninstallPostMessage()
	{
		return $this->Lang('postuninstall');
	}
	function UninstallPreMessage()
	{
		return $this->Lang('really_uninstall');
	}
	
  /*---------------------------------------------------------
	   DisplayErrorPage($id, $params, $returnid, $message)
	   NOT PART OF THE MODULE API

	   This is an example of a simple method to display
	   error information on the admin side.
	   ---------------------------------------------------------*/
    function DisplayErrorPage($id, &$params, $returnid, $message='')
    {
		$this->smarty->assign('title_error', $this->Lang('error'));
		if ($message != '')
			{
			$this->smarty->assign_by_ref('message', $message);
			}

        // Display the populated template
        echo $this->ProcessTemplate('error.tpl');
    }

	/*---------------------------------------------------------
	   DisplayAdminNav($id, $params, $returnid, $message)
	   NOT PART OF THE MODULE API

	   This is an example of a simple method to present a
	   common admin menu.
	   	   
	   It simply sets a collection smarty tag values.   
	  ---------------------------------------------------------*/
    function DisplayAdminNav($id, &$params, $returnid)
        {
		$this->smarty->assign('admin_nav',
			$this->CreateLink($id, 'defaultadmin', $returnid, $this->Lang('title_mod_admin'), array()) .
			' : ' .
			$this->CreateLink($id, 'admin_prefs', $returnid, $this->Lang('title_mod_prefs'), array()));
        }



  function PrintMapWithMarkers($mapname, $markers) {
    require_once('lib/GoogleMapAPI-'.$this->_googleapi_version.'/GoogleMapAPI.class.php');
    $map = new GoogleMapAPI($mapname, $this->GetPreference('yahooappid', '1234'));
    while ( $marker = array_pop($markers) ) {
      $map->addMarkerByCoords($marker['lat'],$marker['lon'], $marker['name'], $marker['info']);
    }
  }
  
  function GetAddressLocation($address) {
    require_once('lib/GoogleMapAPI-'.$this->_googleapi_version.'/GoogleMapAPI.class.php');
    $map = new GoogleMapAPI($mapname, $this->GetPreference('yahooappid', '1234'));
    $geocode = $map->getGeocode($address);
    return $geocode;
  }

	/*---------------------------------------------------------
	   GetHeaderHTML()
	   This function inserts javascript (and links) into header of HTML
	  ---------------------------------------------------------*/
	function GetHeaderHTML()
	{
		$javascript = '<script type="text/javascript" src="../modules/JQueryTools/lib/jquery.tablesorter.js"></script>'."\n";
		$javascript .= '<link rel="stylesheet" type="text/css" href="../modules/JQueryTools/lib/css/JQueryTools.css" media="screen" />'."\n";
		$javascript .= '<script type="text/javascript" id="js">jQuery(document).ready(function() 
		{ 
			jQuery(".cms_sortable")
				.tablesorter( 
				); 
		} 
		); 
		</script>';
		$javascript .= '<br /><script type="text/javascript">
			function showValue(num){
				var result = document.getElementById("result");     
				result.innerHTML = num;
			}
		</script>';
		return $javascript;
	}

	function GetMapInformation($map_id) {
		$db = cmsms()->GetDb();
		
		$query = 'SELECT * FROM '. cms_db_prefix() . 'module_googlemaps_maps WHERE map_id = ?';
		$qr = $db->Execute( $query, array($map_id) );
		$row = $qr->FetchRow();
		if( $qr->RecordCount() == 0 ) {
			return false;
		}
		else {
			return $row;
		}		
	}
	
	function SaveEasyLocator($lat = 0, $lon = 0, $zoom = 0) {
		// If a value was set using easy locator, use it next time if requested
		if ($this->GetPreference('easylocatorsavelast')) {
			if ($lat != 0) $this->SetPreference('easylocatorlat', $lat);
			if ($lon != 0) $this->SetPreference('easylocatorlon', $lon);
			if ($zoom != 0) $this->SetPreference('easylocatorlevel', $zoom);
		}
	}

	function GetMapTypes() {
		// Prepare a list of map types
		$typelist = array();
		$typelist[$this->Lang('maptypemap')] = 'map';
		$typelist[$this->Lang('maptypesatellite')] = 'satellite';
		$typelist[$this->Lang('maptypehybrid')] = 'hybrid';
		$typelist[$this->Lang('maptypeterrain')] = 'terrain';
		
		return $typelist;
	}
}

?>