<?php

$gCms = cmsms(); if( !is_object($gCms) ) exit;
$db = cmsms()->GetDb();

// mysql-specific, but ignored by other database
$taboptarray = array('mysql' => 'TYPE=MyISAM');

$dict = NewDataDictionary($db);

// table schema description
$flds = "
		map_id I AUTO KEY,
	  name C(80) NOTNULL,
		description X,
	  center_lat C(50),
	  center_lon C(50),
	  owner_id I,
	  type C(50),
	  width C(50),
	  height C(50),
	  controls L,
	  controls_size C(10),
	  type_controls L,
	  sidebar L,
	  directions L,
	  zoom C(10),
	  zoomscrollwheel L,
	  zoom_encompass L,
	  scale_control L,
	  bounds_fudge F,
	  info_window L,
	  info_trigger C(80)
	";

// Create the table
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_googlemaps_maps", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

//index for maps
$sqlarray = $dict->CreateIndexSQL('i_name', cms_db_prefix()."module_googlemaps_maps", 'name');

// create a sequence
#$db->CreateSequence(cms_db_prefix()."module_googlemaps_maps_seq");


// Markers
$flds = "
	  marker_id I AUTO KEY,
	  map C(100),
	  name C(80),
	  info X,
	  address C(255),
	  lat C(100),
	  lon C(100),
	  icon C(100)
  ";

// Create the table
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_googlemaps_markers", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
// create a sequence
$db->CreateSequence(cms_db_prefix()."module_googlemaps_markers_seq");

// Polylines
$flds = "
	polyline_id I KEY,
	map_id I,
	name C(80),
	strokecolor C(7),
	strokeopacity F,
	strokeweight I,
	distance F,
	distanceuom C(1)
";

// Create the table
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_googlemaps_polylines", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
// Create a sequence
$db->CreateSequence(cms_db_prefix()."module_googlemaps_polylines_seq");

// Polyline parts
$flds = "
	polylinepart_id I KEY,
	polyline_id I KEY,
	seq I,
	description C(255),
	lat C(100),
	lon C(100)
";

// Create the table
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_googlemaps_polylineparts", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
// Create a sequence
$db->CreateSequence(cms_db_prefix()."module_googlemaps_polylineparts_seq");

// Cache not used yet
$flds = "
        address C(255) KEY DEFAULT '', 
        lon F,
        lat F
        ";

$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_googlemaps_cache", $flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);
// create a sequence
$db->CreateSequence(cms_db_prefix()."module_googlemaps_cache_seq");


// create a permission
$this->CreatePermission('Use GoogleMaps', 'Use GoogleMaps');


// create a preference
$this->SetPreference('lookupservice', 'GOOGLE');
$this->SetPreference('usecache', '0');
$this->SetPreference('usemarkershadows', 0);
$this->SetPreference('yahooappid', '');
$this->SetPreference('easylocatorlevel', 1 );
$this->SetPreference('easylocatorlat', 0 );
$this->SetPreference('easylocatorlon', 0 );
$this->SetPreference('easylocatorsavelast', '1' );
$this->SetPreference('easylocatorcursor', 'crosshair');

$config = $gCms->GetConfig();
// Prepare a directory that will contain the images of the markers and one for the shadows of the markers
$path = $this->config['uploads_path'].'/'.$this->getName();
// Make sure the directory can be found. Create it, error handling will cover any problems found
if ( !file_exists( $path ) ) mkdir($path, 0777);
$markerspath = $path.DIRECTORY_SEPARATOR.'markers';
if ( !file_exists( $markerspath ) ) mkdir($markerspath, 0777);
$markershadowspath = $path.DIRECTORY_SEPARATOR.'markershadows';
if ( !file_exists( $markershadowspath ) ) mkdir($markershadowspath, 0777);
// Copy over the default supplied markers
$markerdir = dirname(__FILE__).DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.'markers';
if (file_exists( $markerdir ) ) {
	$dir = opendir($markerdir);
	// Filter out the directory controling characters and build selectable options of the others
	while (($file = readdir($dir)) !== false)
	  {
	  	if ($file !='.' && $file!='..') {
  			copy($markerdir.DIRECTORY_SEPARATOR.$file, $markerspath.DIRECTORY_SEPARATOR.$file);
	  	}
	  }
	closedir($dir);
}
// Copy over the default supplied markershadows
$markerdir = dirname(__FILE__).DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.'markershadows';
if (file_exists( $markerdir ) ) {
	$dir = opendir($markerdir);
	// Filter out the directory controling characters and build selectable options of the others
	while (($file = readdir($dir)) !== false)
	  {
	  	if ($file !='.' && $file!='..') {
  			copy($markerdir.DIRECTORY_SEPARATOR.$file, $markershadowspath.DIRECTORY_SEPARATOR.$file);
	  	}
	  }
	closedir($dir);
}

// Mention the installation in the admin log
$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('installed',$this->GetVersion()));

?>
