<?php
# GoogleMaps (if you don't know this one :-) Google it!). A module for CMS - CMS Made Simple
# Copyright (c) 2011 by Duketown 
#
# This function supports changing a polyline
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/googlemaps
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;
$db = cmsms()->GetDb();

$user_id = '';
if (get_userid() ) {
	$user_id = get_userid();
}

if (!$this->CheckPermission('Use GoogleMaps'))
{
	echo $this->ShowErrors($this->Lang('accessdenied', array('Use GoogleMaps')));
	return;
}

if (isset($params['cancel']))
{
	$params = array('active_tab' => 'polylines');
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
}

$polyline_id = '';
if (isset($params['polyline_id'])) {
	$polyline_id = $params['polyline_id'];
}
$name = '';
if (isset($params['name']))
{
	$name = $params['name'];
}
$usedmap = '';
if (isset($params['map'])) {
	$usedmap = $params['map'];
}
require_once('lib/GoogleMapAPI-'.$this->_googleapi_version.'/GoogleMapAPI.class.php');
$map = new GoogleMapAPI($this->GetName().$usedmap, $this->GetName());

$strokecolor = '';
if (isset($params['strokecolor'])) {
	$strokecolor = $params['strokecolor'];
}

$strokeopacity = '1.0';
if (isset($params['strokeopacity'])) {
	$strokeopacity = $params['strokeopacity'];
}
$strokeweight = '2';
if (isset($params['strokeweight'])) {
	$strokeweight = $params['strokeweight'];
}
$useddistanceuom = $this->GetPreference('distanceuom', 'K');;
if (isset($params['distanceuom'])) {
	$useddistanceuom = $params['distanceuom'];
}

$seq = '';
if (isset($params['seq'])) {$seq = $params['seq'];}
$lat = '';
if (isset($params['lat'])) {
	$lat = $params['lat'];
}
else {
	$easylocatorlat = $this->GetPreference('easylocatorlat', 44);
}

$lon = '';
if (isset($params['lon'])) {
	$lon = $params['lon'];
}
else {
	$easylocatorlon = $this->GetPreference('easylocatorlon', -63);
}

$description = '';
if (isset($params['description'])) {
	$description = $params['description'];
}

// Error checking
$errfnd = false;
$errorfound = '';
if (isset($params['submit'])) {
	if ($name == '') {
		$errfnd = true;
		$errorfound .= $this->Lang('nonamegiven');
	}
	if ($strokeopacity < 0 || $strokeopacity > 1) {
		$errfnd = true;
		if ($errorfound != '') {$errorfound .= '<br />';}
		$errorfound .= $this->Lang('invalidopacity');
	}
}
if (isset($params['submit']) && $errfnd == false) {
	$query = 'UPDATE '.cms_db_prefix().'module_googlemaps_polylines SET
		map_id = ?, name = ?, strokecolor = ?, strokeopacity = ?, strokeweight = ?,
		distanceuom = ?
		WHERE polyline_id = ?';
	$db->Execute($query, array($usedmap, $name, strtoupper($strokecolor), $strokeopacity, 
		$strokeweight, $useddistanceuom, $polyline_id));

	$params = array('tab_message'=> 'polylineupdated', 'active_tab' => 'polylines');
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
}
else {
	if ($errfnd) {
		echo $this->ShowErrors($errorfound);
	}
	else {
		$smarty->assign('easylocatorlat', $this->GetPreference('easylocatorlat', 44));
		$smarty->assign('easylocatorlon', $this->GetPreference('easylocatorlon', -63));
		$smarty->assign('easylocatorlevel', $this->GetPreference('easylocatorlevel'), 1);
		$query = 'SELECT * FROM '.cms_db_prefix().'module_googlemaps_polylines WHERE polyline_id = ?';
		$row = $db->GetRow($query, array($polyline_id));
		if ($row)
		{
			$name = $row['name'];
			$usedmap = $row['map_id'];
			// Retrieve map type used of connected map
			$query = 'SELECT * FROM '.cms_db_prefix().'module_googlemaps_maps 
				WHERE map_id = ?';
			$rowmap = $db->GetRow($query, array($usedmap));
			if ($rowmap) {
				$smarty->assign('easylocatorlat', $rowmap['center_lat']);
				$smarty->assign('easylocatorlon', $rowmap['center_lon']);
				$smarty->assign('easylocatorlevel', $rowmap['zoom']);
				switch ($rowmap['type']) {
					case 'hybrid':
						$smarty->assign('maptype', 'HYBRID');
						break;
					case 'satellite':
						$smarty->assign('maptype', 'SATELLITE');
						break;
					case 'terrain':
						$smarty->assign('maptype', 'TERRAIN');
						break;
					default:
						$smarty->assign('maptype', 'ROADMAP');
						break;
				}
			}
	
			$strokecolor = $row['strokecolor'];
			$strokeopacity = $row['strokeopacity'];
			$strokeweight = $row['strokeweight'];
			$useddistanceuom = $row['distanceuom'];
			$humandistanceuom = googlemaps_utils::get_humandistance_uom($useddistanceuom);
			switch ($useddistanceuom) {
				case 'C':
				case 'I':
					$smarty->assign('strf', '%.0f');
					break;
				case 'T':
				case 'F':
					$smarty->assign('strf', '%.1f');
					break;
				default:
					$smarty->assign('strf', '%.3f');
					break;
			}
		}
	}
}
// Add the location to the path
if (isset($params['addlocation']) && $lat != '' && $lon != '' ) {
	if ($seq != '' && $seq > 0 && $seq < 999999) {
		// Sequence has been provided by user
	}
	else {
		$seqincrement = $this->GetPreference('seqincrement', 10);
		$query = 'SELECT MAX(seq) AS maxseq FROM '.cms_db_prefix().'module_googlemaps_polylineparts 
			WHERE polyline_id = ?';
		$row = $db->GetRow($query, array($polyline_id));
		if ($row)
		{
			$seq = $row['maxseq'] + $seqincrement;
		}
		else {
			$seq = $seqincrement;
		}
	}
	$ppadded = googlemaps_utils::insert_polyline_part($polyline_id, $seq, 
		$description, $lat, $lon);
}

// Rebuild the list of locations available for this polyline
$pathonmap = '';
$mapspots = 0;
$distance = 0;
$query = 'SELECT * FROM '.cms_db_prefix().'module_googlemaps_polylineparts 
	WHERE polyline_id = ?
	ORDER BY seq';
$dbresult = $db->Execute($query, array($polyline_id));
$entryarray = array();
while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();

	$onerow->polyline_id = $row['polyline_id'];
	$onerow->polylinepart_id = $row['polylinepart_id'];
	$onerow->seq = $row['seq'];
	$onerow->description = $row['description'];
	$onerow->lat = $row['lat'];
	$onerow->lon = $row['lon'];
	$onerow->deletelink = $this->CreateLink($id, 'deleterow', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('table'=>'Polylineparts','polylinepart_id'=>$row['polylinepart_id']));

	$entryarray[] = $onerow;
	// Update the list of locations for the map
	if ($mapspots == 0) {
		$mapspots++;
		$prevlat = $row['lat'];
		$prevlon = $row['lon'];
	}
	else {
		$pathonmap .= ', ';
		// Calculate the distance between current and previous location
		$distance += $map->geoGetDistance($prevlat, $prevlon, $row['lat'], 
			$row['lon'], $useddistanceuom);
		$prevlat = $row['lat'];
		$prevlon = $row['lon'];
	}
	$pathonmap .= 'new google.maps.LatLng('.$row['lat'] . ', ' . $row['lon'] . ')';

}

$smarty->assign_by_ref('locations', $entryarray);
$smarty->assign('locationcount', count($entryarray));
$smarty->assign('path', $pathonmap);
$smarty->assign('distance', $distance);

$smarty->assign('used_lat', 0);
$smarty->assign('used_lon', 0);
$smarty->assign('used_icon', 0);

// Build path to color selector
$colorselectorpath = cms_join_path('..','modules',$this->getName(),'templates','201a.js');
$smarty->assign('colorselectorpath', $colorselectorpath);

// Prepare a list of maps
$maplist = array();
$maplist = googlemaps_utils::get_list_maps();

// Prepare a list of distance uom
$distanceuomlist = array();
$distanceuomlist = googlemaps_utils::get_distance_uom();

#Display template
$smarty->assign('startform', $this->CreateFormStart($id, 'editpolyline', $returnid));
$smarty->assign('endform', $this->CreateFormEnd());
$smarty->assign('title_name', $this->Lang('title_name'));
$smarty->assign('input_name', $this->CreateInputText($id, 'name', $name, 40, 80, 'class="defaultfocus"'));
$smarty->assign('title_belongstomap', $this->Lang('belongstomap'));
$smarty->assign('input_belongstomap', $this->CreateInputDropdown($id, 'map', $maplist, -1, $usedmap));
$smarty->assign('title_color', $this->Lang('title_color'));
$smarty->assign('input_color', $this->CreateInputText($id, 'strokecolor', $strokecolor, 7, 7));
$smarty->assign('input_samplecolor', $this->CreateInputText($id, 'samplecolor', '', 1, 1, 'style="background-color: '.$strokecolor.'"'));
$smarty->assign('title_opacity', $this->Lang('title_opacity'));
$smarty->assign('input_opacity', $this->CreateInputText($id, 'strokeopacity', $strokeopacity, 3, 3));
$smarty->assign('title_weight', $this->Lang('title_weight'));
$smarty->assign('input_weight', $this->CreateInputText($id, 'strokeweight', $strokeweight, 2, 2));
$smarty->assign('title_distanceuom', $this->Lang('title_distanceuom'));
$smarty->assign('input_distanceuom', $this->CreateInputDropdown($id, 'distanceuom', $distanceuomlist, -1, $useddistanceuom));

// Pass the id, so it can be used in the java script of the easylocator 
$smarty->assign('id',$id);
$smarty->assign('title_seq', $this->Lang('title_seq'));
$smarty->assign('title_del', $this->Lang('title_del'));
$smarty->assign('input_seq', $this->CreateInputText($id, 'seq', '', 4, 6));
$smarty->assign('title_lat', $this->Lang('latitude'));
$smarty->assign('input_lat', $this->CreateInputText($id, 'lat', $lat, 15, 100));
$smarty->assign('title_lon', $this->Lang('longitude'));
$smarty->assign('input_lon', $this->CreateInputText($id, 'lon', $lon, 15, 100));
$smarty->assign('title_description', $this->Lang('title_description'));
$smarty->assign('input_description', $this->CreateInputText($id, 'description', $description, 50, 255));
$smarty->assign('title_distance', $this->Lang('title_distance'));
$smarty->assign('distanceuom', $humandistanceuom);
$smarty->assign('locationprecision',  $this->GetPreference('locationprecision', 7));

// Prepare the settings for the easylocator
$smarty->assign('editpolyline', '1');
$smarty->assign('path_color', '"'.$strokecolor.'"');
$smarty->assign('path_opacity', $strokeopacity);
$smarty->assign('path_weight', $strokeweight);
$smarty->assign('title_locations', $this->Lang('title_locations'));
$smarty->assign('title_easylocator', $this->Lang('title_easylocator'));
$smarty->assign('easylocatorcursor', $this->GetPreference('easylocatorcursor', 'crosshair'));
$smarty->assign('addlocation', $this->CreateInputSubmit($id, 'addlocation', $this->Lang('addlocation')));

$smarty->assign('hidden', $this->CreateInputHidden($id, 'polyline_id', $polyline_id));
$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$smarty->assign('submitlocations', $this->CreateInputSubmit($id, 'submitlocations', lang('submit')));
$smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
echo $this->ProcessTemplate('editpolyline.tpl');
?>