<?php

include_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'library'.DIRECTORY_SEPARATOR.'categories.api.php');
include_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'library'.DIRECTORY_SEPARATOR.'products.api.php');

class ShopMadeSimple extends CMSModule {
	
	var $categories;
	var $products;
	
	function ShopMadeSimple() {
		parent::CMSModule();
		$this->categories = new Categories($this);
		$this->products = new SMSProducts($this);
	}
	function GetName() {
		return 'ShopMadeSimple';
	}
	function GetFriendlyName() {
		return $this->Lang('friendlyname');
	}
	function GetVersion() {
		return '0.3.7';
	}
	function GetAuthor() {
		return 'Duketown';
	}
	function GetAuthorEmail() {
		// To reduce spam this email field left blank
		return '';
	}
	function GetHelp() {
		return $this->Lang('help');
	}
	function GetChangeLog()	{
		return file_get_contents(dirname(__FILE__).DIRECTORY_SEPARATOR.'changelog.inc');
	}
	function IsPluginModule() {
		return true;
	}
	function HasAdmin()	{
		return true;
	}
	function GetAdminSection() {
	global $CMS_VERSION;
	if( version_compare($CMS_VERSION,'1.8','<') ) return 'extensions';
	return 'ecommerce';
	}
	function GetAdminDescription() {
		return $this->Lang('admin_description');
	}
	/*---------------------------------------------------------
	VisibleToAdminUser()
	---------------------------------------------------------*/
	function VisibleToAdminUser()
	{
	if( $this->CheckPermission('Modify Site Preferences') ||
			$this->CheckPermission('Modify Modules') ||
			$this->CheckPermission('ShopMS_UseShopMadeSimple') ||
			$this->CheckPermission('ShopMS_MaintainCategory') ||
			$this->CheckPermission('ShopMS_MaintainProducts') ||
			$this->CheckPermission('ShopMS_MaintainSKUs')
			) {
				return true;
	  }
	return false;
	}

	function GetDependencies() {
	}	
	function MinimumCMSVersion() {
		return '1.9.4';
	}

	function MaximumCMSVersion()
	{
		return '1.10.9';
	}

	function SetParameters() {
		#$this->RegisterRoute('/[sS]hop[mM]ade[sS]imple\/(?P<returnid>[0-9]+)$/', array('action'=>'fe_category_list'));
		//$this->RegisterRoute('/[sS]hop[mM]ade[sS]imple\/(?P<product_id>[0-9]+)\/(?P<returnid>[0-9]+)$/', array('action'=>'fe_product_detail'));
		$this->RegisterRoute('/[sS]hop[mM]ade[sS]imple\/cat\/(?P<category_id>[0-9]+)\/(?P<returnid>[0-9]+)$/', array('action'=>'fe_product_list'));
		$this->RegisterRoute('/[sS]hop[mM]ade[sS]imple\/prod\/(?P<category_id>[0-9]+)\/(?P<product_id>[0-9]+)\/(?P<returnid>[0-9]+)\/(?P<junk>.*?)$/',array('action'=>'fe_product_detail'));
		# The top most parameter will be shown in the bottom and vice versa
		$this->CreateParameter('start', '', $this->Lang('helpstart'));
		$this->CreateParameter('pagenumber', '', $this->Lang('helppagenumber'));
		$this->CreateParameter('prodpagelimit', '', $this->Lang('helpprodpagelimit'));
		$this->CreateParameter('parentcategory', '', $this->Lang('helpparentcategory'));
		$this->CreateParameter('display', '', $this->Lang('helpdisplay'));
		$this->CreateParameter('catname', '', $this->Lang('helpcatname'));
		
		$this->SetParameterType('start',CLEAN_STRING);
		$this->SetParameterType('pagenumber',CLEAN_STRING);
		$this->SetParameterType('prodpagelimit',CLEAN_STRING);
		$this->SetParameterType('parentcategory',CLEAN_STRING);
		$this->SetParameterType('display',CLEAN_STRING);
		$this->SetParameterType('catname',CLEAN_STRING);

	}

	function GetEventDescription ( $eventname ) {
		return $this->Lang('event_info_'.$eventname );
	}

	function GetEventHelp ( $eventname ) {
		return $this->Lang('event_help_'.$eventname );
	}

	function InstallPostMessage() {
		return $this->Lang('message_postinstall');
	}
	function UninstallPostMessage() {
		return $this->Lang('message_postuninstall');
	}
	function UninstallPreMessage() {
		return $this->Lang('message_confirmuninstall');
	}

	// Prepare a list of the possible price adjustment types
	function BuildListOfAdjustTypes() {
		/*	P - Adds the adjustment to the product price
			M - Subtracts the adjustment from the product price
			T - Multiplies the product price time the adjustment factor (might be minus factor!)
			V - Overrides the product price with given factor
		*/
		$adjusttypedropdown = array();
		$adjusttypedropdown[$this->Lang('adjusttypeplus')] = 'P';
		$adjusttypedropdown[$this->Lang('adjusttypemin')] = 'M';
		$adjusttypedropdown[$this->Lang('adjusttypetimes')] = 'T';
		$adjusttypedropdown[$this->Lang('adjusttypevalue')] = 'V';

		return $adjusttypedropdown;
	}

	function BuildListInventoryTypes() {
		$inventorytypes = array();
		$inventorytypes[$this->Lang('inventorytype_none')] = 'none';
		$inventorytypes[$this->Lang('inventorytype_prod')] = 'prod';
		$inventorytypes[$this->Lang('inventorytype_attr')] = 'attr';

		return $inventorytypes;
	}

	function BuildListSKU() {
		$db = cmsms()->GetDb();
		$dict = NewDataDictionary($db);
		$sql = 'SELECT sku, description FROM '.cms_db_prefix().'module_sms_product_skus
		        ORDER BY sku';
		$dbresult = $db->Execute( $sql );
		if( !$dbresult ) {
			return false;
		}
		$sku_list = array();
		while( $row = $dbresult->FetchRow() ) {
			$sku_list[$row['sku'].' - '.$row['description']] = $row['sku'];
		}
		return $sku_list;	
	}
	
	function BuildListSalesInventTiming() {
		$salesinventtiming = array();
		//$salesinventtiming[$this->Lang('salesinventtiming_int')] = 'INT';
		$salesinventtiming[$this->Lang('salesinventtiming_cnf')] = 'CNF';
		$salesinventtiming[$this->Lang('salesinventtiming_pay')] = 'PAY';
		$salesinventtiming[$this->Lang('salesinventtiming_shp')] = 'SHP';
		$salesinventtiming[$this->Lang('salesinventtiming_inv')] = 'INV';

		return $salesinventtiming;
	}
	
	function BuildThumb ($image, $sourcedir, $thumbwidth = 0,  $thumbheight=0) {

		ini_set("memory_limit","30M");
		$imgsize = getimagesize($sourcedir.DIRECTORY_SEPARATOR.$image);
		if (!$imgsize) {
			return false;
		}

		if ($thumbwidth == 0 && $thumbheight == 0) {
			$targetsize[0] = $imgsize[0];	// Target Height
			$targetsize[1] = $imgsize[1];	// Target Width
		} elseif ($thumbwidth == 0 && $thumbheight != 0) 	{
			$targetsize[0] = round($thumbheight*($imgsize[0]/$imgsize[1])); 
			$targetsize[1] = $thumbheight; 
		} elseif ($thumbwidth != 0 && $thumbheight == 0) 	{
			$targetsize[0] = $thumbwidth; 
			$targetsize[1] = round($thumbwidth*($imgsize[0]/$imgsize[1])); 
		}
		else {
			if (round($thumbwidth*($imgsize[0]/$imgsize[1])) > $thumbheight)
				{
					$targetsize[0] = $thumbheight;
					$targetsize[1] = round($thumbheight*($imgsize[1]/$imgsize[0])); 
				} else {
					$targetsize[0] = round($thumbwidth*($imgsize[0]/$imgsize[1])); 
					$targetsize[1] = $thumbwidth;
				}
		}
		$imagetype = $imgsize[2];
		// Type of image can have the following values 
		// 1 = GIF 2 = JPG 3 = PNG
		// For other types see http://www.php.net/manual/en/function.exif-imagetype.php#

		$properties = array ($targetsize[0], $targetsize[1], $imgsize[0], $imgsize[1]);

		switch($imagetype) {
				case 1:
					$srcimg = imagecreatefromgif($sourcedir.DIRECTORY_SEPARATOR.$image);
					break;
				case 2:
					$srcimg = imagecreatefromjpeg($sourcedir.DIRECTORY_SEPARATOR.$image);
					break;
				case 3:
					$srcimg = imagecreatefrompng($sourcedir.DIRECTORY_SEPARATOR.$image);
					break;
				default:
					return false;
		}

		$destinationimg = imagecreatetruecolor($properties[0], $properties[1]);			

		if (
			imagecopyresampled($destinationimg, $srcimg, 0, 0, 0, 0, $properties[0], $properties[1], $properties[2], $properties[3])
			&&
			imagejpeg($destinationimg, $sourcedir.DIRECTORY_SEPARATOR.'tn_'.$image)
		)
		{
			return true;
		} else {
			return false;
		}
	}
	
	function CalculateAttributePrice($price, $priceadjusttype, $priceadjustment) {
		switch ($priceadjusttype) {
			case 'P':
				$price = $price + $priceadjustment;
				break;
			case 'M':
				$price = $price - $priceadjustment;
				break;
			case 'T':
				$price = $price * $priceadjustment;
				break;
			case 'V':
				$price = $priceadjustment;
				break;
		}
		return $price;
	}

	/*---------------------------------------------------------
		 CheckItemOnStock($itemnumber, $itemtype)
		 Using this function a check is done if inventory is available
		 use: if ($this->CheckItemOnStock($attribute['itemnumber'], 'attr')) {
	        }
	     An array is returned with boolean if stock is available and 
	     quantity available is also included
	  ---------------------------------------------------------*/
	function CheckItemOnStock($itemnumber, $itemtype) {
		// Initialize the Database
		$db = cmsms()->GetDb();
		$ItemOnStock = array();
		$ItemOnStock['onstock'] = false;
		
	// Function not in use. Will be used if inventory file will be included
		switch ($itemtype) {
			case 'prod':
				$query = 'SELECT * FROM '.cms_db_prefix().'module_sms_products 
					WHERE itemnumber = ?';
				$row = $db->GetRow($query, array($itemnumber));
				if ($row && $row['maxattributes'] > 0) {
					$ItemOnStock['onstock'] = true;
					$ItemOnStock['quantityonstock'] = $row['maxattributes'];
				}
				break;
			case 'attr':
				$query = 'SELECT * FROM '.cms_db_prefix().'module_sms_product_attributes 
					WHERE itemnumber = ?';
				$row = $db->GetRow($query, array($itemnumber));
				if ($row && $row['maxallowed'] > 0) {
					$ItemOnStock['onstock'] = true;
					$ItemOnStock['quantityonstock'] = $row['maxallowed'];
				}
				break;
		} 
		return $ItemOnStock;
	}
	/*---------------------------------------------------------
	   DisplayErrorPage()
	   This is a simple function for generating error pages.
	  ---------------------------------------------------------*/
	function DisplayErrorPage($id, &$params, $return_id, $message='')
	{
		$this->smarty->assign('title_error', $this->Lang('error'));
		$this->smarty->assign_by_ref('message', $message);

	    // Display the populated template
	    echo $this->ProcessTemplate('error.tpl');
	}
	
	// Completely expand category tree
	function FillCatList($parent, $level, $returnid) 
	{
		$db = cmsms()->GetDb();
		$old_fetchmode = $db->SetFetchMode('ADODB_FETCH_NUM');
		
		$query = "SELECT category_id, name, parent_id 
			FROM ".cms_db_prefix()."module_sms_categories 
			WHERE category_id<>0 AND parent_id = ? AND active = 1 
			ORDER BY position, name";
		$dbresult = $db->Execute( $query, array($parent) );
		$a = array();
		if (!$dbresult) {
			echo 'Error found: result = '.$db->ErrorMsg().'<br/>&nbsp;&nbsp;'.$db->sql.'<br/>'; #die();
		}
		else {
			$row = array();                               
			while ($dbresult && $row = $dbresult->FetchRow()) {
				// Check the number of active products connected to this category
				$query2 = 'SELECT count(*) as num_products FROM '.cms_db_prefix().'module_sms_product_category pc,
					'.cms_db_prefix().'module_sms_products p WHERE category_id=? AND pc.product_id = p.product_id AND 
					p.active = 1';
				$dbresult2 = $db->Execute( $query2, array( $row[0] ));
				$prodrow = $dbresult2->FetchRow();
				$row[4] = $prodrow['num_products'];

	      $destpage = $detailpage!=''?$detailpage:$returnid;
				$sendtodetail = array('category_id'=>$row[0],	'detailpage'=>$destpage);
				$prettyurl = 'ShopMadeSimple/cat/'.$row[0].'/'.$destpage;
				if (isset($sendtodetail['detailtemplate'])) {
					$prettyurl .= '/d,' . $sendtodetail['detailtemplate'];
				}
				if ($row[4] != 0) {
					$row[1] = $this->CreateLink($id, 'fe_product_list', $destpage, $row[1],
						$sendtodetail,'', false, false, '', true, $prettyurl);
				} 
				$row[3] = $level;
	
				$a[] = $row;
				
				// Process subcategories
				$b = $this->FillCatList($row[0], $level+1, $returnid);
				// Add $b[] to the end of $a[]
				for ($j=0; $j<count($b); $j++) {
					$a[] = $b[$j];
				}
			}		
	  }
	
		$db->SetFetchMode($old_fetchmode);
		return $a;
		
	}
	
	// Completely expand category tree for use in the Quick Selector
	function FillQSCatList($parent, $level, $returnid) 
	{
		$db = cmsms()->GetDb();
		$old_fetchmode = $db->SetFetchMode('ADODB_FETCH_NUM');
		
		$query = "SELECT category_id, name, parent_id 
			FROM ".cms_db_prefix()."module_sms_categories 
			WHERE category_id<>0 AND parent_id = ? AND active = 1 
			ORDER BY position, name";
		$dbresult = $db->Execute( $query, array($parent) );
		$a = array();
		if (!$dbresult) {
			echo 'Error found: result = '.$db->ErrorMsg().'<br/>&nbsp;&nbsp;'.$db->sql.'<br/>'; #die();
		}
		else {
			$row = array();
			$id = 'm1_';
			while ($dbresult && $row = $dbresult->FetchRow()) {
				// Check the number of active products connected to this category
				$query2 = 'SELECT count(*) as num_products FROM '.cms_db_prefix().'module_sms_product_category pc,
					'.cms_db_prefix().'module_sms_products p WHERE category_id=? AND pc.product_id = p.product_id AND 
					p.active = 1';
				$dbresult2 = $db->Execute( $query2, array( $row[0] ));
				$prodrow = $dbresult2->FetchRow();
				$row[4] = $prodrow['num_products'];
				$row[1] = $this->CreateLink( $id, 'category_list', $returnid, $row[1], 
					array ('current_category_id' => $row[0]));
				$row[3] = $level;
	
				$a[] = $row;
				// Process subcategories
				$b = $this->FillQSCatList($row[0], $level+1, $returnid);
				// Add $b[] to the end of $a[]
				for ($j=0; $j<count($b); $j++) {
					$a[] = $b[$j];
				}
			}		
	  }
	
		$db->SetFetchMode($old_fetchmode);
		return $a;
		
	}

	function FormatPrice($price) {
		// Check if CartMS has been installed
		global $CMS_VERSION;
		if (version_compare($CMS_VERSION,'1.10-beta0','>') &&
			version_compare($CMS_VERSION,'1.11','<')) {
			$modops = cmsms()->GetModuleOperations();
			$CartMS = $modops->get_module_instance('CartMadeSimple');
		}
		else {
			$gCms = cmsms();
			$CartMS =& $gCms->modules['CartMadeSimple']['object'];
		}
		if ($CartMS) {
			$decimalpositions = $CartMS->GetPreference('numberformatdecimals', 2);
			$decimalseperator = $CartMS->GetPreference('numberformatdec_point', '.');
			$thousandseperator = $CartMS->GetPreference('numberformatthousand_sep', '');
		}
		else {
			$decimalpositions = $this->GetPreference('decimalpositionsprice', 2);
			$decimalseperator = $this->GetPreference('decimalseparatorprice', '.');
			$thousandseperator = $this->GetPreference('thousandseparatorprice', '');
		}
		return number_format($price, $decimalpositions, $decimalseperator, $thousandseperator);
	}	

	function FormatWeight($weight) {
		$decimalpositions = $this->GetPreference('decimalpositionsweight', 3);
		$decimalseperator = $this->GetPreference('decimalseparatorweight', '.');
		$thousandseperator = $this->GetPreference('thousandseparatorweight', '');
		return number_format($weight, $decimalpositions, $decimalseperator, $thousandseperator);
	}	

	function ImageAddToCartSource () {
		$config = cmsms()->GetConfig();
		//$config = $gCms->GetConfig();
		// Prepare link with image (Feat Req#3324)
		return $config['root_url'].DIRECTORY_SEPARATOR.'modules'.DIRECTORY_SEPARATOR.
				$this->GetName().DIRECTORY_SEPARATOR.'images'.DIRECTORY_SEPARATOR.'addtocart.gif';

	}
	
	function RebuildThumbnails($sourcedir, $type='products') {
		$images = array();
		// Set pattern 
		$pattern = "tn_*"; 
		// Change to named directory 
		chdir($sourcedir); 
		// Find files matching pattern 
		$images = glob($pattern); 
		// Iterate over files array and delete existing thumbnails
		foreach ($images as $f) { 
			unlink($f);
		} 
		
		// Prepare an array with the available images
		$pattern = "*"; 
		$images = glob($pattern); 
		$thumbwidth = $this->GetPreference('tnwidth_product', '100');
		$thumbheight = $this->GetPreference('tnheight_product', '100');
		// Use next image found in list of available images and prepare thumbnail
		foreach ($images as $f) { 
			$this->BuildThumb ($f, $sourcedir, $thumbwidth, $thumbheight);
		}

		return;
	}

	// Function that is used by the search module
	function SearchResultWithParams( $returnid, $product_id, $attr='', $parms)   {
		$result = array();
		if ($attr == 'product') {
			$db = cmsms()->GetDb();
			$q = "SELECT name FROM ".cms_db_prefix()."module_sms_products WHERE product_id = ?";
			$dbresult = $db->Execute( $q, array( $product_id ) );
			if ($dbresult) {
				$row = $dbresult->FetchRow(); 
				// 0 position is the prefix displayed in the list results.
				$result[0] = $this->GetFriendlyName();

				// 1 position is the title
				$result[1] = $row['name'];


				// Page to use for the news-article-details:
				if (isset($parms['detailpage'])) {    
					$pagealias = $parms['detailpage'];
				}  
				else $pagealias = 'home';  
				$pageinfo = PageInfoOperations::LoadPageInfoByContentAlias($pagealias);
				$content_id = $pageinfo->content_id;
				$prettyurl = 'ShopMadeSimple'.DIRECTORY_SEPARATOR.$product_id.DIRECTORY_SEPARATOR.$content_id;

				// 2 position is the URL to the title. 
				$result[2] = $this->CreateLink('cntnt01', 'fe_product_detail', $returnid, '', 
				array('product_id' => $product_id), '', true, false, '', true, $prettyurl);
			}
		}
		return $result;
	}

	/*---------------------------------------------------------
		This function will remove all the search index entries of this module
		and after rebuild the index
	  ---------------------------------------------------------*/
	function SearchReindex() {
		global $CMS_VERSION;
		if (version_compare($CMS_VERSION,'1.10-beta0','>') &&
			version_compare($CMS_VERSION,'1.11','<')) {
			$modops = cmsms()->GetModuleOperations();
			$searchmodule = $modops->get_module_instance('Search');
		}
		else {
			$gCms = cmsms();
			$searchmodule =& $gCms->modules['Search']['object'];
		}
		if ($searchmodule != FALSE) {
			$db = cmsms()->GetDb();
			// First remove all the search index entries
			$searchmodule->DeleteWords($this->GetName());
			// Add index entries for the active products
			$query = 'SELECT * FROM '.cms_db_prefix().'module_sms_products
				WHERE active = 1';
			$dbresult = &$db->Execute($query);
			while ($dbresult && $row = $dbresult->FetchRow() ) {
				$searchmodule->AddWords($this->GetName(), $row['product_id'], 'product', $row['name'] . ' ' . $row['description']);
			}
			// Attributes are not included in the search since they are only available
			// via products (there doesn't exist a attribute detail page)
		}
	}

	/*---------------------------------------------------------
		This function allow retrieval from preferences from this module
		when needed in another module
	  ---------------------------------------------------------*/	
	function GetSMSPreference($preference, $default='') {
		return $this->GetPreference($preference, $default);
	}
}

?>