<?php
# BirthdayListing (Who is celebrating today his/her birthday?). A module for CMS - CMS Made Simple
# This module has specially written for the first Dutch Workshop on CMSMS held Januari 24th 2009
# Copyright (c) 2009-2011 by Duketown 
#
# This function will add a birthday
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/birthdaylisting
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

if (!$this->CheckPermission('Use Birthday Listing'))
{
	echo $this->ShowErrors($this->Lang('accessdenied', array('Use Birthday Listing')));
	return;
}

if (isset($params['cancel']))
{
	$params = array('active_tab' => 'birthdays');
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
}

$user_id = '';
if (get_userid() ) {
	$user_id = get_userid();
}
$dateformat = get_preference( $user_id, 'dateformat');
$splitdateused = $this->GetPreference('splitdateused', true);
// Check if information has been entered. If so save it to shorter name
$name = '';
if (isset($params['name'])) {
	$name = $params['name'];
}

$birthday = 0;
if (isset($params['birthday'])) {
	$birthday = $params['birthday'];
}

$birthday = time();
if (isset($params['birthday_Month'])) {
	$birthday = mktime(0, 0, 0, $params['birthday_Month'], $params['birthday_Day'], $params['birthday_Year']);
}
$usedbirthdate = 0;
$sqlbirthdate = $this->PrepareSQLDate($usedbirthdate, $dateformat);
if (isset($params['birthdate'])) {
	$usedbirthdate = $params['birthdate'];
	$sqlbirthdate = $this->PrepareSQLDate($usedbirthdate, $dateformat);
}
$sqlbirthdate .= ' 00:00:00';

$deceased = 0;
if (isset($params['deceased'])) {
	$deceased = $params['deceased'];
}
$isdead = 0;
if (isset($params['isdead'])) {
	$isdead = $params['isdead'];	
}
if ($isdead != 0) {
	if (isset($params['deceased_Month'])) {
		$deceased = mktime(0, 0, 0, $params['deceased_Month'], $params['deceased_Day'], $params['deceased_Year']);
	}
	$useddeceaseddate = 0;
	$sqldeceaseddate = $this->PrepareSQLDate($useddeceaseddate, $dateformat);
	if (isset($params['deceaseddate'])) {
		$useddeceaseddate = $params['deceaseddate'];
		$sqldeceaseddate = $this->PrepareSQLDate($useddeceaseddate, $dateformat);
	}
	$sqldeceaseddate .= ' 00:00:00';
}
else {
	$deceased = 0;
}

if (isset($params['submit']))
{
	if ($name != '')
	{
		$birthday_id = $db->GenID(cms_db_prefix().'module_birthdaylisting_birthdays_seq');
		if ($splitdateused) {
			$birthday = trim($db->DBTimeStamp($birthday), "'");
			if ($isdead) {
				$deceased = trim($db->DBTimeStamp($deceased), "'");
			}
		}
		else {
			$birthday = $sqlbirthdate;
			$deceased = $sqldeceaseddate;
		}
		$query = 'INSERT INTO '.cms_db_prefix().'module_birthdaylisting_birthdays (
			birthday_id, name, birthday, deceased)
			VALUES (?,?,?,?)';
		$db->Execute($query, array($birthday_id, $name, $birthday, $deceased));

		$params = array('tab_message'=> 'birthdayadded', 'active_tab' => 'birthdays');
		$this->Redirect($id, 'defaultadmin', $returnid, $params);
	}
	else
	{
		$this->ShowErrors($this->Lang('nonamegiven'));
	}
}

# Display template
$smarty->assign('startform', $this->CreateFormStart($id, 'addbirthday', $returnid));
$smarty->assign('endform', $this->CreateFormEnd());
$smarty->assign('nametext', '*'.$this->Lang('name'));
$smarty->assign('inputname', $this->CreateInputText($id, 'name', $name, 40, 80));
$smarty->assign('splitdateused', $splitdateused);
$smarty->assign('birthdaytext', $this->Lang('birthdate'));
$smarty->assign_by_ref('birthday', $birthday);
$smarty->assign('birthdayprefix', $id.'birthday_');
$smarty->assign('input_birthdate', $this->CreateInputText($id, 'birthdate', $usedbirthdate, 11, 20));
$smarty->assign('isdeadtext', $this->Lang('isdead'));
$onclickevent = 'onclick='. '"toggleDisplay(\'show_all\');"';
$smarty->assign('inputisdead', $this->CreateInputCheckbox($id, 'isdead', true, 0, $onclickevent));
$smarty->assign('deceasedtext', $this->Lang('deceased'));
$smarty->assign_by_ref('deceased', $deceased);
$smarty->assign('deceasedprefix', $id.'deceased_');
$smarty->assign('isdeadornot', $isdead);
$smarty->assign('input_deceaseddate', $this->CreateInputText($id, 'deceaseddate', $useddeceaseddate, 11, 20));
$smarty->assign('hidden', $this->CreateInputHidden($id,'hiddenisdead',$isdead));
$smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
echo $this->ProcessTemplate('editbirthday.tpl');
?>
