<?php
#-------------------------------------------------------------------------
# Module: BirthdayListing - Gives an overview of the person that are celebrating their birthday.
# This module has specially written for the first Dutch Workshop on CMSMS held Januari 24th 2009
# Version: 1.0.0, Duketown
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2009 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
# This file originally created by ModuleMaker module, version 0.3.1
# Copyright (c) 2009 by Samuel Goldstein (sjg@cmsmadesimple.org) 
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class BirthdayListing extends CMSModule
{

	function GetName()
	{
		return 'BirthdayListing';
	}

	function GetFriendlyName()
	{
		return $this->Lang('friendlyname');
	}

	
	function GetVersion()
	{
		return '1.2';
	}

	function GetHelp()
	{
		return $this->Lang('help');
	}

	function GetAuthor()
	{
		return 'Duketown';
	}

	function GetAuthorEmail()
	{
		return '';
	}

	function GetChangeLog()
	{
		return file_get_contents(dirname(__FILE__).'/changelog.inc');
	}

	function IsPluginModule()
	{
		return true;
	}

	function HasAdmin()
	{
		return true;
	}


	function GetAdminSection()
	{
		return 'extensions';
	}


	function GetAdminDescription()
	{
		return $this->Lang('admindescription');
	}


	function VisibleToAdminUser()
	{
        return true;
	}
	

	function CheckAccess($perm = 'Use Birthday Listings')
		{
		return $this->CheckPermission($perm);
		}
	
    function DisplayErrorPage($id, &$params, $return_id, $message='')
    {
		$this->smarty->assign('title_error', $this->Lang('error'));
		$this->smarty->assign_by_ref('message', $message);

        // Display the populated template
        echo $this->ProcessTemplate('error.tpl');
    }
	
	/*---------------------------------------------------------
	   SetParameters()
	   Description of the available parameters for the front end
	  ---------------------------------------------------------*/
	function SetParameters()
	{
		$this->CreateParameter('showage', '', $this->Lang('helpshowage'));
		$this->CreateParameter('showdeceased', '', $this->Lang('helpshowdeceased'));
		$this->CreateParameter('summarytemplate', '', $this->Lang('helpsummarytemplate'));
		$this->CreateParameter('withindays', '0', $this->Lang('helpwithindays'));
		
		$this->SetParameterType('showage',CLEAN_STRING);
		$this->SetParameterType('showdeceased',CLEAN_STRING);
		$this->SetParameterType('summarytemplate',CLEAN_STRING);
		$this->SetParameterType('withindays',CLEAN_INT);		
	}

	function GetDependencies()
	{
		return array();
	}

	function MinimumCMSVersion()
	{
		return '1.9.3';
	}


	function MaximumCMSVersion()
	{
		return '1.10';
	}


	function InstallPostMessage()
	{
		return $this->Lang('postinstall');
	}

	function UninstallPostMessage()
	{
		return $this->Lang('postuninstall');
	}

	function UninstallPreMessage()
	{
		return $this->Lang('really_uninstall');
	}

	/*---------------------------------------------------------
	   GetHeaderHTML()
	   This function inserts javascript (and links) into header of HTML
	  ---------------------------------------------------------*/
	function GetHeaderHTML()
	{
		$javascript = '';
		// Include javascript so easy date selection is possible
		$javascript .= '<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.3.2/jquery.min.js"></script>';
		$javascript .= '<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jqueryui/1.7.2/jquery-ui.min.js"></script>';
		$javascript .= '<link type="text/css" rel="stylesheet" href="http://ajax.googleapis.com/ajax/libs/jqueryui/1.7.2/themes/smoothness/jquery-ui.css" />';

		$javascript .= '<script type="text/javascript">
			$(document).ready(function() {
				$(function() {$(\'div.datepicker input\').datepicker({dateFormat: \''.$this->GetPreference('dateformat', 'd-m-yy').'\'});});
				});
				</script>';
		// Include script so sorting of tables in backend is possible
		$javascript .= '<script type="text/javascript" src="../modules/JQueryTools/lib/jquery.tablesorter.js"></script>'."\n";
		$javascript .= '<link rel="stylesheet" type="text/css" href="../modules/JQueryTools/lib/css/JQueryTools.css" media="screen" />'."\n";
		$javascript .= '<script type="text/javascript" id="js">jQuery(document).ready(function() 
		{ 
			jQuery(".cms_sortable")
				.tablesorter( 
				); 
		} 
		); 
		</script>';

		return $javascript;
	}

	function GetDefaultTemplate($template)
	{
	  $fn = sprintf('orig_%s_template.tpl',$template);
	  $fn = cms_join_path(dirname(__FILE__),'templates',$fn);
	  $data = @file_get_contents($fn);
	  return $data;
	}

	/*---------------------------------------------------------
	   CalculateNumYears()
	   This function calculates the number of years between now and past date
	   If person died, age is calculated and date of death is also returned
	  ---------------------------------------------------------*/
	function CalculateNumYears($birthday, $deceased) {
		list($year,$month,$day) = explode("-",$birthday);
		if ($deceased == 0) {
			$year_diff  = date("Y") - $year;
			$month_diff = date("m") - $month;
			$day_diff   = date("d") - $day;
		}
		else {
			list($dyear,$dmonth,$dday) = explode("-",$deceased);
			$year_diff  = $dyear - $year;
			$month_diff = $dmonth - $month;
			$day_diff   = $dday - $day;
		}
		if (($day_diff < 0 && $month_diff == 0) || ($month_diff < 0))
			$year_diff--;
		return $year_diff;
	}

	/* --------------------------------------------------------
		GetDateformats()
		A function to return all possible date formats in an array
		--------------------------------------------------------*/	
	function GetDateformats()
	{
		$dateformatlist = array();
		$dateformatlist['d-m-Y'] = 'd-m-yy';
		$dateformatlist['m-d-Y'] = 'm-d-yy';
		
		return $dateformatlist;
	}

	/*---------------------------------------------------------
	   GetDashboardOutput()
	   This function is used by Admin\dashboard.php.
	   The string that is prepared in this function is displayed on the dashboard.
	   This function has become obsolete as of 1.6 since the Dashboard is not 
	   supported anymore. Has been left in for later usage.
	  ---------------------------------------------------------*/
	function GetDashboardOutput()
	{
		$db = cmsms()->GetDb();
		$this_num_month = intval(date('m'));
		$this_num_day = intval(date('d'));
		$query = 'SELECT count(*) FROM '.cms_db_prefix ().'module_birthdaylisting_birthdays WHERE 
			MONTH(birthday) = ? AND DAY(birthday) = ? and deceased=0';
		$row = &$db->GetRow($query, array($this_num_month, $this_num_day));
		if ($row['count(*)'] > 0) {
			$output = $this->Lang('todaybirthdays', $row['count(*)']);
		} else {
			$output = $this->Lang('nobodybirthday');
		}
		return $output;
	}

	/* --------------------------------------------------------
		GetListOrderBackend()
		A function to return array with possible sort by options
		--------------------------------------------------------*/	
	function GetListOrderBackend()
	{
		$orderbackendlist = array();
		$orderbackendlist[$this->Lang('orderbyname')] = 'name';
		$orderbackendlist[$this->Lang('orderbymonthday')] = 'monthday';
		
		return $orderbackendlist;
	}

	/* --------------------------------------------------------
		GetListPageLimit()
		A function to return fill array with possible pagelimits
		--------------------------------------------------------*/	
	function GetListPageLimit()
	{
		$pagelimitlist = array();
		$pagelimitlist['5'] = 5;
		$pagelimitlist['10'] = 10;
		$pagelimitlist['25'] = 25;
		$pagelimitlist['50'] = 50;
		$pagelimitlist['100'] = 100;
		$pagelimitlist[$this->Lang('unlimited')] = 99999999;
		
		return $pagelimitlist;
	}

	/* --------------------------------------------------------
		PrepareSQLDate($date2convert, $dateformat = '')
		A function that returns date in format used in sql statements
		--------------------------------------------------------*/	
	function PrepareSQLDate($date2convert, $dateformat = '')
	{
		$datesep = '-';
		// Retrieve the input date format used
		if ($dateformat == '') {
			$dateformat = $this->GetPreference('dateformat', 'd-m-yy');
		}
		$date =explode("-",$date2convert);
		switch ($dateformat) {
		case 'd-m-yy':
			$date_y = $date[2] ;
			$date_m = $date[1] ;
			$date_d = $date[0] ;
			break;
		case 'm-d-yy':
			$date_y = $date[2] ;
			$date_m = $date[0] ;
			$date_d = $date[1] ;
			break;
		}
		return $date_y.$datesep.$date_m.$datesep.$date_d;
	}

	/* --------------------------------------------------------
		PrepareShowDate($date2convert, $dateinformat = '', $dateformat = '')
		A function that returns date in format used for maintaining it
		--------------------------------------------------------*/	
	function PrepareShowDate($date2convert, $dateinformat = '', $dateformat = '')
	{
		$datesep = '-';
		// Retrieve the output date format used
		if ($dateformat == '') {
			$dateformat = $this->GetPreference('dateformat', 'd-m-yy');
		}
		$date =explode("-",$date2convert);
		switch ($dateinformat) {
		case 'd-m-yy':
			$date_y = $date[2] ;
			$date_m = $date[1] ;
			$date_d = $date[0] ;
			if ($dateformat == 'd-m-yy') {
				return $date2convert;
			}
			else {
				return $date_m.$datesep.$date_d.$datesep.$date_y;
			}
			break;
		case 'm-d-yy':
			$date_y = $date[2] ;
			$date_m = $date[0] ;
			$date_d = $date[1] ;
			if ($dateformat == 'm-d-yy') {
				return $date2convert;
			}
			else {
				return $date_m.$datesep.$date_d.$datesep.$date_y;
			}
			break;
		case 'yy-m-d':
			$date_y = $date[0] ;
			$date_m = $date[1] ;
			$date_d = substr($date[2], 0, 2) ;
			if ($dateformat == 'm-d-yy') {
				return $date_m.$datesep.$date_d.$datesep.$date_y;
			}
			else {
				return $date_d.$datesep.$date_m.$datesep.$date_y;
			}
			break;
		}
		return $date_y.$datesep.$date_m.$datesep.$date_d;
	}

}

?>