<?php
# BirthdayListing (Who is celebrating today his/her birthday?). A module for CMS - CMS Made Simple
# This module has specially written for the first Dutch Workshop on CMSMS held Januari 24th 2009
# Copyright (c) 2009-2010 by Duketown
#
# This function will create tables and generate records needed for the module Birthday Listing
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/birthdaylisting
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

// Typical Database Initialization
$db = cmsms()->GetDb();

// mysql-specific, but ignored by other database
$taboptarray = array('mysql' => 'TYPE=MyISAM');
$dict = NewDataDictionary($db);

$flds = "
	birthday_id I KEY,
	name C(80),
	birthday " . CMS_ADODB_DT . ",
	deceased " . CMS_ADODB_DT . "
	";

// Create it. 
$sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_birthdaylisting_birthdays",
		$flds, $taboptarray);
$dict->ExecuteSQLArray($sqlarray);

// Create a sequence
$db->CreateSequence(cms_db_prefix()."module_birthdaylisting_birthdays_seq");

// Set the templates
$this->SetTemplate('Summary', $this->GetDefaultTemplate('summary'));

// Set Permissions
$this->CreatePermission('Use Birthday Listings','Use Birthday Listings');

// Set Options
$this->SetPreference('splitdateused', true);

// Insert an audit trail on the installation in the admin log
$this->Audit( 0, $this->Lang('friendlyname'), $this->Lang('installed',$this->GetVersion()));

?>