<?php
# BirthdayListing (Who is celebrating today his/her birthday?). A module for CMS - CMS Made Simple
# This module has specially written for the first Dutch Workshop on CMSMS held Januari 24th 2009
# Copyright (c) 2009-2010 by Duketown
#
# This function shows the birthdays of persons on todays date
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/birthdaylisting
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

if (!isset($gCms)) exit;

$db =& $this->GetDb();

$detailpage = '';
if (isset($params['detailpage'])) {
	$manager =& $gCms->GetHierarchyManager();
	$node =& $manager->sureGetNodeByAlias($params['detailpage']);
	if (isset($node)) {
		$content =& $node->GetContent();	
		if (isset($content)) {
			$detailpage = $content->Id();
		}
	} else {
		$node =& $manager->sureGetNodeById($params['detailpage']);
		if (isset($node)) {
			$detailpage = $params['detailpage'];
		}
	}
}

if (isset($params['showage'])) {
	$showage = $params['showage'];
}

$showdeceased = 0;
if (isset($params['showdeceased'])) {
	$showdeceased = $params['showdeceased'];
}

$withindays = 0;
if (isset($params['withindays'])) {
	$withindays = $params['withindays'];
}

// Query prepared by Kasimir to give horizon on coming birthdays 
$query = 'SELECT *, DATEDIFF(birthday + INTERVAL 
	(YEAR(CURRENT_DATE) - YEAR(birthday) + IF(DATE_FORMAT(CURRENT_DATE, "%m%d") > 
	DATE_FORMAT(birthday, "%m%d"), 1, 0)) YEAR, CURRENT_DATE) withind
	FROM '.cms_db_prefix ().'module_birthdaylisting_birthdays 
	HAVING  withind <= '.$withindays;

if ($showdeceased == 0) {
	$query .= ' AND deceased = 0';
}
$query .= ' ORDER BY withind';

$dbresult = $db->Execute ($query);

// The year is not important of the birhtday, so use only the month and day
// $query = 'SELECT * FROM '.cms_db_prefix ().'module_birthdaylisting_birthdays WHERE 
// 	month(birthday) = ? AND day(birthday) = ?';
// if ($showdeceased == 0) {
// 	$query .= ' AND deceased = 0';
// }
// $dbresult = $db->Execute ($query, array($this_num_month, $this_num_day));
$rowentry = array ();
$rowclass = 'row1';

// There can be multiple, so read all the rows that meet the criteria
while ($dbresult && ($row = $dbresult->FetchRow ()))
{
	$onerow = new stdClass ();
	$onerow->id = $row['birthday_id'];
	$onerow->name = $row['name'];
	$onerow->birthday = $row['birthday'];
	$onerow->withindays = $row['withind'];
	// Calculate the age of the person and show it.
	if ($showage == 1) {
		$dob = $row['birthday'];
		$dod = $row['deceased'];
		$onerow->age = $this->CalculateNumYears($dob, $dod);
	}
	$onerow->deceased = '';
	if ($row['deceased'] > 0){
		$onerow->deceased = $row['deceased'];
	}
	$onerow->rowclass = $rowclass;

	array_push ($rowentry, $onerow);
	($rowclass == "row1" ? $rowclass = "row2" : $rowclass = "row1");
}

$this->smarty->assign ('items', $rowentry);
$this->smarty->assign ('itemcount', count ($rowentry));

if ($withindays > 0) {
  $this->smarty->assign ('datetext', $this->Lang('birthdayindays',$withindays));
  $this->smarty->assign ('nobirthdays', $this->GetPreference('nobirthdaystext', $this->Lang('nobirthindays')));
}
else {
  $this->smarty->assign ('datetext', $this->Lang('todaysbirthdates'));  
  $this->smarty->assign ('nobirthdays', $this->GetPreference('nobirthdaystext', $this->Lang('nobirthdays')));
}

//$this->smarty->assign ('datetext', $this->Lang('todaysbirthdates')); 
//$this->smarty->assign ('nobirthdays', $this->GetPreference('nobirthdaystext', $this->Lang('nobirthdays')));

// Display the birthdays
if (isset($params['summarytemplate']))
{
	echo $this->ProcessTemplateFromDatabase($params['summarytemplate']);
}
else
{
	$t = $this->GetTemplate('Summary');
	if(empty($t))
	{
		$this->SetTemplate('Summary', $this->GetDefaultTemplate('summary'));
	}
	echo $this->ProcessTemplateFromDatabase('Summary');
}

?>