<?php
# Team Sport Scores. A module for CMS - CMS Made Simple
# Copyright (c) 2011 by Duketown
#
# This function will handle the back end information for Team Sport Scores
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

$query = '';
$dbresult = '';

$curseason = (isset($params['curseason'])?$params['curseason']:'');
$allseasons = (isset($params['allseasons'])?$params['allseasons']:'no');
$newseason = $curseason;

if (isset($params['submitseason']))
{
	$newseason = (isset($params['newseason'])?$params['newseason']:$newseason);
}

$curseason = $newseason;
$listseason = array();
$listseason[$this->Lang('allseasons')] = '';
$query = "SELECT * FROM ".cms_db_prefix()."module_tss_season ORDER BY start_date, season_desc";
$dbresult = $db->Execute($query);

$rowclass = 'row1';
$entryarray = array();

while ($dbresult && $row = $dbresult->FetchRow())
{
	$onerow = new stdClass();

	$onerow->id = $row['season_id'];
	$onerow->season_desc = $this->CreateLink($id, 'editseason', $returnid, $row['season_desc'], array('season_id'=>$row['season_id']));
	$onerow->start_date = $row['start_date'];
	$onerow->end_date = $row['end_date'];

	// Show the icons needed for editing, deleting
	if ($row['status'] == 'A')
		{
			$onerow->statuslink = $this->CreateLink($id, 'switchstatus', $returnid, 
				$gCms->variables['admintheme']->DisplayImage('icons/system/true.gif',$this->Lang('setinactive'),'','','systemicon'),array('table'=>'Season','status'=>'I','record_id'=>$row['season_id']));
		}
	else
		{
			$onerow->statuslink = $this->CreateLink($id,'switchstatus', $returnid, 
				$gCms->variables['admintheme']->DisplayImage('icons/system/false.gif',$this->Lang('setactive'),'','','systemicon'),array('table'=>'Season','status'=>'A','record_id'=>$row['season_id']));
		}
	$onerow->editlink = $this->CreateLink($id, 'editseason', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('season_id'=>$row['season_id']));
	if ($row['season_id'] > 0 ) {
			$onerow->deletelink = $this->CreateLink($id, 'deleterow', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('table'=>'Seasons','season_id'=>$row['season_id']), $this->Lang('areyousureseason'));
	}

	$onerow->rowclass = $rowclass;

	$entryarray[] = $onerow;

	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}
$smarty->assign_by_ref('items', $entryarray);
$smarty->assign('itemcount', count($entryarray));

// Setup links
$smarty->assign('formstart', $this->CreateFormStart($id, 'defaultadmin', $returnid, $params));
$smarty->assign('addseasonlink', $this->CreateLink($id, 'addseason', $returnid, $this->Lang('addseason'), array(), '', false, false, 'class="pageoptions"'));
$smarty->assign('addseasonlink', $this->CreateLink($id, 'addseason', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addseason'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addseason', $returnid, $this->Lang('addseason'), array(), '', false, false, 'class="pageoptions"'));

$smarty->assign('seasontext', $this->Lang('season'));
$smarty->assign('startdatetext', $this->Lang('seasonstartdate'));
$smarty->assign('enddatetext', $this->Lang('seasonenddate'));
$smarty->assign('formend', $this->CreateFormEnd());

// Display template
echo $this->ProcessTemplate('listseasons.tpl');

?>
