<?php
# Team Sport Scores. A module for CMS - CMS Made Simple
# Copyright (c) 2011 by Duketown
#
# This function will handle the back end information for Team Sport Scores
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/teamsportscores
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

$query = '';
$dbresult = '';

if (isset($params['team_id'])) {
	 $usedteam_id = $params['team_id'];
}
if ($usedteam_id == 'ALL' || $usedteam_id == NULL) {$usedteam_id = -1;}

// Prepare dropdown values for teams
$teamlist = array();
$teamlist = $this->GetListTeams('%', array('ALL'=>$this->Lang('allteams')));

$listmember = array();
$listmember[$this->Lang('allmember')] = '';
// Check the preferences which table to use
$prefusertable = $this->GetPreference('user_table', '');
switch ($prefusertable) 	{
	case 'CMSMS_USR':
		$query = "SELECT m.*, t.team_name AS team_name, 
			CONCAT(u.first_name, ' ', u.last_name) AS member_name,
			username
		FROM "
			.cms_db_prefix(). "module_tss_member m, "
			.cms_db_prefix(). "module_tss_team t, "
			.cms_db_prefix(). 'users u
		WHERE m.team_id = t.team_id AND m.user_id = u.user_id';
		if ($usedteam_id == -1) {
			$query .= ' AND t.team_id <> ?';
		}
		else {
			$query .= ' AND t.team_id = ?';
		}
		$query .= ' ORDER BY u.first_name, u.last_name';
		break;
	case 'FEU_USR':
		$query = "SELECT m.*, t.team_name AS team_name, username AS member_name
		FROM "
			.cms_db_prefix(). "module_tss_member m, "
			.cms_db_prefix().	"module_tss_team t, "
			.cms_db_prefix(). 'module_feusers_users u
		WHERE m.team_id = t.team_id AND m.user_id = u.id';
		if ($usedteam_id == -1) {
			$query .= ' AND t.team_id <> ?';
		}
		else {
			$query .= ' AND t.team_id = ?';
		}
		$query .= ' ORDER BY u.username';
		break;
	case 'MAN_USR':
		$query = "SELECT m.*, t.team_name AS team_name, membername AS member_name
			FROM "
				.cms_db_prefix()."module_tss_member m, "
				.cms_db_prefix().'module_tss_team t 
			WHERE m.team_id = t.team_id ';
		if ($usedteam_id == -1) {
			$query .= ' AND t.team_id <> ?';
		}
		else {
			$query .= ' AND t.team_id = ?';
		}
		$query .= ' ORDER BY membername';
		break;
	default:
		break;
}

$dbresult = $db->Execute($query, array($usedteam_id));

$rowclass = 'row1';
$entryarray = array();

while ($dbresult && $row = $dbresult->FetchRow()) 	{
	$onerow = new stdClass();

	$onerow->id = $row['member_id'];
	if ($row['member_name'] == ' ') {
		$row['member_name'] = $row['username'];
	}
	$onerow->membername = $this->CreateLink($id, 'editmember', $returnid, $row['member_name'], array('member_id'=>$row['member_id']));
	$onerow->team = $row['team_name'];

	switch ($row['type']) {
		case 'PLAYER':
			$onerow->type = $this->Lang('typeplayer');
			break;
		case 'COACH':
			$onerow->type = $this->Lang('typecoach');
			break;
		case 'DOCTOR':
			$onerow->type = $this->Lang('typemedic');
			break;
		case 'GOALIE':
			$onerow->type = $this->Lang('typegoalie');
			break;
		case 'MANAGER':
			$onerow->type = $this->Lang('typemanager');
			break;
		default:
			break;
	}
	if ($row['status'] == 'A') {
		$onerow->statuslink = $this->CreateLink($id, 'switchstatus', $returnid, 
			$gCms->variables['admintheme']->DisplayImage('icons/system/true.gif',$this->Lang('setinactive'),'','','systemicon'),array('table'=>'Member','status'=>'I','record_id'=>$row['member_id']));
	}
	else {
		$onerow->statuslink = $this->CreateLink($id,'switchstatus', $returnid, 
			$gCms->variables['admintheme']->DisplayImage('icons/system/false.gif',$this->Lang('setactive'),'','','systemicon'),array('table'=>'Member','status'=>'A','record_id'=>$row['member_id']));
	}

	// Show the icons needed for editing, deleting
	$onerow->editlink = $this->CreateLink($id, 'editmember', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('member_id'=>$row['member_id']));
	$onerow->deletelink = $this->CreateLink($id, 'deleterow', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('table'=>'Members','member_id'=>$row['member_id']), $this->Lang('areyousuremember'));

	$onerow->rowclass = $rowclass;

	$entryarray[] = $onerow;

	($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
}
$smarty->assign_by_ref('items', $entryarray);
$smarty->assign('itemcount', count($entryarray));

// Setup links
$smarty->assign('addmemberlink', $this->CreateLink($id, 'addmember', $returnid, $this->Lang('addmember'), array('team_id'=>$usedteam_id), '', false, false, 'class="pageoptions"'));
$smarty->assign('addmemberlink', $this->CreateLink($id, 'addmember', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addmember'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addmember', $returnid, $this->Lang('addmember'), array('team_id'=>$usedteam_id), '', false, false, 'class="pageoptions"'));

$smarty->assign('formstart', $this->CreateFormStart($id, 'defaultadmin', $returnid, $params));
$smarty->assign('memberfiltertitle', $this->Lang('memberfiltertitle'));
$smarty->assign('teamtitle', $this->Lang('team'));
$smarty->assign('teamidinput', $this->CreateInputDropdown($id, 'team_id', $teamlist, -1, $usedteam_id));
$smarty->assign('membertext', $this->Lang('membername'));
$smarty->assign('teamtext', $this->Lang('team_name'));
$smarty->assign('typetext', $this->Lang('membertype'));
$smarty->assign('statustext', $this->Lang('status'));
$smarty->assign('submitmemberfilter', $this->CreateInputSubmit($id,'submitmemberfilter',$this->Lang('submit')));
$smarty->assign('hidden', $this->CreateInputHidden($id, 'active_tab', 'members'));
$smarty->assign('formend', $this->CreateFormEnd());

// Display template
echo $this->ProcessTemplate('listmembers.tpl');

?>
