
{if isset($message) }<p>{$message}</p>{/if}
{$startform}
<fieldset>
<legend>Visual framework:</legend>
	<div class="pageoverflow">
            <p class="pagetext"></p>
            <p class="pageinput">
		<label>
                    {$input_visual}
                </label><br/>
            </p>
	</div>
</fieldset>
<fieldset>
<legend>OpenID library settings:</legend>
	<div class="pageoverflow">
            <p class="pagetext">Buggy GMP support</p>
            <p class="pageinput">
		<label>
                    <strong>{$buggy_gmp_status}</strong>
                </label>
                </p>
            <p class="pageinput">
            From the OpenID PHP library readme-file:<br/><i>In some cases, bugs in the GMP math library will result in signature
validation errors when using this library. Since GMP is preferred
over bcmath (for performance), you will have to define
Auth_OpenID_BUGGY_GMP in your application *before* importing any of
the library code</i></p>
            <p class="pageinput">
                Enable this option by setting <i>openid.buggy.gmp</i> to TRUE in config.php
            </p>
	</div>
	<div class="pageoverflow">
            <p class="pagetext">Random number source</p>
            <p class="pageinput">
		<label>
                    <strong>{$insecure_rand_status}</strong>
                </label><br/>
            </p>
            <p class="pageinput">
            From the OpenID PHP library readme-file:<br/><i>On some systems, PHP basedir restrictions prevent web servers from
opening a source of randomness, such as /dev/urandom.  If your PHP
OpenID library has trouble getting a satisfactory source of
randomness, check your Apache and PHP configurations to be sure that
the randomness source is in the list of allowed paths for the
"open_basedir" option</i><br/>
            Enabling this option will set the random source to null, forcing the OpenID library to fallback to a pseudorandom number source.</p>
            <p class="pageinput">
                Enable this option by setting <i>openid.insecure.rand</i> to TRUE in config.php
            </p>
	</div>
	<div class="pageoverflow">
             <p class="pagetext">Root CA certificate file</p>
            <p class="pageinput">
		<label>
                    <strong>{$ca_file_override_status}</strong>
                </label>
            </p>
            <p class="pageinput">
            Systems using older versions of curl cannot verify some providers when connecting to them using https since the
            root certificate file bundled with curl does not contain the root certificate for the https certificate that the provider is using.
            <br/>
            Before enabling this option you'll have to download cacert.pem from <a href="http://curl.haxx.se/docs/caextract.html">the curl site</a> and place in /modules/OpenID/
            </p>
            <p class="pageinput">
                
            </p>
	</div>
</fieldset>
<fieldset>
    <legend>Redirect after login:</legend>
	<div class="pageoverflow">
            <p class="pagetext"></p>
            <p class="pageinput">
		<label>
                    {$input_login_redirect}
                </label>
            </p>
             <p class="pagetext">Redirect to page-ID/-alias after successful OpenID login:</p>
              <p class="pageinput">
                {$input_login_redirect_pageid}
              </p>
	</div>
</fieldset>
<fieldset>
<legend>Facebook:</legend>
	<div class="pageoverflow">
            <p class="pagetext">Application ID</p>
            <p class="pageinput">
		<label>
                    {$input_facebook_app_id}
                </label><br/>
            </p>
            <p class="pageinput">
            The application ID is the unique ID that identifies your application when logging in using Facebook. Get it at <a href="http://www.facebook.com/developers/" target="_blank">Facebook Developers</a>
            </p>
	</div>
	<div class="pageoverflow">
            <p class="pagetext">Application secret</p>
            <p class="pageinput">
		<label>
                    {$input_facebook_app_secret}
                </label><br/>
            </p>
            <p class="pageinput">
            The application secret is a value that is known only by you and Facebook.
            This makes it possible to generate checksums that both you and Facebook can validate.
            You get it at the same time as the application ID.
            </p>
	</div>
</fieldset>
<fieldset>
<legend>Twitter:</legend>
	<div class="pageoverflow">
            <p class="pagetext">Consumer key</p>
            <p class="pageinput">
		<label>
                    {$input_twitter_consumer_key}
                </label><br/>
            </p>
            <p class="pageinput">
                The Twitter consumer key is used to identify your application. Register your app and get a key at <a href="http://twitter.com/oauth_clients/">Twitter OAuth Clients</a>
            </p>
	</div>
	<div class="pageoverflow">
            <p class="pagetext">Consumer secret</p>
            <p class="pageinput">
		<label>
                    {$input_twitter_consumer_secret}
                </label><br/>
            </p>
            <p class="pageinput">
            The consumer secret is a value that is known only by you and Twitter.
            This makes it possible to generate checksums that both you and Twitter can validate.
            You get it at the same time as the consumer key.
            </p>
	</div>
</fieldset>
<fieldset>
<legend>Debugging:</legend>
	<div class="pageoverflow">
            <p class="pageinput">
		<label>
                    <strong>{$debug_status}</strong>
                </label>
                </p>
                <p class="pageinput">
                    Enable debugging by setting <i>openid.debug</i> to TRUE in config.php
                </p>
	</div>
</fieldset>

	<div class="pageoverflow">
		<p class="pagetext">&nbsp;</p>
		<p class="pageinput">{$hidden}{$submit}{$cancel}</p>
	</div>
{$endform}