<?php
$lang['friendlyname'] = 'OpenID modul';
$lang['postinstall'] = 'Etter installasjonsmelding';
$lang['postuninstall'] = 'Etter avinstallasjon melding';
$lang['really_uninstall'] = 'Er du sikker p&aring; at du vil avinstallere OpenID modulen?';
$lang['uninstalled'] = 'Modulen ble avinstallert';
$lang['installed'] = 'Modulversjon %s er installert';
$lang['upgraded'] = 'Modulen er oppgradert til versjon %s';
$lang['moddescription'] = 'Denne modulen legger til OpenID innloggingsegenskaper til CMS Made Simple og FrontEndUsers.';
$lang['changelog'] = '<ul>
<li>Version 1.0.0 First public release with support for OpenID and Facebook authentication</li>
<li>Version 1.1.0 Added support for Twitter authentication. Possible to configure redirects after login. Added OpenID Selector as additional OpenID login page style.
</ul>';
$lang['help'] = '<h3>What Does This Do?</h3>
<p>The OpenID module provides functionality to add an OpenID or Facebook account to a registered frontend user. That user can then log in using that identity instead of the ordinary frontend account.</p>
<h3>How Do I Use It</h3>
<p><ol>
    <li>Make sure that FrontEndUsers is installed</li>
    <li>Install the OpenID module</li>
    <li>Check out the settings page if you want to use Facebook as a provider</li>
    <li>Add the tag <i>{OpenID}</i> to a new or an existing page</li>
    <li>Log in as an already registered frontend user</li>
    <li>Visit the page with the OpenID tag and register a provider</li>
    <li>Logout</li>
    <li>Revisit the page with the OpenID tag, select the same provider you just registered, authenticate and behold: You are now logged in</li>
</ol></p>
<h3>Support</h3>
<p>Getting OpenID to work properly can be a bit of a struggle if you are not
fortunate enough to have an environment that already has all the bits and pieces in place.
<br/>Some places to check before asking for help:<br/>
<ul>
    <li>The janrain README file in the /modules/OpenID/openid-php-openid-*version* directory</li>
    <li>Run the detect.php file in /modules/OpenID/openid-php-openid-*version*/examples/</li>
    <li>Try different OpenID providers in order to determine if all are broken or just some.
    A rule of thumb is that Facebook is a separate thing compared to the OpenID providers.
    Providers that use discovery (like Google) is different from the simpler ones like myOpenID</li>
    <li>Check your php error logs for any exceptions or error messages. Google any output for clues about how to solve them</li>
    <li>Set openid.debug to true in your config.php. This will output a ton of messages to the php error log</li>
</ul>
</p>
<h3>Credits</h3>
<p>The OpenID library is standing on the shoulders of giants, namely:
<ul>
    <li><a href="http://github.com/openid/php-openid/" target="_blank">PHP OpenID library by JanRain, Inc.</a></li>
    <li><a href="http://jvance.com/pages/JQueryOpenIDPlugin.xhtml" target="_blank">OpenID jQuery plugin by Jarret Vance</a></li>
    <li><a href="https://github.com/facebook/php-sdk/" target="_blank">Facebook PHP SDK</a></li>
    <li><a href="http://www.jquery.com" target="_blank">jQuery</a></li>
</ul>
</p>

<h3>Copyright and License</h3>
<p>Copyright &amp;copy; 2010-2011, <a href="mailto:openid@lennartssons.net">Henrik Lennartsson</a>. All Rights Are Reserved.</p>
<p>This module has been released under the <a href="http://www.apache.org/licenses/LICENSE-2.0.html">Apache License Version 2.0</a>. You must agree to this license before using the module.</p>';
$lang['openid_providers'] = 'Aktiverte tilbydere';
$lang['settings'] = 'Innstillinger';
$lang['users'] = 'Brukere';
$lang['submit'] = 'Utf&oslash;r';
$lang['cancel'] = 'Avbryt';
$lang['openid_fail'] = 'Your provided identity is X but the login failed';
$lang['openid_success'] = 'Your provided identity is X and you have been logged in as user %s';
$lang['openid_unknown'] = 'Your provided identity is X but is not registered with any user.';
$lang['openid_redirecting'] = 'Vennligst vent, omdirigerer til din valgte OpenID tilbyder';
$lang['openid_added_identity'] = 'La vellykket til %s identitet %s';
$lang['openid_remove_identity_success'] = 'Identitet vellykket fjernet';
$lang['openid_remove_identity_failed'] = 'Klarte ikke &aring; fjerne identitet';
$lang['list_registered_providers'] = 'Registrerte tilbydere';
$lang['list_information'] = 'F&oslash;lgende OpenID tilbydere har blitt assosiert med din konto. Du kan benytte hvem du vil av disse for &aring; logge inn p&aring; dette nettstedet.';
$lang['list_link_remove'] = 'Fjern';
$lang['list_add'] = 'Kegg til eller oppdater en tilbyder';
$lang['list_add_information'] = 'Velg en tilbyder i skjemaet for &aring; fullf&oslash;re innloggingsprosessen. Om vellykket - vil tilbyderen bli lagt til din liste med registrerte tilbydere.
    Om du allerede har en annen id registrert mot samme tilbyder s&aring; vil den UD bli erstattet med den nye.';
$lang['login_enter_your'] = 'Oppgi din';
$lang['login_provider_user_name'] = 'Tilbyder brukernavn';
$lang['login_openid'] = 'OpenID ';
$lang['login_login'] = 'Innlogging';
$lang['login_signin'] = 'Logg inn';
$lang['login_click_provider'] = 'Vennligst klikk for &aring; velge din kontotilbyder';
$lang['login_openid_information'] = 'OpenID er en tjeneste som tillater deg &aring; logge p&aring; mange forskjellige nettsteder ved &aring; benytte &eacute;n identitet.
 Finn ut <a href="http://openid.net/what/">mere om OpenID</a> og <a href="http://openid.net/get/">hvordan du skaffer en OpenID aktivert konto</a>';
$lang['register_provider'] = 'Registrer OpenID tilbyder';
$lang['register_information'] = 'Velg din OpenID tilbyder i skjemaet nedenfor og fullf&oslash;r innloggingsprosessen.
N&aring;r fullf&oslash;rt - vil din brukerkonto p&aring; dette nettstedet bli assosiert med din OpenID tilbyder. Dette gj&oslash;r det mulig for deg &aring; logge inn ved &aring; benytte OpenID i stedet for brukernavn og passord.';
$lang['twitter_failed_or_canceled'] = 'Twitter innlogging ble kansellert eller feilet av en eller annen grunn';
$lang['facebook_failed_or_canceled'] = 'Facebook innlogging ble kansellert eller feilet av en eller annen grunn';
$lang['utmz'] = '156861353.1300226369.3692.81.utmcsr=dev.cmsmadesimple.org|utmccn=(referral)|utmcmd=referral|utmcct=/feature_request/list/6';
$lang['utma'] = '156861353.179052623084110100.1210423577.1302044019.1302118822.3753';
$lang['qca'] = '1210971690-27308073-81952832';
$lang['utmb'] = '156861353';
$lang['utmc'] = '156861353';
?>