<?php
$lang['friendlyname'] = 'Module OpenID';
$lang['postinstall'] = 'Message post installation';
$lang['postuninstall'] = 'Message post-d&eacute;sinstallation';
$lang['really_uninstall'] = '&Ecirc;tes-vous s&ucirc;r de vouloir d&eacute;sinstaller le module OpenID ?';
$lang['uninstalled'] = 'Module d&eacute;sinstall&eacute;';
$lang['installed'] = 'Module install&eacute; en version %s.';
$lang['upgraded'] = 'Module mis &agrave; jour en version %s.';
$lang['moddescription'] = 'Ce module permet l&#039;identification via OpenID dans CMSMS et FrontEndUsers.';
$lang['changelog'] = '<ul>
<li>Version 1.0.0 First public release with support for OpenID and Facebook authentication</li>
<li>Version 1.1.0 Added support for Twitter authentication. Possible to configure redirects after login. Added OpenID Selector as additional OpenID login page style.
</ul>';
$lang['help'] = '<h3>Que fait ce module ?</h3>
<p>The OpenID module provides functionality to add an OpenID or Facebook account to a registered frontend user. That user can then log in using that identity instead of the ordinary frontend account.</p>
<h3>How Do I Use It</h3>
<p><ol>
    <li>Make sure that FrontEndUsers is installed</li>
    <li>Install the OpenID module</li>
    <li>Check out the settings page if you want to use Facebook as a provider</li>
    <li>Add the tag <i>{OpenID}</i> to a new or an existing page</li>
    <li>Log in as an already registered frontend user</li>
    <li>Visit the page with the OpenID tag and register a provider</li>
    <li>Logout</li>
    <li>Revisit the page with the OpenID tag, select the same provider you just registered, authenticate and behold: You are now logged in</li>
</ol></p>
<h3>Support</h3>
<p>Getting OpenID to work properly can be a bit of a struggle if you are not
fortunate enough to have an environment that already has all the bits and pieces in place.
<br/>Some places to check before asking for help:<br/>
<ul>
    <li>The janrain README file in the /modules/OpenID/openid-php-openid-*version* directory</li>
    <li>Run the detect.php file in /modules/OpenID/openid-php-openid-*version*/examples/</li>
    <li>Try different OpenID providers in order to determine if all are broken or just some.
    A rule of thumb is that Facebook is a separate thing compared to the OpenID providers.
    Providers that use discovery (like Google) is different from the simpler ones like myOpenID</li>
    <li>Check your php error logs for any exceptions or error messages. Google any output for clues about how to solve them</li>
    <li>Set openid.debug to true in your config.php. This will output a ton of messages to the php error log</li>
</ul>
</p>
<h3>Credits</h3>
<p>The OpenID library is standing on the shoulders of giants, namely:
<ul>
    <li><a href="http://github.com/openid/php-openid/" target="_blank">PHP OpenID library by JanRain, Inc.</a></li>
    <li><a href="http://jvance.com/pages/JQueryOpenIDPlugin.xhtml" target="_blank">OpenID jQuery plugin by Jarret Vance</a></li>
    <li><a href="https://github.com/facebook/php-sdk/" target="_blank">Facebook PHP SDK</a></li>
    <li><a href="http://www.jquery.com" target="_blank">jQuery</a></li>
</ul>
</p>

<h3>Copyright and License</h3>
<p>Copyright &copy; 2010, <a href="mailto:openid@lennartssons.net">Henrik Lennartsson</a>. All Rights Are Reserved.</p>
<p>This module has been released under the <a href="http://www.apache.org/licenses/LICENSE-2.0.html">Apache License Version 2.0</a>. You must agree to this license before using the module.</p>
';
$lang['openid_providers'] = 'Activer les fournisseurs';
$lang['settings'] = 'Param&egrave;tres';
$lang['users'] = 'Utilisateurs';
$lang['submit'] = 'Envoyer';
$lang['cancel'] = 'Annuler';
$lang['openid_fail'] = 'L&#039;identit&eacute; fournie est <a href="%s">%s</a> mais l&#039;identification a &eacute;chou&eacute;.';
$lang['openid_success'] = 'L&#039;identit&eacute; fournie est <a href="%s">%s</a> et vous avez &eacute;t&eacute; identifi&eacute; en tant que %s';
$lang['openid_unknown'] = 'L&#039;identit&eacute; fournie est <a href="%s">%s</a> mais n&#039;est pas li&eacute;e &agrave; un utilisateur.';
$lang['openid_redirecting'] = 'Merci de patienter, vous allez &ecirc;tre redirig&eacute; vers votre fournisseur OpenID';
$lang['openid_added_identity'] = '%s identity %s ajout&eacute; avec succ&egrave;s';
$lang['openid_remove_identity_success'] = 'Identit&eacute; effac&eacute;e avec succ&egrave;s';
$lang['openid_remove_identity_failed'] = 'Impossible d&#039;effacer l&#039;identit&eacute;';
$lang['list_registered_providers'] = 'Registered providers';
$lang['list_information'] = 'The following OpenID providers have been associated with your account. You can use any one to log in to this site.';
$lang['list_link_remove'] = 'Remove';
$lang['list_add'] = 'Add or update provider';
$lang['list_add_information'] = 'Select a provider in the form and complete the signin process. If successful the provider will be added to your list of registered providers.
    If you&#039;ve already got another id registered with the same provider that ID will be replaced.';
$lang['login_enter_your'] = 'Entrez votre';
$lang['login_provider_user_name'] = 'Provider user name';
$lang['login_openid'] = 'OpenID';
$lang['login_login'] = 'Login';
$lang['login_signin'] = 'Sign-in';
$lang['login_click_provider'] = 'Please click to select your account provider';
$lang['login_openid_information'] = 'OpenID is service that allows you to log-on to many different websites using a single indentity.
 Find out <a href="http://openid.net/what/">more about OpenID</a> and <a href="http://openid.net/get/">how to get an OpenID enabled account</a>';
$lang['register_provider'] = 'Register OpenID provider';
$lang['register_information'] = 'Select your OpenID provider in the form below and complete the sign in process.
Once completed your user account on this site will be associated with your
OpenID provider. This makes it possible for you to sign in using OpenID instead
of username and password.';
$lang['twitter_failed_or_canceled'] = 'Twitter login was cancelled or failed for some other reason';
$lang['facebook_failed_or_canceled'] = 'Facebook login was cancelled or failed for some other reason';
$lang['qca'] = 'P0-58741428-1276531635559';
$lang['utma'] = '156861353.1249395224.1276535615.1303843192.1304690679.68';
$lang['utmz'] = '156861353.1304690679.68.65.utmcsr=google|utmccn=(organic)|utmcmd=organic|utmctr=cmsms';
$lang['utmb'] = '156861353.1.10.1304690679';
$lang['utmc'] = '156861353';
?>