<?php

/*
 *      Copyright 2010 Henrik Lennartsson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/* @var $this OpenID */
/* @var $gCms CmsObject */

$smarty->assign('startform',
		$this->CreateFormStart( $id, 'admin_updatesettings'));
$smarty->assign('endform', $this->CreateFormEnd());

global $gCms;
$config = $gCms->GetConfig();

$smarty->assign('input_visual', $this->CreateInputRadioGroup($id, 'input_visual_framework',
        array(
            'jQuery OpenID Plugin <a href="http://jvance.com/pages/JQueryOpenIDPlugin.xhtml" target="_blank">example</a>' => 'jqueryplugin',
            'OpenID Selector <a href="http://code.google.com/p/openid-selector/" target="_blank">example</a>' => 'openidselector'),
        $this->GetPreference('visual_framework', 'jqueryplugin'), '', '<br/><br/>'));

$smarty->assign('buggy_gmp_status', OpenID::GetConfigBool('openid.buggy.gmp') ? 'Enabled' : 'Disabled');

$smarty->assign('insecure_rand_status', OpenID::GetConfigBool('openid.insecure.rand') ? 'Enabled' : 'Disabled');

$smarty->assign('ca_file_override_status', OpenID::GetConfigBool('openid.ca.override') ? 'Enabled' : 'Disabled');

/** Facebook **/
$smarty->assign('input_facebook_app_id',
        $this->CreateInputText($id,'input_facebook_app_id', $this->GetPreference('facebook_app_id'), 30));
$smarty->assign('input_facebook_app_secret',
        $this->CreateInputText($id,'input_facebook_app_secret', $this->GetPreference('facebook_app_secret'), 50));

/** Twitter **/
$smarty->assign('input_twitter_consumer_key',
        $this->CreateInputText($id,'input_twitter_consumer_key', $this->GetPreference('twitter_consumer_key'), 30));
$smarty->assign('input_twitter_consumer_secret',
        $this->CreateInputText($id,'input_twitter_consumer_secret', $this->GetPreference('twitter_consumer_secret'), 50));
/* debug settings */
$smarty->assign('debug_status', OpenID::GetConfigBool('openid.debug') ? 'Enabled' : 'Disabled');
/* redirect */
$feuRedirect = $this->GetModuleInstance('FrontEndUsers')->GetPreference('pageid_login');
$feuRedirect = $feuRedirect ? $feuRedirect : 'not set';
$smarty->assign('input_login_redirect', $this->CreateInputRadioGroup($id, 'input_login_redirect',
        array(
            'None (displays information message)' => 'none',
            'Use setting from FrontEndUsers (currently <strong>'.$feuRedirect.'</strong>)' => 'feu',
            'Use the custom redirect below' => 'custom'),
        $this->GetPreference('login_redirect', 'none'), '', '<br/><br/>'));
$smarty->assign('input_login_redirect_pageid',
        $this->CreateInputText($id,'input_login_redirect_pageid', $this->GetPreference('login_redirect_pageid'), 50));
/* buttons */
$smarty->assign('submit',
		$this->CreateInputSubmit ($id, 'submit',
					  $this->Lang('submit'),'',''));
$smarty->assign ('cancel',
		 $this->CreateInputSubmit ($id, 'cancel',
					   $this->Lang('cancel')));

echo $this->ProcessTemplate('admin_tab_settings.tpl');
?>
