<?php

/*
 *      Copyright 2010 Henrik Lennartsson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

if (!isset($gCms)) {
    exit;
}
global $params;
global $gCms;
$smarty = & $gCms->GetSmarty();

/* @var $this OpenID */
$provider = $params['provider'];
/* @var $feu FrontEndUsers */
$feu = $this->GetModuleInstance('FrontEndUsers');
if ($feu->LoggedIn()) {
    $uid = $feu->LoggedInId();
    $this->Log("Deleteing provider $provider for user $uid");
    // User is logged in: Remove OpenID provider
    if ($this->RemoveOpenID($uid, $provider)) {
        // Add message and display list of providers
        $smarty->assign('message', $this->Lang('openid_remove_identity_success'));
        $smarty->assign('message_type', 'success');
    } else {
        $smarty->assign('message', $this->Lang('openid_remove_identity_failed'));
        $smarty->assign('message_type', 'error');
    }
} else {
    // User is not logged in - should not happen
    $smarty->assign('message', $this->Lang('openid_remove_identity_failed'));
    $smarty->assign('message_type', 'error');
}
include 'action.default.php';
?>