<?php

/*
 *      Copyright 2010 Henrik Lennartsson
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

/* @var $this OpenID */
if (!isset($gCms)) exit;
global $params;
$this->Log("********************************");
$this->Log(" *** STEP 1 *** action.login.php");
$this->Log("openid-identifier : ".$params['openid_identifier']);
$this->Log("openid_username : ".$params['openid_username']);
global $gCms;
$smarty =& $gCms->GetSmarty();;
error_log(print_r($params, true));
function getOpenIDURL() {
    global $params;
    // Render a default page if we got a submission without an openid value.
    /*
     *  TODO Error handling - display error message if URL is missing
    if (empty($params['openid_identifier'])) {
        $error = "Expected an OpenID URL.";
        $this->Log($error);
        exit(0);
    }*/

    return empty($params['openid_identifier']) ? $params['openid_username'] : $params['openid_identifier'];
}


    $openid = getOpenIDURL();
    $consumer = $this->GetConsumer();

    // Begin the OpenID authentication process.
    $auth_request = $consumer->begin($openid);

    // No auth request means we can't begin OpenID.
    if (!$auth_request) {
        print "Authentication error; not a valid OpenID.";
    }

    // Simple Registration protocol messages.
    $sreg_request = Auth_OpenID_SRegRequest::build(array('email'),array('fullname', 'nickname'));
    if (!$sreg_request) {
        die("sreg failed");
    }
    if ($sreg_request) {
        $auth_request->addExtension($sreg_request);
    }

    // Attribute exchange
    $ax_request = new Auth_OpenID_AX_FetchRequest();
    $ax_request->add(Auth_OpenID_AX_AttrInfo::make('http://axschema.org/contact/email', 1, TRUE));
    //$ax_request->add('firstname');
    //$ax_request->add('lastname');
    $auth_request->addExtension($ax_request);

    $policy_uris = $_GET['policies'];
    /*
    $pape_request = new Auth_OpenID_PAPE_Request($policy_uris);
    if ($pape_request) {
        //$auth_request->addExtension($pape_request);
    }*/

    // Redirect the user to the OpenID server for authentication.
    // Store the token for this authentication so we can verify the
    // response.

    // *************************************************************************************************
    // Create return URL. If there's a redirect configured we want a link to moduleinterface.php
    $action = 'authenticate';
    $redirectId = $this->GetRedirectLoginPageId();
    if ($redirectId) {
        $this->Log('Return page ID (using configured redirect after login) : '.$returnPageId);
        $returnUrl = $this->CreateLink($id, $action, null, null, null, null, true, false, null, null);
    } else {
        $returnPageId = $gCms->variables['content_id']; // ID of current page
        $this->Log('Return page ID : '.$returnPageId);
        $returnUrl = $this->CreateLink($id, $action, $returnPageId, null, null, null, true, true);
    }
    $trustRoot = $gCms->config['root_url'];
    $this->Log('Return URL : '.$returnUrl);
    $redirect_url = $auth_request->redirectURL($trustRoot, $returnUrl);
    $this->Log('Redirect URL : '.$redirect_url);
    $parts = explode("&", $redirect_url);
    $this->Log("request try_auth :");
    foreach ($parts as $part) {
        $this->Log(urldecode($part));
    }

    // *************************************************************************************************

    // For OpenID 1, send a redirect.  For OpenID 2, use a Javascript
    // form to send a POST request to the server.
    if ($auth_request->shouldSendRedirect()) {
        $redirect_url = $auth_request->redirectURL($trustRoot, $returnUrl);

        // If the redirect URL can't be built, display an error
        // message.
        if (Auth_OpenID::isFailure($redirect_url)) {
            print "Could not redirect to server: " . $redirect_url->message;
        } else {
            // Send redirect.
            header("Location: ".$redirect_url);
        }
    } else {
        // Generate form markup and render it.
        $form_id = 'openid_message';
        /*
        $form_html = $auth_request->htmlMarkup($trustRoot, $returnUrl,
                                               false, array('id' => $form_id));
         *
         */
        $form_html = $auth_request->formMarkup($trustRoot, $returnUrl,
                                               false, array('id' => $form_id));
        // Display an error if the form markup couldn't be generated;
        // otherwise, render the HTML.
        if (Auth_OpenID::isFailure($form_html)) {
            print "Could not redirect to server: " . $form_html->message;
        } else {
            print '<script type="text/javascript" src="modules/OpenID/scripts/jquery.min.js"></script>';
            print '<img src="'.$gCms->config['root_url'].'/modules/OpenID/images/ajax-loader.gif">&nbsp;&nbsp;';
            print $this->Lang('openid_redirecting');
            print '<div id="OpenIdForm">'.$form_html.'</div>';
            print '<script type="text/javascript">';
            print '  $(function() {';
            print '    $("input[type=submit]", $("#OpenIdForm")).click();';
            print '    $("input[type=submit]", $("#OpenIdForm")).hide();';
            print '  });';
            print '</script>';
        }
    }

?>