{* confirmation report template *}
{if $message != ''}<h3>{$message}</h3>{/if}
<h3>{$Orders->Lang('confirm_order')}</h3>

{* display the billing info *}
<fieldset>
   <legend><strong>{$Orders->Lang('bill_to')}:</strong> (<a href="{$back_url}">Edit</a>):</legend>
   {$Orders->Lang('first_name')}:{$billing->get_firstname()}<br/>
   {$Orders->Lang('last_name')}:{$billing->get_lastname()}<br/>
   {$Orders->Lang('address1')}:{$billing->get_address1()}<br/>
   {if $billing->get_address2() != ''}
   {$Orders->Lang('address2')}:{$billing->get_address2()}<br/>
   {/if}
   {$Orders->Lang('city')}:{$billing->get_city()}<br/>
   {$Orders->Lang('state/province')}:{$billing->get_state()}<br/>
   {$Orders->Lang('postal')}:{$billing->get_postal()}<br/>
   {$Orders->Lang('country')}:{$billing->get_country()}<br/>
   {if $billing->get_phone() != ''}
   {$Orders->Lang('phone')}:{$billing->get_phone()}<br/>
   {/if}
   {if $billing->get_fax() != ''}
   {$Orders->Lang('fax')}:{$billing->get_fax()}<br/>
   {/if}
   {if $billing->get_email() != ''}
   {$Orders->Lang('email_address')}:{$billing->get_email()}<br/>
   {/if}
</fieldset>

{foreach from=$order_obj->get_destinations() item='destination'}

 {assign var='shipping' value=$destination->get_shipping_address()}
<br/>
<fieldset>
   <legend><strong>{$Orders->Lang('ship_to')}:</strong> {$shipping->get_lastname()}, {$shipping->get_firstname()}</legend>
   <div>{$Orders->Lang('address1')}:{$shipping->get_address1()}</div>
   {if $shipping->get_address2() != ''}
   <div>{$Orders->Lang('address2')}:{$shipping->get_address2()}</div>
   {/if}
   <div>{$Orders->Lang('city')}:{$shipping->get_city()}</div>
   <div>{$Orders->Lang('state/province')}:{$shipping->get_state()}</div>
   <div>{$Orders->Lang('postal')}:{$shipping->get_postal()}</div>
   <div>{$Orders->Lang('country')}:{$shipping->get_country()}</div>
   {if $shipping->get_phone() != ''}
   <div>{$Orders->Lang('phone')}:{$shipping->get_phone()}</div>
   {/if}
   {if $shipping->get_fax() != ''}
   <div>{$Orders->Lang('fax')}:{$shipping->get_fax()}</div>
   {/if}
   {if $shipping->get_email() != ''}
   <div>{$Orders->Lang('email_address')}:{$shipping->get_email()}</div>
   {/if}

  <br/>
  <fieldset>
  <legend><strong>{$Orders->Lang('items')}</strong></legend>
  <table cellspacing="10" width="100%">
      <thead>
        <tr>
          <th>{$Orders->Lang('type')}</th>
          <th>{$Orders->Lang('sku')}</th>
          <th>{$Orders->Lang('description')}</th>
          <th>{$Orders->Lang('quantity')}</th>
          <th>{$Orders->Lang('weight')}</th>           
          <th>{$Orders->Lang('unit_price')}</th>
          <th>{$Orders->Lang('discount')}</th>
          <th>{$Orders->Lang('net_price')}</th>
        </tr>
      </thead>
      <tbody>
      {foreach from=$destination->get_items() item='item'}
         <tr>
            <td>{$Orders->Lang($item->get_item_type())}</td>
            <td>{$item->get_sku()}</td>
            <td>{$item->get_description()}</td>
            <td>{$item->get_quantity()}</td>
            <td>{if $item->get_weight() != ''}{$item->get_weight()|number_format:2} {$weightunits}{/if}</td>
	    <td>{$currencysymbol}{$item->get_unit_price()|number_format:2}</td>
	    <td>{if $item->get_discount() != ''}{$currencysymbol}{$item->get_discount()|number_format:2}{/if}</td>
            <td>{$currencysymbol}{$item->get_net_price()|number_format:2}</td>
          </tr>
      {/foreach}
     </tbody>
  </table>
  </fieldset>   
  <br/>
</fieldset>
{/foreach}

{* display the order notes *}
{if $order_obj->get_order_notes() != '' }
<br/>
<fieldset>
<legend><strong>{$Orders->Lang('order_notes')}:</strong> (<a href="{$edit_url}">Edit</a>):</legend>
{$order_obj->get_order_notes()}
</fieldset>
{/if}

<br/>
<fieldset>
<legend><strong>{$Orders->Lang('payment_options')}:</strong></legend>

  {* this is where the payment gateway plugin should be *}
  {if isset($payment_gateway_form)}{$payment_gateway_form}{/if}

  {* also, we can add the ability to pay by invoice or direct billing - this can be removed if
     nto providing direct billing *}
  {if isset($ccformstart)}
  {$ccformstart}
  {$Orders->Lang('procede_manual_checkout')}: <input type="submit" name="{$actionid}submit" value="{$Orders->Lang('next')}" />
  {$ccformend}
  {/if}
</fieldset>

<a href="{$backurl}" title="{$Orders->Lang('back')}">{$Orders->Lang('back')}</a>