<h3>{$Orders->Lang('title_manual_refund')}</h3>

{if isset($errors)}
  {$Orders->ShowErrors($errors)}
{/if}

{if isset($warnings)}
<div class="pagewarning">
  <ul>
  {foreach from=$warnings item='one'}
    <li>{$one}</li>
  {/foreach}
  </ul>
</div>
{/if}


{$formstart}
<table border="0" width="100%">
<tr>
  <td valign="top">
   <fieldset>
   <legend>{$Orders->Lang('order_summary')}:&nbsp;</legend>
   <table border="0">
      <tr>
        <td>{$Orders->Lang('order_number')}:</td>
        <td>{$order_obj->get_invoice()}</td>
      </tr>
      <tr>
        <td>{$Orders->Lang('status')}:</td>
        <td>{$Orders->Lang($order_obj->get_status())}</td>
      </tr>
      <tr>
        <td>{$Orders->Lang('created')}:</td>
        <td>{$order_obj->get_create_date()|cms_date_format}</td>
      </tr>
      <tr>
        <td>{$Orders->Lang('modified')}:</td>
        <td>{$order_obj->get_modified_date()|cms_date_format}</td>
      </tr>
      <tr>
        <td>{$Orders->Lang('total')}:</td>
        <td>{$currencysymbol} {$order_obj->get_total()|number_format:2}</td>
      </tr>
      <tr>
        <td>{$Orders->Lang('paid')}:</td>
        <td>{$currencysymbol} {$order_obj->get_amount_paid()|number_format:2}</td>
      </tr>
    {if isset($payment_assoc)}
    {foreach from=$payment_assoc key='key' item='val'}
      <tr> 
        <td>{$key}:</td>
        <td>{$val}</td>
      </tr>
    {/foreach}
    {/if}
    </table>
   </fieldset>
   <fieldset>
   <legend>{$Orders->Lang('order_notes')}:</legend>
      {$order_obj->get_order_notes()}
   </fieldset>
 </td>

 <td>{* second column *}
   {* begin the form *}
   
   <div class="pageoverflow">
     <p class="pagetext">{$Orders->Lang('transaction_id')}:</p>
     <p class="pageinput">
       {$payment->get_txn_id()}
     </p>
   </div>

   <div class="pageoverflow">
     <p class="pagetext">{$Orders->Lang('refund_amount')}:</p>
     <p class="pageinput">
       {$currencysymbol}<input type="text" name="{$actionid}amount" value="{$payment->get_amount()|number_format:2}" size="10"/>
       <br/>
       {$Orders->Lang('info_refund_amount')}
     </p>
   </p>

   
   <div class="pageoverflow">
     <p class="pagetext">{$Orders->Lang('creditcard_number')}:</p>
     <p class="pageinput">
       {$payment->get_cc_number_masked()}
     </p>
   </div>

   <div class="pageoverflow">
     <p class="pagetext">{$Orders->Lang('creditcard_verifycode')}:</p>
     <p class="pageinput">
       {$payment->get_cc_verifycode()}
     </p>
   </div>

   <div class="pageoverflow">
     <p class="pagetext">{$Orders->Lang('creditcard_expiry')}:</p>
     <p class="pageinput">
       {$payment->get_cc_expiry()|cms_date_format:"%m/%y"}
     </p>
   </div>

   <div class="pageoverflow">
     <p class="pagetext">{$Orders->Lang('notes')}:</p>
     <p class="pageinput">
       <textarea style="height: 5em;" rows="5" columns="50" name="{$actionid}notes">{$notes}</textarea>
     </p>
   </div>

   <div class="pageoverflow">
     <p class="pagetexT"></p>
     <p class="pageinput">
       <input id="submit_btn" type="submit" name="{$actionid}submit" value="{$Orders->Lang('submit')}"   onclick="return confirm('{$Orders->Lang('ask_confirm_refund')}');"/>
       <input type="submit" name="{$actionid}cancel" value="{$Orders->Lang('cancel')}"/>
     </p>
   </div>

  </td>
  </tr>
</table>
{$formend}