<?php
#-------------------------------------------------------------------------
# Module: Orders - A simple order processing module.
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in every page of
# its admin section that the site was built with CMS Made simple, and
# provide a link to the CMS Made Simple website.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
if( !isset($gCms) ) exit;

$current_version = $oldversion;
$dict = NewDataDictionary($db);
$taboptarray = array('mysql' => 'TYPE=MyISAM');


switch($current_version)
  {
  case '1.2.4':
  case '1.2.5':
    $this->SetPreference('gateway_description',get_site_preference('sitename'));
    Events::CreateEvent('Orders', 'PostGatewayComplete');

  case '1.4':
  case '1.4.1':
    {
      $now = $db->DbTimeStamp(time());

      // 0.  add item type, unit price, discount to the items table.
      $sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_orders_items',
				      'item_type C(25), unit_price F, discount F');
      $dict->ExecuteSQLArray($sqlarray);

      // 1.  copy the price to the unit_price field
      // and set item_type to 'product'
      $query = 'UPDATE '.cms_db_prefix()."module_orders_items SET unit_price = price, item_type = 'product'";
      $db->Execute($query);

      // 2.  drop the price column
      $query = 'ALTER TABLE '.cms_db_prefix().'module_orders_items DROP COLUMN price';
      $db->Execute($query);
      
      // 3.  alter column definition to allow for null item id
      $query = 'ALTER TABLE '.cms_db_prefix().'module_orders_items MODIFY item_id int(11)';
      $db->Execute($query);

      // 4.  processw each order
      $query = 'SELECT id,order_id,tax,shipping_cost FROM '.cms_db_prefix().'module_orders_shipping';
      $tquery = 'INSERT INTO '.cms_db_prefix()."module_orders_items
             (order_id,shipping_id,item_id,quantity,product_name,price,create_date,modified_date,item_type)
             VALUES (?,?,?,?,?,?,$now,$now,?)";
      $dbr = $db->Execute($query);
      while( $dbr && ($row = $dbr->FetchRow()) )
	{
	  // 4.1 insert a single tax line item.
	  $db->Execute($tquery,
		       array($row['order_id'],$row['shipping_id'],NULL,1,
			     'TAX',$row['tax'],line_item::ITEMTYPE_TAX));
		       
	  // 4.2 insert shipping line item
	  $db->Execute($tquery,
		       array($row['order_id'],$row['shipping_id'],NULL,1,'Shipping',
			     $row['shipping'],line_item::ITEMTYPE_SHIPPING));
	}

      // 5   drop the tax and shipping stuff out of the orders table
      $query = 'ALTER TABLE '.cms_db_prefix().'module_orders DROP COLUMN subtotal';
      $db->Execute($query);
      $query = 'ALTER TABLE '.cms_db_prefix().'module_orders DROP COLUMN tax';
      $db->Execute($query);
      $query = 'ALTER TABLE '.cms_db_prefix().'module_orders DROP COLUMN shipping_total';
      $db->Execute($query);
      $query = 'ALTER TABLE '.cms_db_prefix().'module_orders DROP COLUMN totaltotal';
      $db->Execute($query);

      // 6.  drop the tax and shipping stuff ot of the orders_shipping table.
      $query = 'ALTER TABLE '.cms_db_prefix().'module_orders_shipping DROP COLUMN subtotal';
      $db->Execute($query);
      $query = 'ALTER TABLE '.cms_db_prefix().'module_orders_shipping DROP COLUMN tax';
      $db->Execute($query);
      $query = 'ALTER TABLE '.cms_db_prefix().'module_orders_shipping DROP COLUMN shipping_cost';
      $db->Execute($query);
      $query = 'ALTER TABLE '.cms_db_prefix().'module_orders_shipping DROP COLUMN total';
      $db->Execute($query);
      $query = 'ALTER TABLE '.cms_db_prefix().'module_orders_shipping DROP COLUMN weight';
      $db->Execute($query);
    }

  case '1.5':
  case '1.5.1':
    $this->AddEventHandler('CGPaymentGatewayBase','on_incoming_event',false);

  case '1.5.2':
  case '1.5.3':
    $sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_orders',
				    'invoice C(50) NOT NULL');
    $dict->ExecuteSQLArray($sqlarray);

    $query = 'SELECT id FROM '.cms_db_prefix().'module_orders ';
    $uquery = 'UPDATE '.cms_db_prefix().'module_orders SET invoice = ? WHERE id = ?';
    $orders = $db->GetCol($query);
    foreach( $orders as $orderid )
      {
	$invoice = orders_helper::make_invoice_number($orderid);
	$db->Execute($uquery,array($invoice,$orderid));
      }

    // add a new preference.
    $this->SetPreference('address_retrieval','remember_last');

  case '1.6':
  case '1.6.1':
  case '1.6.2':
  case '1.6.3':
  case '1.6.4':
    $sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_orders_shipping',
				    'name C(255)');
    $dict->ExecuteSQLArray($sqlarray);
    $query = 'UPDATE '.cms_db_prefix().'module_orders_shipping SET name = ?';
    $db->Execute($query,array('cart'));
    $this->SetPreference('datastore_timeout',10);

  case '1.6.5':
  case '1.6.6':
  case '1.6.7':
  case '1.6.8':
  case '1.6.9':
  case '1.6.10':
  case '1.6.11':
  case '1.6.12':
  case '1.6.13':
  case '1.6.14':
  case '1.6.15':
  case '1.6.16':
    $sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_orders_items',
				    'sku C(25)');
    $dict->ExecuteSQLArray($sqlarray);

  case '1.7':
  case '1.7.1':
  case '1.7.2':
  case '1.7.3':
    // duplicated from above... should silently fail.
    $sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_orders_items',
				    'sku C(25)');
    $dict->ExecuteSQLArray($sqlarray);

    $gateway_module_name = $this->GetPreference('gateway_module','unknown');
    $flds = "id I KEY AUTO,
             order_id      I NOT NULL,
             amount        F,
             payment_date  I,
 	     method        C(50),
             status        C(50),
             gateway       C(50),
             cc_number     B,
             cc_expiry     I,
             cc_verifycode B,
    	     confirmation_num C(255),
             txn_id        C(255),
             notes         X
    ";
    $sqlarray = $dict->CreateTableSQL(cms_db_prefix()."module_orders_payments", 
				      $flds, $taboptarray);
    $dict->ExecuteSQLArray($sqlarray);

    // now copy the information from the orders table into the payments table.
    // assume the amount is the full amount.
    $query = 'SELECT id,cc_number,cc_expiry,cc_verifycode,confirmation_num,create_date,status
                FROM '.cms_db_prefix().'module_orders
               WHERE status = ? OR status = ? OR status = ?';
    $data = $db->GetArray($query,array(ORDERSTATUS_PAID,ORDERSTATUS_COMPLETED,ORDERSTATUS_INVOICED));
    $query2 = 'SELECT order_id,SUM((unit_price + IFNULL(discount,0)) * quantity) AS amt 
                 FROM '.cms_db_prefix().'module_orders_items GROUP BY order_id';
    $tmp = $db->GetArray($query2);
    $tmp2 = cge_array::to_hash($tmp,'order_id');
    for( $i = 0; $i < count($data); $i++ )
      {
	$rec =& $data[$i];
	$order_id = $rec['id'];
	$rec['amt'] = $tmp2[$order_id]['amt'];
      }

    $iquery = 'INSERT INTO '.cms_db_prefix().'module_orders_payments
                (order_id,amount,payment_date,method,status,gateway,txn_id,cc_expiry,cc_number,cc_verifycode)
               VALUES (?,?,?,?,?,?,?,?,?,?)';
    foreach( $data as $oneorder )
      {
	$gateway = '';
	$paymethod = orders_payment::TYPE_UNKNOWN; 
	$paystatus = orders_payment::STATUS_APPROVED;
	if( isset($oneorder['cc_number']) && $oneorder['cc_number'] != '' &&
	    ($oneorder['status'] == ORDERSTATUS_INVOICED || $oneorder['status'] == ORDERSTATUS_COMPLETED) )
	  {
	    $paymethod = orders_payment::TYPE_CREDITCARD;
	  }
	else if( ($oneorder['status'] == ORDERSTATUS_COMPLETED || $oneorder['status'] == ORDERSTATUS_PAID)
		 && $oneorder['confirmation_num'] != '' )
	  {
	    $paymethod = orders_payment::TYPE_ONLINE;
	    $gateway = $gateway_module_name;
	  }
	$dbr = $db->Execute($iquery,
			    array($oneorder['id'],$oneorder['amt'],
				  $oneorder['create_date'],
				  $paymethod,
				  $paystatus,
				  $gateway,
				  $oneorder['confirmation_num'],
				  $oneorder['cc_expiry'],
				  $oneorder['cc_number'],
				  $oneorder['cc_verifycode'],
				  ));
	if( !$dbr )
	  {
	    echo $db->sql.'<br/>'.$db->ErrorMsg().'<br/>'; die();
	  }
      }

    // Now drop the columns from the orders field.
    $query = 'ALTER TABLE '.cms_db_prefix().'module_orders DROP COLUMN cc_type';
    $db->Execute($query);
    $query = 'ALTER TABLE '.cms_db_prefix().'module_orders DROP COLUMN cc_number';
    $db->Execute($query);
    $query = 'ALTER TABLE '.cms_db_prefix().'module_orders DROP COLUMN cc_expiry';
    $db->Execute($query);
    $query = 'ALTER TABLE '.cms_db_prefix().'module_orders DROP COLUMN cc_verifycode';
    $db->Execute($query);
    $query = 'ALTER TABLE '.cms_db_prefix().'module_orders DROP COLUMN confirmation_num';
    $db->Execute($query);
    $query = 'ALTER TABLE '.cms_db_prefix().'module_orders DROP COLUMN gateway_used';
    $db->Execute($query);

    // add a name column tot he shipping table. (could silently fail)
    $sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_orders_shipping',
				    'name C(255)');
    $dict->ExecuteSQLArray($sqlarray);

    // add source and master_price columsn to the line items table.
    $sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_orders_items',
				    'source C(50),master_price F');
    $dict->ExecuteSQLArray($sqlarray);
    $db->Execute('UPDATE '.cms_db_prefix().'module_orders_items
                  SET source = ?',array('Products'));

    // add a billing company field
    $sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_orders',
				    'billing_company C(255)');
    $dict->ExecuteSQLArray($sqlarray);

    // add a billing company field.
    $sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_orders_shipping',
				    'shipping_company C(255)');
    $dict->ExecuteSQLArray($sqlarray);

  case '1.8':
  case '1.8.1':
  case '1.8.2':
  case '1.8.3':
  case '1.8.4':
  case '1.8.5':
  case '1.8.6':
    {
      // add subscription info to the line items
      $sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_orders_items',
				      'subscr_payperiod C(50), subscr_delperiod C(50), subscr_expires '.CMS_ADODB_DT);
      $dict->ExecuteSQLArray($sqlarray);
    }

  case '1.9':
    {
      // add an assocdata field for payments
      $sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_orders_payments',
				      'assocdata X');
      $dict->ExecuteSQLArray($sqlarray);
    }

  case '1.9.1':
    {
      $sqlarray = $dict->AddColumnSQL(cms_db_prefix().'module_orders_items',
				      'assocdata X');
      $dict->ExecuteSQLArray($sqlarray);
    }

  case '1.10':
  case '1.10.1':
  case '1.10.2':
  case '1.10.3':
  case '1.10.4':
  case '1.10.5':
    {
      Events::CreateEvent('Orders', 'CalculateDiscounts');
    }

  case '1.11':
  case '1.11.1':
  case '1.11.2':
    $this->SetTemplate('useremail_template',$this->GetPreference('useremail_template'));
    $this->SetTemplate('adminemail_template',$this->GetPreference('adminemail_template'));
    $this->RemovePreference('useremail_template');
    $this->RemovePreference('adminemail_template');
  }

// EOF
?>
