<?php
#-------------------------------------------------------------------------
# Module: Orders - A simple order processing module.
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in every page of
# its admin section that the site was built with CMS Made simple, and
# provide a link to the CMS Made Simple website.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
if( !isset($gCms) ) exit;
if( !$this->CheckPermission(ORDERS_PERM_MANAGEORDERS) )
  {
    die('permission denied');
  }

if( !isset($params['orderid']) || !isset($params['payment_id']) )
  {
    echo $this->DisplayErrorMessage($this->Lang('error_insufficientparams'));
    return;
  }

$order_id = (int)$params['orderid'];
$payment_id = (int)$params['payment_id'];
$order = orders_ops::load_by_id($order_id);
if( !is_object($order) )
  {
    echo $this->DisplayErrorMessage($this->Lang('error_ordernotfound'));
    return;
  }
$payment = $order->get_payment_by_id($payment_id);
if( !is_object($payment) )
  {
    echo $this->DisplayErrorMessage($this->Lang('error_paymentnotfound'));
    return;
  }
$ccnumber = $payment->get_cc_number();
if( $ccnumber == '' )
  {
    $this->SetError($this->Lang('error_insufficientparams').' Credit Card Number');
    $this->Redirect($id,'admin_manageorder',$returnid,array('orderid'=>$order_id));
    return;
  }

$do_void = TRUE;
$do_credit = TRUE;
$amount = $order->get_total();
if( isset($params['amount']) )
  {
    $amount = (float)$params['amount'];
  }
if( $amount != $order->get_total() )
  {
    $do_void = FALSE;
  }
$ccgateway = $this->GetPreference('ccprocessing_module',-1);
if( $ccgateway == '' || $ccgateway == -1 )
  {
    $this->SetError($this->Lang('error_noccgateway'));
    $this->Redirect($id,'admin_manageorder',$returnid,array('orderid'=>$order_id));
    return;
  }
$gateway_module = $this->GetModuleInstance($ccgateway);
if( !is_object($gateway_module) )
  {
    $this->SetError($this->Lang('error_noccgateway'));
    $this->Redirect($id,'admin_manageorder',$returnid,array('orderid'=>$order_id));
    return;
  }
if( !$gateway_module->SupportsRefunds() )
  {
    $this->SetError($this->Lang('error_invalidgateway'));
    $this->Redirect($id,'admin_manageorder',$returnid,array('orderid'=>$order_id));
    return;
  }

// now, we are ready to start.
if( $amount >= 0 ) $amount = $amount * -1;
$amount = number_format($amount,2);

$message = '';
$status = '';

if( $do_void )
  {
    // we're gonna do a void transaction first, and see if it works.
    // this is because the transaction may not have been processed yet by the financial institution
    // so a void may work properly.
    $gateway_module->SetTransactionType(CGPaymentGatewayBase::TRANS_VOID);
    $gateway_module->SetCreditCardInfo($payment->get_cc_number(),$payment->get_cc_expiry(),$payment->get_cc_verifycode());
    $gateway_module->SetInvoice($order->get_invoice());
    $gateway_module->SetPaymentId($payment->get_id());
    $gateway_module->SetTransactionId($payment->get_txn_id());
    $gateway_module->SetOrderID($order_id);
    $gateway_module->SetTransactionAmount($amount);
    $gateway_module->ProcessTransaction();

    $status = $gateway_module->GetTransactionStatus();
    $message = $gateway_module->GetMessage();
    $gateway_module->reset();

    if( $status == PAYMENT_STATUS_APPROVED )
      {
	$newpayment = new orders_payment();
	$newpayment->set_status(orders_payment::STATUS_VOIDED);
	$newpayment->set_method(orders_payment::TYPE_ONLINE);
	$newpayment->set_payment_date(time());
	$newpayment->set_amount($amount);
	$newpayment->set_cc_number($payment->get_cc_number());
	$newpayment->set_cc_expiry($payment->get_cc_expiry());
	$newpayment->set_cc_verifycode(trim($params['orders_ccverifycode']));
	$order->add_payment($newpayment);
	$order->set_status(ORDERSTATUS_CANCELLED);

// 	// it worked.
// 	// set the payment status to void.
// 	$payment->set_status(orders_payment::STATUS_VOIDED);
// 	// save the order
	$order->save();

	// and we're done.
	$this->Audit($order_id,$this->GetName(),'Transaction '.$payment->get_txn_id().' Voided');
	$this->SetMessage($this->Lang('msg_transactionvoided'));
	$this->Redirect($id,'admin_manageorder',$returnid,array('orderid'=>$order_id));
	return;
      }
    else if( $status != PAYMENT_STATUS_NOTFOUND )
      {
	// some other error
	$this->Audit($order_id,$this->GetName().'Error occurred voiding transaction '.$message);
	$this->SetError($this->Lang('error_gatewayproblem').': '.$message);
	$this->Redirect($id,'admin_manageorder',$returnid,array('orderid'=>$order_id));
	return;
      }

    $gateway_module->reset();
  }

if( $do_credit )
  {
    // we're gonna do a credit trancation.
    $gateway_module->SetTransactionType(CGPaymentGatewayBase::TRANS_CREDIT);
    $gateway_module->SetCreditCardInfo($payment->get_cc_number(),$payment->get_cc_expiry(),$payment->get_cc_verifycode());
    $gateway_module->SetInvoice($order->get_invoice());
    $gateway_module->SetPaymentId($payment->get_id());
    $gateway_module->SetTransactionId($payment->get_txn_id());
    $gateway_module->SetOrderID($order_id);
    $gateway_module->SetTransactionAmount($amount);
    $gateway_module->ProcessTransaction();

    $status = $gateway_module->GetTransactionStatus();
    $message = $gateway_module->GetMessage();
    $gateway_module->reset();

    if( $status == PAYMENT_STATUS_APPROVED )
      {
	$newpayment = new orders_payment();
	$newpayment->set_status(orders_payment::STATUS_REFUNDED);
	$newpayment->set_method(orders_payment::TYPE_ONLINE);
	$newpayment->set_payment_date(time());
	$newpayment->set_amount($amount);
	$newpayment->set_cc_number($payment->get_cc_number());
	$newpayment->set_cc_expiry($payment->get_cc_expiry());
	$newpayment->set_cc_verifycode(trim($params['orders_ccverifycode']));
	$order->add_payment($newpayment);
	$order->set_status(ORDERSTATUS_CANCELLED);
// 	$payment->set_status(orders_payment::STATUS_REFUNDED);
	$order->save();

	// and we're done.
	$this->Audit($order_id,$this->GetName(),'Transaction '.$payment->get_txn_id().' Refunded');
	$this->SetMessage($this->Lang('msg_transactionrefunded'));
	$this->Redirect($id,'admin_manageorder',$returnid,array('orderid'=>$order_id));
      }
  }

$this->Audit($order_id,$this->GetName().'Error occurred voiding transaction '.$message);
$this->SetError($this->Lang('error_gatewayproblem').': '.$message);
$this->Redirect($id,'admin_manageorder',$returnid,array('orderid'=>$order_id));

// if we got here, something is wrong
// log an error, and return.

#
# EOF
#
?>