<?php
#-------------------------------------------------------------------------
# Module: Orders - A simple order processing module.
# Version: 1.0, calguy1000 <calguy1000@cmsmadesimple.org>
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/skeleton/
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in every page of
# its admin section that the site was built with CMS Made simple, and
# provide a link to the CMS Made Simple website.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
if( !isset($gCms) ) exit;
if( !$this->CheckPermission(ORDERS_PERM_MANAGEORDERS) )
  {
    die('permission denied');
  }

if ($this->GetPreference('force_ssl','0') == 1 && 
    (! isset($_SERVER['HTTPS']) || empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] == 'off'))
  {
    cge_redirect::redirect_https();
  }


//
// initialization
//
if( !isset($params['orderid']) )
  {
    echo $this->DisplayErrorMessage($this->Lang('error_insufficientparams'));
    return;
  }
if( !isset($params['payment_id']) )
  {
    echo $this->DisplayErrorMessage($this->Lang('error_insufficientparams'));
    return;
  }
$orderid = (int)$params['orderid'];
$payment_id = (int)$params['payment_id'];
$errors = array();
$warnings = array($this->Lang('warning_manual_refund'));
$ccprocessing_gateway = $this->GetPreference('ccprocessing_module',-1);
$ccmodule = cms_utils::get_module($ccprocessing_gateway);
if( !is_object($ccmodule) )
  {
    $this->SetError($this->Lang('error_noccmodule'));
    $this->Redirect($id,'admin_manageorder',$returnid,array('orderid'=>$order_id));
    return;
  }
if( !$ccmodule->SupportsRefunds() )
  {
    $this->SetError($this->Lang('error_invalidgateway'));
    $this->Redirect($id,'admin_manageorder',$returnid,array('orderid'=>$order_id));
    return;
  }

//
// setup
//
if( isset($params['cancel']) )
  {
    $parms = array('orderid'=>$orderid);
    $this->Redirect($id,'admin_manageorder',$returnid,$parms);
    return;
  }
$order_obj = orders_ops::load_by_id($orderid);
$payment_obj = $order_obj->get_payment_by_id($payment_id);
if ( !isset($_SERVER['HTTPS']) || empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] == 'off')
  {
    $warnings[] = $this->Lang('warning_https');
  }
if( $order_obj->get_status() == ORDERSTATUS_CANCELLED )
  {
    $warnings[] = $this->Lang('warning_orderstatus_cancelled');
  }
if( $ccprocessing_gateway == -1 )
  {
    $warnings[] = $this->Lang('warning_no_ccprocessing_gateway');
  }

//
// handle form submission
//
if( isset($params['submit']) )
  {
    unset($params['submit']);
    $amt = (float)$params['amount'];
    $amt = abs($amt);
    
    if( $amt > $order_obj->get_amount_paid() )
      {
	$errors[] = $this->Lang('error_invalid_refundamount');
      }

    $payment_new = '';
    if( !count($errors) )
      {
	// build a new payment.
	$payment_new = new orders_payment();
	$payment_new->set_order_id($payment_obj->get_order_id());
	$payment_new->set_txn_id($payment_obj->get_txn_id());
	$payment_new->set_cc_number($payment_obj->get_cc_number());
	$payment_new->set_cc_verifycode($payment_obj->get_cc_verifycode());
	$payment_new->set_cc_expiry($payment_obj->get_cc_expiry());
	if( $amt > 0 ) $amt = $amt * -1;
	$payment_new->set_amount($amt);
	$payment_new->set_notes(trim($params['notes']));
	$payment_new->set_method(orders_payment::TYPE_ONLINE);
	$payment_new->set_status(orders_payment::STATUS_REFUNDED);
	$payment_new->set_gateway($ccprocessing_gateway);
	$payment_new->set_payment_date(time());
      }

    if( !count($errors) && is_object($payment_new) )
      {
	// submit the new payment for refund
	$ccmodule->SetTransactionType(CGPaymentGatewayBase::TRANS_CREDIT);
	$ccmodule->SetCreditCardInfo($payment_new->get_cc_number(),$payment_new->get_cc_expiry(),$payment_new->get_cc_verifycode());
	$ccmodule->SetInvoice($order_obj->get_invoice());
	$ccmodule->SetTransactionId($payment_new->get_txn_id());
	$ccmodule->SetOrderId($orderid);
	$ccmodule->SetTransactionAmount(number_format($payment_new->get_amount(),2));

	$ccmodule->ProcessTransaction();
	$status = $ccmodule->GetTransactionStatus();
	$message = $ccmodule->GetMessage();
	$ccmodule->reset();

	if( $status != PAYMENT_STATUS_APPROVED )
	  {
	    $errors[] = $message;
	    $payment_new->set_amount($payment_new->get_amount()*-1);
	    $payment_obj = $payment_new;
	  }
	else
	  {
	    // it worked, save it, and redirect outa here.
	    $order_obj->add_payment($payment_new);
	    if( $amt == $order_obj->get_amount_paid() )
	      {
		$order_obj->set_status(ORDERSTATUS_CANCELLED);
	      }
	    $order_obj->save();

	    $this->Audit($orderid,$this->GetName().' Refunded '.$amt.' on transaction '.$payment_new->get_txn_id());
	    $this->SetMessage($this->Lang('msg_transactionrefunded'));
	    $this->Redirect($id,'admin_manageorder',$returnid,array('orderid'=>$orderid));
	  }
      }
  }

//
// Give everything to smarty
//
$smarty->assign('formstart',$this->CGCreateFormStart($id,'admin_manualrefund',$returnid,$params));
$smarty->assign('formend',$this->CreateFormEnd());
$smarty->assign('order_obj',$order_obj);
$smarty->assign('payment',$payment_obj);
$smarty->assign('warnings',$warnings);
if( count($errors) ) $smarty->assign('errors',$errors);

echo $this->ProcessTemplate('admin_manualrefund.tpl');

#
# EOF
#
?>
