<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2009 by Duketown
#
# This function supports adding incidents
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

// Initialize new incident (Fields on front end)
$product = '';
$description = '';
$usedcategory = 0;
$requestor_ref = '';
$detail_description = '';
$usedpriority = '5';
// Initialize fields not on front end
$status = $this->GetPreference('defaultstatus', 'OP');
$sendmail = 0;
$owner_id = $this->GetPreference('defaultowner', 0);
$usedpriorityseq = 5;
$createdate = trim($db->DBTimeStamp(time()), "'");
$do_send_email = false;
$do_redirect = false;

// Handle the page to go to after cancel or submit.
$dest_page = $returnid;
$tmp = $this->GetPreference('fesubmit_redirect');
if( !empty($tmp) )
{
	$manager =& $gCms->GetHierarchyManager();
	$node =& $manager->sureGetNodeByAlias($tmp);
	if (isset($node))
	{
		$tmp2 =& $node->GetContent();
		if (isset($tmp2))
		{
			$dest_page = $tmp2->Id();
		}
	}
	else
	{
		$node =& $manager->sureGetNodeById($tmp);
		if (isset($node))
		{
			$dest_page = $tmp;
		}
	}
}

if (isset($params['cancel'])) {
    $this->RedirectContent($dest_page);
}
$useremail = '';
// Make sure that requestor is logged in, so we have an internal number as well
if( $usedrequestor == '' )
{
	$usedrequestor = $this->GetFEUUserid();
	$useremail = $this->GetFEUUseremail($usedrequestor);
	$username = $this->GetFEUUsername($usedrequestor);
}

if( $usedrequestor <= 0  ) 
{
	$this->RedirectContent($dest_page);
}

// Handle the entry done by the requestor
if( isset( $params['submit'] ) )
{
	if (isset($params['description']) )
	{
		$description = cms_html_entity_decode($params['description']);
	}

	if (isset($params['product']))
	{
		$product = cms_html_entity_decode($params['product']);
	}
	
	if (isset($params['cat_id']))
	{
		$usedcategory = $params['cat_id'];
	}

		if (isset($params['requestor_ref']))
	{
		$requestor_ref = cms_html_entity_decode($params['requestor_ref']);
	}
	
	if (isset($params['detail_description']))
	{
		$detail_description = cms_html_entity_decode($params['detail_description']);
	}

		if (isset($params['priority']))
	{
		$usedpriority = $params['priority'];
	}


	// Validate all the field values
	$error = false;

	if( $description == '' )
	{
		$error = true;
		$smarty->assign('error',$this->Lang('noincidentdescgiven'));
	}

	if( $error == false )
	{

		// Generate a new incident number
		$incident_id = $db->GenID(cms_db_prefix()."module_servicedesk_incidents_seq");
		$query = 'INSERT INTO '.cms_db_prefix().'module_servicedesk_incidents (incident_id, description, product, cat_id,
			requestor_id, status, sendmail, requestor_ref, detail_description, owner_id, priority, priorityseq, create_date,
			modified_date, start_date, end_date)
			VALUES (?,?,?,?,
				?,?,?,?,?,?,?,?,?,
				?,?,?)';
		$db->Execute($query, array($incident_id, $description, $product, $usedcategory, 
			$usedrequestor, $status, $sendmail, $requestor_ref, $detail_description, $owner_id, $usedpriority, $usedpriorityseq,
			$createdate, NULL, $createdate, NULL));

		// Send an email
		$do_send_email = true;
		$do_redirect = true;

		// Send an event
		@$this->SendEvent('IncidentAdded', array(
				'incident_id' => $incident_id, 
				'description' => $description, 
				'product' => $product, 
				'requestor_ref' => $requestor_ref, 
				'detail_description' => $detail_description, 
				'status' => $status, 
				'createdate' => $createdate));
	}
}

// Prepare a list of categories
$categorylist = array();
$categorylist = $this->GetListCategories();

// Prepare the various priorities
$prioritydropdown = array();
$prioritydropdown = $this->GetListPriorities();

// Prepare the form
$smarty->assign('startform',$this->CreateFrontEndFormStart($id,$returnid,'fesubmit','post','multipart/form-data'));
$smarty->assign('endform',$this->CreateFormEnd());
$this->smarty->assign('descriptiontext', $this->Lang('incidentdescription'));
$this->smarty->assign('descriptioninput', $this->CreateInputText($id, 'description', $description, 80, 80, 'class="defaultfocus"'));
$this->smarty->assign('producttext', $this->Lang('product'));
$this->smarty->assign('productinput', $this->CreateInputText($id, 'product', $product, 20, 20));
$this->smarty->assign('categorytext', $this->Lang('category'));
$this->smarty->assign('categoryinput', $this->CreateInputDropdown($id, 'cat_id', $categorylist, -1, $usedcategory));
$this->smarty->assign('requestor_reftext', $this->Lang('requestor_reference'));
$this->smarty->assign('requestor_refinput', $this->CreateInputText($id, 'requestor_ref', $requestor_ref, 25, 25));
$this->smarty->assign('detaildesctext', $this->Lang('detaildescription'));
$this->smarty->assign('detaildescinput', $this->CreateTextArea(false,
	$id, $detail_description, 'detail_description', '', '', '', '', '80', '3'));
$this->smarty->assign('prioritytext', $this->Lang('priority'));
$this->smarty->assign('priorityinput', $this->CreateInputDropdown($id, 'priority', $prioritydropdown, -1, $usedpriority));

$this->smarty->assign('hidden', '');
$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', $this->Lang('submit')));
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', $this->Lang('cancel')));

$template = $this->GetPreference('current_form_template');
if (isset($params['formtemplate']))
  {
    $template = 'form_'.$params['formtemplate'];
  }
echo $this->ProcessTemplateFromDatabase($template);

if( $do_send_email == true )
{
 	// This needs to be done after the form is generated
 	// because we use some of the same smarty variables
 	$cmsmailer =& $this->GetModuleInstance('CMSMailer');
 	if( $cmsmailer )
 	{
		// Set the variables for the template
		if ( $createdate != '' ) $smarty->assign('createdate',$createdate);
		if ( $description != '' ) $smarty->assign('description',$description);
		if ( $incident_id != '' ) $smarty->assign('incident_id',$incident_id);
		if ( $product != '' ) $smarty->assign('product',$product);
		if ( $requestor_ref != '' ) $smarty->assign('yourref',$requestor_ref);
		if ( $username != '' ) $smarty->assign('name',$username);

		// Check if confirmation mail is to be send
		if ( $this->GetPreference('sendmailincident') ) {
			// If there is a mailaddress of the requestor, use it to confirm incident logging
	 		if( $useremail != '' )
			{
	 			// Prepare the mail and send it
	 			$cmsmailer->AddAddress( $useremail );
	 			$cmsmailer->SetSubject( $this->GetPreference('receivedincidentmailsubject',$this->Lang('subjectnewincident')));
	 			$cmsmailer->IsHTML( false );
	 			
				$body = $this->ProcessTemplateFromDatabase('receiveincidentmailtemplate');
				$cmsmailer->SetBody( $body );
				$cmsmailer->Send();
			}
		}

		// Check if mail for the back office is requested
		if ( $this->GetPreference('sendmailincident2admin') ) {
			// Retrieve info from owner of the new incident
			$query = 'SELECT * FROM '.cms_db_prefix().'users WHERE user_id = ?';
		     $row = $db->GetRow($query, array($owner_id));
			$owneremail = '';
		     if ($row)
			{
				$owneremail = $row['email'];
			}
			// If there is an email address of owner, use it to send the 'new icident' mail
	 		if( $owneremail != '' )
			{
	 			// Make sure that there is only one mail send out
	 			$cmsmailer->ClearAddresses();
	 			// Prepare the mail and send it
	 			$cmsmailer->AddAddress( $owneremail );
	 			$cmsmailer->SetSubject( $this->GetPreference('newincidentmailsubject2admin',$this->Lang('subjectnewincident2admin')));
	 			$cmsmailer->IsHTML( false );
	 			
				$body = $this->ProcessTemplateFromDatabase('newincidentmail2admintemplate');
				$cmsmailer->SetBody( $body );
				$cmsmailer->Send();
			}
		}
 	}
}

if( $do_redirect )
  {
    $this->RedirectContent($dest_page);
  }

?>