<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown
#
# This function supports editing an incident
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

$detailpage = '';
if (isset($params['detailpage']))
  {
    $manager =& $gCms->GetHierarchyManager();
    $node =& $manager->sureGetNodeByAlias($params['detailpage']);
    if (isset($node))
      {
	$content =& $node->GetContent();
	if (isset($content))
	  {
	    $detailpage = $content->Id();
	  }
      }
    else
      {
	$node =& $manager->sureGetNodeById($params['detailpage']);
	if (isset($node))
	  {
	    $detailpage = $params['detailpage'];
	  }
      }
  }


if (!$this->CheckPermission('Use ServiceDesk'))
{
	echo $this->ShowErrors($this->Lang('needpermission', array('Use ServiceDesk')));
	return;
}

if (isset($params['cancel']))
{
	$params = array('active_tab' => 'incidents');
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
}
if (FALSE == empty($params['detail_tab']))
{
	$tab = $params['active_tab'];
} else {
	$tab = '';
}

echo $this->StartTabHeaders();
	echo $this->SetTabHeader('incidentdetail',$this->Lang('title_incidentdetail'), ('incidentdetail' == $tab)?true:false);
	echo $this->SetTabHeader('notes',$this->Lang('title_notes'), ('notes' == $tab)?true:false);
echo $this->EndTabHeaders();

$incident_id = '';
if (isset($params['incident_id']))
{
	$incident_id = $params['incident_id'];
}

// Assign the smarty variable on the incident now. As a result this has to be done only once.
$this->smarty->assign('incidenttext', $this->Lang('incident'));
$this->smarty->assign('incident_id', $incident_id);

// The content of the tabs
echo $this->StartTabContent();
{
	// --- Start tab incident detail ---
	echo $this->StartTab('incidentdetail', $params);

	$product = '';
	if (isset($params['product']))
	{
		$product = $params['product'];
	}
	
	$usedcategory = '';
	if (isset($params['cat_id']))
	{
		$usedcategory = $params['cat_id'];
	}
	
	$usedrequestor = '0';
	if (isset($params['requestor_id']))
	{
		$usedrequestor = $params['requestor_id'];
	}
	
	$requestor_ref = '';
	if (isset($params['requestor_ref']))
	{
		$requestor_ref = $params['requestor_ref'];
	}
	
	$sendmail = 0;
	if (isset($params['sendmail']))
	{
		$sendmail = $params['sendmail'];
	}
	
	$prevstatus = '';
	if (isset($params['prevstatus']))
	{
		$prevstatus = $params['prevstatus'];
	}
	
	$usedstatus = '';
	if (isset($params['status']))
	{
		$usedstatus = $params['status'];
	}
	
	$usedowner_id = 0;
	if (isset($params['owner_id']))
	{
		$usedowner_id = $params['owner_id'];
	}
	
	$origdesc = 0;
	if (isset($params['origdesc']))
	{
		$origdesc = $params['origdesc'];
	}
	
	$usedpriority = '5';
	if (isset($params['priority']))
	{
		$usedpriority = $params['priority'];
	}
	
	$usedpriorityseq = 5;
	if (isset($params['priorityseq']))
	{
		$usedpriorityseq = $params['priorityseq'];
	}
	
	$now = trim($db->DBTimeStamp(time()), "'");
	
	$description = '';
	if (isset($params['description']))
	  {
		$description = $params['description'];
		if ($description != '')
		  {
			$query = 'UPDATE '.cms_db_prefix().'module_servicedesk_incidents SET 
				description = ?, product = ?, cat_id = ?,
				requestor_id = ?, status = ?, sendmail = ?, requestor_ref = ?, detail_description = ?,
				owner_id = ?, priority =? , priorityseq =?, modified_date = ? 
				WHERE incident_id = ?';
			$db->Execute($query, array($description, $product, $usedcategory, 
				$usedrequestor, $usedstatus, $sendmail, $requestor_ref, $detail_description, $usedowner_id,
				$usedpriority, $usedpriorityseq, $now, $incident_id));
	
			#@$this->SendEvent('IncidentEdited', array('incident_id' => $incident_id, 'description' => $description, 'origdesc' => $origdesc));
	
			// Check if a mail should be send for the new status
			if ($usedstatus <> $prevstatus) {
				// Retrieve settings for the new status
				$query = "SELECT * FROM ".cms_db_prefix()."module_servicedesk_statusses WHERE status = ?";
				$row = $db->GetRow($query, array($usedstatus));
	
				if ($row && $row['sendmail'] )
				{
					$cmsmailer =& $this->GetModuleInstance('CMSMailer');
					if( $cmsmailer )
					{
						// Retrieve user related material
						$useremail = $this->GetFEUUseremail($usedrequestor);
						$username = $this->GetFEUUsername($usedrequestor);
						if( $useremail != '' )
						{
							// Now that all seems to be in place, prepare variables and send mail
							if ( $start_date != '' ) $smarty->assign('startdate',$start_date);
							if ( $description != '' ) $smarty->assign('description',$description);
							if ( $incident_id != '' ) $smarty->assign('incident_id',$incident_id);
							if ( $product != '' ) $smarty->assign('product',$product);
							if ( $requestor_ref != '' ) $smarty->assign('yourref',$requestor_ref);
							if ( $username != '' ) $smarty->assign('name',$username);
							
							$cmsmailer->AddAddress( $useremail );
							// Replace values in subject for more readability
							$mailsubject = $row['mailsubject'];
							$mailsubject = str_ireplace('{$incident_id}', $incident_id, $mailsubject);
							$mailsubject = str_ireplace('{$yourref}', $requestor_ref, $mailsubject);
							$cmsmailer->SetSubject( $mailsubject);
							$cmsmailer->IsHTML( $row['htmlmail'] );
							
							$body = $this->ProcessTemplateFromData($row['mailbody']);
							$cmsmailer->SetBody( $body );
							$cmsmailer->Send();
						}
					}				
				}
				if ($usedstatus == 'CL') {
					// Status set to closed, set the end date
					$this->CloseIncident($incident_id);
				}
			}
	
			$params = array('tab_message'=> 'incidentupdated', 'active_tab' => 'incidents');
			$this->Redirect($id, 'defaultadmin', $returnid, $params);
		  }
		else
		  {
			echo $this->ShowErrors($this->Lang('noincidentdescgiven'));
		  }
	  }
	 else
	   {
		 $query = 'SELECT * FROM '.cms_db_prefix().'module_servicedesk_incidents WHERE incident_id = ?';
		 $row = $db->GetRow($query, array($incident_id));
	
		 if ($row)
		   {
			$description = $row['description'];
			$product = $row['product'];
			$usedcategory = $row['cat_id'];
			$usedrequestor = $row['requestor_id'];
			$usedstatus = $row['status'];
			$sendmail = $row['sendmail'];
			$requestor_ref = $row['requestor_ref'];
			$detail_description = $row['detail_description'];
			$usedowner_id = $row['owner_id'];
			$usedpriority = $row['priority'];
			$usedpriorityseq = $row['priorityseq'] - 1;
			$start_date = $row['start_date'];
		   }
	   }
	
	// Prepare a list of categories
	$categorylist = array();
	$categorylist = $this->GetListCategories();
	
	// Prepare a list of requestors
	$requestorlist = array();
	$requestorlist = $this->GetListRequestors();
	
	// Prepare a list of statusses
	$statuslist = array();
	$statuslist = $this->GetListStatusses();
	
	// Prepare a list of internal users (one of which will be the owner)
	$ownerlist = array();
	$ownerlist = $this->GetListOwners();
	
	// Prepare the various priorities
	$prioritydropdown = array();
	$prioritydropdown = $this->GetListPriorities();
	
	// Prepare the various priorities scores (need to fidle around a bit to get the indexes right: don't want sequence 0 to be selected)
	$priorityseqdropdown = array();
	$priorityseqdropdown = $this->GetListPrioritySeq();
	
	#Display template
	$this->smarty->assign('startform', $this->CreateFormStart($id, 'editincident', $returnid));
	$this->smarty->assign('endform', $this->CreateFormEnd());
	$this->smarty->assign('descriptiontext', $this->Lang('incidentdescription'));
	$this->smarty->assign('descriptioninput', $this->CreateInputText($id, 'description', $description, 80, 80, 'class="defaultfocus"'));
	$this->smarty->assign('producttext', $this->Lang('product'));
	$this->smarty->assign('productinput', $this->CreateInputText($id, 'product', $product, 20, 20));
	$this->smarty->assign('categorytext', $this->Lang('category'));
	$this->smarty->assign('categoryinput', $this->CreateInputDropdown($id, 'cat_id', $categorylist, '', $usedcategory));
	$this->smarty->assign('requestortext', $this->Lang('requestor'));
	if ($this->GetPreference('allowchangerequestor', true)) {
		$this->smarty->assign('requestorinput', $this->CreateInputDropdown($id, 'requestor_id', 
			$requestorlist, '', $usedrequestor));
	}
	else {
		$this->smarty->assign('requestorinput', $this->GetRequestor($usedrequestor));
	}
	$this->smarty->assign('requestor_reftext', $this->Lang('requestor_reference'));
	$this->smarty->assign('requestor_refinput', $this->CreateInputText($id, 'requestor_ref', $requestor_ref, 25, 25));
	$this->smarty->assign('detaildesctext', $this->Lang('detaildescription'));
	$this->smarty->assign('detaildescinput', $this->CreateTextArea($this->GetPreference('enableeditor', true),
		$id, $detail_description, 'detail_description', '', '', '', '', '80', '3'));
	$this->smarty->assign('prioritytext', $this->Lang('priority'));
	$this->smarty->assign('priorityinput', $this->CreateInputDropdown($id, 'priority', $prioritydropdown, '', $usedpriority));
	$this->smarty->assign('priorityseqtext', $this->Lang('priorityseq'));
	$this->smarty->assign('priorityseqinput', $this->CreateInputDropdown($id, 'priorityseq', $priorityseqdropdown, $usedpriorityseq));
	$this->smarty->assign('statustext', $this->Lang('status'));
	$this->smarty->assign('statusinput', $this->CreateInputDropdown($id, 'status', $statuslist, '', $usedstatus));
	$this->smarty->assign('sendmailtext',$this->Lang('sendmailincident'));
	$this->smarty->assign('sendmailinput', $this->CreateInputCheckbox($id, 'sendmail', true, $this->GetPreference('sendmailincident', true)));
	$this->smarty->assign('ownertext', $this->Lang('owner'));
	$this->smarty->assign('ownerinput', $this->CreateInputDropdown($id, 'owner_id', $ownerlist, '', $usedowner_id));
	
	$this->smarty->assign('hidden',
		$this->CreateInputHidden($id, 'incident_id', $incident_id).
		$this->CreateInputHidden($id, 'start_date', $start_date).
		$this->CreateInputHidden($id, 'prevstatus', $usedstatus).
		$this->CreateInputHidden($id, 'origdesc', $description));
	$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
	$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
	echo $this->ProcessTemplate('editincident.tpl');

	echo $this->EndTab();
	// --- End tab notes ---

	// --- Start tab categories ---
	echo $this->StartTab('notes', $params);

	$query = '';
	$dbresult = '';
	$query = 'SELECT *
			FROM '.cms_db_prefix().'module_servicedesk_notes
			WHERE incident_id = ?
			ORDER BY note_id desc';
	$dbresult = $db->Execute($query, array($incident_id));
	$rowclass = 'row1';
	$entryarray = array();

	while ($dbresult && $row = $dbresult->FetchRow())
	{
		$onerow = new stdClass();

		$onerow->id = $row['note_id'];
		$onerow->note = $row['note'];
		$onerow->notedate = $row['note_date'];
		$userops =& $gCms->GetUserOperations();
		$theuser =& $userops->LoadUserById( $row['user_id'] );
		$onerow->username = $theuser->username;

/*
		$onerow->editlink = $this->CreateLink($id, 'editstatus', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/edit.gif', $this->Lang('edit'),'','','systemicon'), array('stat_id'=>$row['stat_id']));
		$onerow->deletelink = $this->CreateLink($id, 'deleterow', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/delete.gif', $this->Lang('delete'),'','','systemicon'), array('table'=>'Statusses','stat_id'=>$row['stat_id']), $this->Lang('areyousurestatus'));
*/
		$onerow->rowclass = $rowclass;

		$entryarray[] = $onerow;

		($rowclass=="row1"?$rowclass="row2":$rowclass="row1");
	}
	$this->smarty->assign_by_ref('items', $entryarray);
	$this->smarty->assign('itemcount', count($entryarray));

	$this->smarty->assign('notetext', $this->Lang('title_note'));
	$this->smarty->assign('datetext', $this->Lang('title_notedate'));
	$this->smarty->assign('usertext', $this->Lang('title_noteuser'));
		// Setup links
	$this->smarty->assign('addincidentnotelink', $this->CreateLink($id, 'addincidentnote', $returnid, $this->Lang('addincidentnote'), array('type'=>'form_', 'active_tab' => 'incidents', 'incident_id'=>$incident_id), '', false, false, 'class="pageoptions"'));
	$this->smarty->assign('addincidentnotelink', $this->CreateLink($id, 'addincidentnote', $returnid, $gCms->variables['admintheme']->DisplayImage('icons/system/newobject.gif', $this->Lang('addincidentnote'),'','','systemicon'), array(), '', false, false, '') .' '. $this->CreateLink($id, 'addincidentnote', $returnid, $this->Lang('addincidentnote'), array('type'=>'form_', 'active_tab' => 'incidents', 'incident_id'=>$incident_id), '', false, false, 'class="pageoptions"'));

	$this->smarty->assign('startform', $this->CreateFormStart($id, 'editincident', $returnid));
	$this->smarty->assign('endform', $this->CreateFormEnd());

	$this->smarty->assign('hidden',
		$this->CreateInputHidden($id, 'incident_id', $incident_id));
	$this->smarty->assign('notessubmit', $this->CreateInputSubmit($id, 'notessubmit', lang('submit')));
	$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
	echo $this->ProcessTemplate('listincidentnotes.tpl');

	echo $this->EndTab();
	// --- End tab notes ---
}
echo $this->EndTabContent();

?>