<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
# This function supports editing a category
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;
 
$detailpage = '';
if (isset($params['detailpage']))
  {
    $manager =& $gCms->GetHierarchyManager();
    $node =& $manager->sureGetNodeByAlias($params['detailpage']);
    if (isset($node))
      {
	$content =& $node->GetContent();
	if (isset($content))
	  {
	    $detailpage = $content->Id();
	  }
      }
    else
      {
	$node =& $manager->sureGetNodeById($params['detailpage']);
	if (isset($node))
	  {
	    $detailpage = $params['detailpage'];
	  }
      }
  }


if (!$this->CheckPermission('Use ServiceDesk'))
  {
	echo $this->ShowErrors($this->Lang('needpermission', array('Use ServiceDesk')));
    return;
  }

if (isset($params['cancel']))
  {
	$params = array('active_tab' => 'categories');
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
  }

$cat_id = '';
if (isset($params['cat_id']))
{
	$cat_id = $params['cat_id'];
}

$code = '';
if (isset($params['code']))
{
	$code = $params['code'];
}

$origdesc = 0;
if (isset($params['origdesc']))
{
	$origdesc = $params['origdesc'];
}

$description = '';
if (isset($params['description']))
  {
    $description = $params['description'];
    if ($description != '')
      {
		$query = 'UPDATE '.cms_db_prefix().'module_servicedesk_categories SET description = ? WHERE cat_id = ?';
		$db->Execute($query, array($description, $cat_id));

		#@$this->SendEvent('CategoryEdited', array('cat_id' => $cat_id, 'description' => $description, 'origdesc' => $origdesc));

		$params = array('tab_message'=> 'categoryupdated', 'active_tab' => 'categories');
		$this->Redirect($id, 'defaultadmin', $returnid, $params);
      }
    else
      {
		echo $this->ShowErrors($this->Lang('nocatdescgiven'));
      }
  }
 else
   {
     $query = 'SELECT * FROM '.cms_db_prefix().'module_servicedesk_categories WHERE cat_id = ?';
     $row = $db->GetRow($query, array($cat_id));

     if ($row)
       {
		$code = $row['code'];
		$description = $row['description'];
       }
   }

#Display template
$this->smarty->assign('startform', $this->CreateFormStart($id, 'editcategory', $returnid));
$this->smarty->assign('endform', $this->CreateFormEnd());
$this->smarty->assign('codetext', $this->Lang('code'));
$this->smarty->assign('codeinput', $code);
$this->smarty->assign('descriptiontext', $this->Lang('statusdescription'));
$this->smarty->assign('descriptioninput', $this->CreateInputText($id, 'description', $description, 40, 40, 'class="defaultfocus"'));
$this->smarty->assign('hidden',
	$this->CreateInputHidden($id, 'cat_id', $cat_id).
	$this->CreateInputHidden($id, 'origdesc', $description));
$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
echo $this->ProcessTemplate('editcategory.tpl');
?>
