<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2008 by Duketown <duketown@mantox.nl>
#
# This function supports deleting a row from the various tables
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

switch ($params['table'])
{
	case 'Categories':
		// Remove the category (no referencial check!)
		$query = 'SELECT * FROM '.cms_db_prefix().'module_servicedesk_categories WHERE cat_id = ?';
		$row = $db->GetRow( $query, array($params['cat_id']) );
		if ($row) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_servicedesk_categories WHERE cat_id = ?';
			$db->Execute($query, array($params['cat_id']) );
			$params = array('tab_message'=> 'categorydeleted', 'active_tab' => 'categories');
		}
		break;
	case 'Incidents':
		// Remove the incident (no referencial check!)
		$query = 'SELECT * FROM '.cms_db_prefix().'module_servicedesk_incidents WHERE incident_id = ?';
		$row = $db->GetRow( $query, array($params['incident_id']) );
		if ($row) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_servicedesk_incidents WHERE incident_id = ?';
			$db->Execute($query, array($params['incident_id']) );
			$params = array('tab_message'=> 'incidentdeleted', 'active_tab' => 'incidents');
		}
		break;
	case 'Statusses':
		// Remove the status (no referencial check!)
		$query = 'SELECT * FROM '.cms_db_prefix().'module_servicedesk_statusses WHERE stat_id = ?';
		$row = $db->GetRow( $query, array($params['stat_id']) );
		if ($row) {
			$query = 'DELETE FROM '.cms_db_prefix().'module_servicedesk_statusses WHERE stat_id = ?';
			$db->Execute($query, array($params['stat_id']) );
			$params = array('tab_message'=> 'statusdeleted', 'active_tab' => 'statusses');
		}
		break;
	case 'Templates':
			$this->DeleteTemplate($params['template_name']);
			if (isset($params['active_tab'])) {
				$active_tab = $params['active_tab'];
			}
			$params = array('tab_message'=> 'templatedeleted', 'active_tab' => $active_tab);
		break;
	default:
		break;
}

// redirect the user to the default admin screen
$this->Redirect($id, 'defaultadmin', $returnid, $params);

?>