<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2009 by Duketown
#
# This function supports the back end for the module servicedesk
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/servicedesk
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

if (! $this->CheckAccess())
	{
	return $this->DisplayErrorPage($id, $params, $returnid,$this->Lang('accessdenied'));
	}

if (FALSE == empty($params['active_tab']))
{
	$tab = $params['active_tab'];
} else {
	$tab = '';
}
// Check the version that is in use
$servicedeskversion = $this->GetPreference('servicedeskversion');
echo $this->StartTabHeaders();
	echo $this->SetTabHeader('incidents',$this->Lang('title_incidents'), ('incidents' == $tab)?true:false);
	echo $this->SetTabHeader('categories',$this->Lang('title_categories'), ('categories' == $tab)?true:false);
	echo $this->SetTabHeader('statusses',$this->Lang('title_statusses'), ('statusses' == $tab)?true:false);
	if ($this->CheckPermission('Modify Templates')) {
		echo $this->SetTabHeader('fetemplates',$this->Lang('fetemplates'), ('fetemplates' == $tab)?true:false);
		echo $this->SetTabHeader('mailsettings',$this->Lang('mailsettings'), ('mailsettings' == $tab)?true:false);
	}
	if ($this->CheckAccess('Modify Site Preferences')) {
		echo $this->SetTabHeader('options',$this->Lang('title_options'), ('options' == $tab)?true:false);
	}
	if ($servicedeskversion == 'silver') {
		echo $this->SetTabHeader('silverr1',$this->Lang('title_incidentsbyperiod'), ('silverr1' == $tab)?true:false);
		echo $this->SetTabHeader('silveroptions',$this->Lang('title_optionssilver'), ('silveroptions' == $tab)?true:false);
	}
	if ($servicedeskversion == 'gold') {
		echo $this->SetTabHeader('silverr1',$this->Lang('title_incidentsbyperiod'), ('silverr1' == $tab)?true:false);
		echo $this->SetTabHeader('goldoptions',$this->Lang('title_optionsgold'), ('goldoptions' == $tab)?true:false);
	}
echo $this->EndTabHeaders();

// The content of the tabs
echo $this->StartTabContent();
{
	// --- Start tab incidents ---
	echo $this->StartTab('incidents', $params);
	$fn = cms_join_path(dirname(__FILE__).'/function.admin_incidentstab.php');
	// Check if a specific commercial version is installed
	switch ($this->GetPreference('servicedeskversion')) {
		case 'silver':
			$fn = cms_join_path(dirname(__FILE__),'silver','silver.admin_incidentstab.php');
			break;
		case 'gold':
			break;
		default:
			break;
	}
	if (file_exists( $fn ) ) {
		include($fn);
	}
	else {
		include(cms_join_path(dirname(__FILE__).'/function.admin_incidentstab.php'));
	}
	
	echo $this->EndTab();
	// --- End tab incidents ---

	// --- Start tab categories ---
	echo $this->StartTab('categories', $params);
		include(dirname(__FILE__).'/function.admin_categoriestab.php');

	echo $this->EndTab();
	// --- End tab categories ---


	// --- Start tab statusses ---
	echo $this->StartTab('statusses', $params);
		include(dirname(__FILE__).'/function.admin_statussestab.php');


	echo $this->EndTab();
	// --- End tab statusses ---


	// --- Start tab front end templates ---
	if ($this->CheckPermission('Modify Templates')) {
		echo $this->StartTab('fetemplates', $params);
		include(dirname(__FILE__).'/function.admin_fetemplatestab.php');
	
		echo $this->EndTab();
	}
	// --- End tab front end templates ---

	// --- Start tab options ---
	if ($this->CheckAccess('Modify Template')) {
		echo $this->StartTab('mailsettings', $params);
		include(dirname(__FILE__).'/function.admin_mailsettingstab.php');
	
		echo $this->EndTab();
	}
	// --- End tab options ---

	// --- Start tab options ---
	if ($this->CheckAccess('Modify Site Preferences')) {
		echo $this->StartTab('options', $params);
		include(dirname(__FILE__).'/function.admin_optionstab.php');
	
		echo $this->EndTab();
	}
	// --- End tab options ---

	switch ($servicedeskversion)
	{
		case 'gold':
			// --- Start tab Gold ---
			echo $this->StartTab('goldoptions', $params);
			
			echo $this->Lang('nogoldoptions');
		
			echo $this->EndTab();
			// --- End tab Gold ---
			// When Gold version in use, all Silver extensions included 
			//break;
		case 'silver':
			// --- Start tab Silver ---
			echo $this->StartTab('silverr1', $params);
			
			$ap = cms_join_path(dirname(__FILE__),'silver','silver.report_incidentsmonth.php');
			if( file_exists( $ap ) )
			{
				include_once $ap;
			}
			else {
				echo $this->Lang('noreportinfo');
			}
			echo $this->EndTab();
			echo $this->StartTab('silveroptions', $params);
			
			$ap = cms_join_path(dirname(__FILE__),'silver','silver.admin_optionstab.php');
			if( file_exists( $ap ) )
			{
				include_once $ap;
			}
			else {
				echo $this->Lang('nosilveroptions');
			}
			echo $this->EndTab();
			// --- End tab Silver ---
			break;
	}


}
echo $this->EndTabContent();

?>