<?php
# ServiceDesk (Service desk to support incidents and requests). A module for CMS - CMS Made Simple
# Copyright (c) 2009 by Duketown <duketown@mantox.nl>
#
# This function supports adding a template
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
# The module's homepage is: http://dev.cmsmadesimple.org/projects/pms
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

$gCms = cmsms(); if( !is_object($gCms) ) exit;

if (!$this->CheckPermission('Modify Templates')) {
	echo $this->ShowErrors($this->Lang('accessdenied', array('Modify Templates')));
	return;
}

if (isset($params['cancel']))
{
	$this->Redirect($id, 'defaultadmin', $returnid, $params);
}

if (isset($params['active_tab'])) {
	$active_tab = $params['active_tab'];
}
if (isset($params['type']))
{
	$type = $params['type'];
}
$templatename = '';
$template = '';

// Validate the input
$message = '';
if (isset($params['submit']))
{
	$templatename = $params['template_name'];
	$template = $params['template'];
	if ($templatename != '' && $template != '')
	{
		$this->SetTemplate( $type . $templatename, $template, $this->GetName());

		$params = array('tab_message'=> 'templateadded', 'active_tab' => $active_tab);
		$this->Redirect($id, 'defaultadmin', $returnid, $params);
	}
	else
	{
		if ($templatename == '') $message .= $this->Lang('notemplatenamegiven');
		if ($template == '') {
			if ($message != '') $message .= '<br>';
			$message .= $this->Lang('notemplatecontentgiven');
		}
		echo $this->ShowErrors($message);
	}
}

// Make sure there is no index warning when running in debug mode
$this->smarty->assign('apply', '');
$this->smarty->assign('infomessage', '');

// Display template
$this->smarty->assign('startform', $this->CreateFormStart($id, 'addtemplate', $returnid));
$this->smarty->assign('endform', $this->CreateFormEnd());
$this->smarty->assign('prompt_templatename', $this->Lang('templatename'));
$this->smarty->assign('template_name', $this->CreateInputText($id, 'template_name', $templatename, 40, 40, 'class="defaultfocus"'));
$this->smarty->assign('prompt_template', $this->Lang('templatecontent'));
$this->smarty->assign('template', $this->CreateTextArea(false, $id, $template, 'template', '','','','',80,25));
$this->smarty->assign('hidden', $this->CreateInputHidden($id, 'type', $type).
	$this->CreateInputHidden($id, 'active_tab', $active_tab));
$this->smarty->assign('submit', $this->CreateInputSubmit($id, 'submit', lang('submit')));
$this->smarty->assign('cancel', $this->CreateInputSubmit($id, 'cancel', lang('cancel')));
echo $this->ProcessTemplate('edittemplate.tpl');
?>