<?php
#-------------------------------------------------------------------------
# Module: servicedesk - Service desk to support incidents and requests
# Version: 0.1, Duketown
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2009 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
# This file originally created by ModuleMaker module, version 0.3.1
# Copyright (c) 2009 by Samuel Goldstein (sjg@cmsmadesimple.org) 
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------

class servicedesk extends CMSModule
{

	function GetName()
	{
		return 'ServiceDesk';
	}

	function GetFriendlyName()
	{
		// Set the version in a preference, for speed and check in various other service desk programs
		$this->SetPreference('servicedeskversion', 'free');
		$fn = cms_join_path(dirname(__FILE__),'lib','gold');
		if (file_exists( $fn ) ) {
			$this->SetPreference('servicedeskversion', 'gold');
			return $this->Lang('friendlynamegold');
		}
		$fn = cms_join_path(dirname(__FILE__),'lib','silver');
		if (file_exists( $fn ) ) {
			$this->SetPreference('servicedeskversion', 'silver');
			return $this->Lang('friendlynamesilver');
		}
		return $this->Lang('friendlyname');
	}

	function GetVersion()
	{
		return '0.3';
	}

	function GetHelp()
	{
		return $this->Lang('help');
	}

	function GetAuthor()
	{
		return 'Duketown';
	}

	function GetAuthorEmail()
	{
		return 'cmsms @ duketown dot eu';
	}

	function GetChangeLog()
	{
		return file_get_contents(dirname(__FILE__).'/changelog.inc');
	}

	/*---------------------------------------------------------
	   IsPluginModule()
	   This function returns true or false, depending upon
	   whether users can include the module in a page or
	   template using a smarty tag of the form
	   {cms_module module='servicedesk' param1=val param2=val...}
	   
	   If your module does not get included in pages or
	   templates, return "false" here.
	  ---------------------------------------------------------*/
	function IsPluginModule()
	{
		return true;
	}

	/*---------------------------------------------------------
	   HasAdmin()
	   This function returns a boolean value, depending on
	   whether your module adds anything to the Admin area of
	   the site. For the rest of these comments, I'll be calling
	   the admin part of your module the "Admin Panel" for
	   want of a better term.
	  ---------------------------------------------------------*/
	function HasAdmin()
	{
		return true;
	}


	/*---------------------------------------------------------
	   GetAdminSection()
	   If your module has an Admin Panel, you can specify
	   which Admin Section (or top-level Admin Menu) it shows
	   up in. 
	  ---------------------------------------------------------*/
	function GetAdminSection()
	{
		return 'extensions';
	}


	/*---------------------------------------------------------
	   GetAdminDescription()
	   If your module does have an Admin Panel, you
	   can have it return a description string that gets shown
	   in the Admin Section page that contains the module.
	  ---------------------------------------------------------*/
	function GetAdminDescription()
	{
		return $this->Lang('admindescription');
	}


	/*---------------------------------------------------------
	   VisibleToAdminUser()
	   If your module does have an Admin Panel, you
	   can control whether or not it's displayed by the boolean
	   that is returned by this method. This is primarily used
	   to hide modules from admins who lack permission to use
	   them.
	   
	   Typically, you'll use some permission to set this
	   (e.g., $this->CheckPermission('Some Permission'); )
	  ---------------------------------------------------------*/
	function VisibleToAdminUser()
	{
        return true;
	}
	

	/*---------------------------------------------------------
	   CheckAccess()
	   This wrapper function will check against the specified permission,
	   and display an error page if the user doesn't have adequate permissions.
	  ---------------------------------------------------------*/
	function CheckAccess($perm = 'Use ServiceDesk')
		{
		return $this->CheckPermission($perm);
		}
	
	/*---------------------------------------------------------
	   DisplayErrorPage()
	   This is a simple function for generating error pages.
	  ---------------------------------------------------------*/
    function DisplayErrorPage($id, &$params, $return_id, $message='')
    {
		$this->smarty->assign('title_error', $this->Lang('error'));
		$this->smarty->assign_by_ref('message', $message);

        // Display the populated template
        echo $this->ProcessTemplate('error.tpl');
    }
	


	/*---------------------------------------------------------
	   GetDependencies()
	   Your module may need another module to already be installed
	   before you can install it.
	   This method returns a list of those dependencies and
	   minimum version numbers that this module requires.
	   
	   It should return an hash, eg.
	   return array('somemodule'=>'1.0', 'othermodule'=>'1.1');
	  ---------------------------------------------------------*/
	function GetDependencies()
	{
		return array('FrontEndUsers'=>'1.4.4', 'CMSMailer'=>'1.73.0');
	}

	/*---------------------------------------------------------
	   MinimumCMSVersion()
	   Your module may require functions or objects from
	   a specific version of CMS Made Simple.
	   ---------------------------------------------------------*/
	function MinimumCMSVersion()
	{
		return '1.8';
	}

	function MaximumCMSVersion()
	{
		return '1.9.9';
	}


	/*---------------------------------------------------------
	   InstallPostMessage()
	   After installation, there may be things you want to
	   communicate to your admin. This function returns a
	   string which will be displayed.
	  ---------------------------------------------------------*/
	function InstallPostMessage()
	{
		return $this->Lang('postinstall');
	}

	/*---------------------------------------------------------
	   UninstallPostMessage()
	   After removing a module, there may be things you want to
	   communicate to your admin. This function returns a
	   string which will be displayed.
	  ---------------------------------------------------------*/
	function UninstallPostMessage()
	{
		return $this->Lang('postuninstall');
	}

	/*---------------------------------------------------------
	   UninstallPreMessage()
	   This allows you to display a message along with a Yes/No dialog box. If the user responds
	   in the affirmative to your message, the uninstall will proceed. If they respond in the
	   negative, the uninstall will be canceled. Thus, your message should be of the form
	   "All module data will be deleted. Are you sure you want to uninstall this module?"
	  
	   If you don't want the dialog, have this method return a FALSE, which will cause the
	   module to uninstall immediately if the user clicks the "uninstall" link.
	  ---------------------------------------------------------*/
	function UninstallPreMessage()
	{
		return $this->Lang('really_uninstall');
	}
	
	/*---------------------------------------------------------
	   SetParameters()
	   Description of the available parameters for the front end
	  ---------------------------------------------------------*/
	function SetParameters()
	{
		#$this->CreateParameter('display', '', $this->Lang('helpdisplay'));
		#$this->CreateParameter('status', '', $this->Lang('helpstatus'));

		global $CMS_VERSION;
		$res = version_compare( $CMS_VERSION, '1.1' );
		if( $res >= 0 )
		{
			#
			# For 1.1's enhanced security checking, each parameter that is passed
			# in a frontend url or frontend form needs to be typed here.
			#
			$this->SetParameterType('currentuser',CLEAN_INT);
			$this->SetParameterType('detailpage',CLEAN_STRING);
			$this->SetParameterType('detailtemplate',CLEAN_STRING);
			$this->SetParameterType('lang',CLEAN_STRING);
			$this->SetParameterType('moretext',CLEAN_STRING);
			$this->SetParameterType('pagelimit',CLEAN_INT);
			$this->SetParameterType('pagenumber',CLEAN_INT);
			$this->SetParameterType('printtemplate',CLEAN_STRING);
			$this->SetParameterType('start',CLEAN_INT);
			$this->SetParameterType('status',CLEAN_STRING);
			$this->SetParameterType('statusnot',CLEAN_STRING);
			$this->SetParameterType('template',CLEAN_STRING);

			// Form parameters
			$this->SetParameterType('cat_id',CLEAN_INT);
			$this->SetParameterType('description',CLEAN_STRING);
			$this->SetParameterType('detail_description',CLEAN_STRING);
			$this->SetParameterType('priority',CLEAN_INT);
			$this->SetParameterType('product',CLEAN_STRING);
			$this->SetParameterType('requestor_ref',CLEAN_STRING);
			$this->SetParameterType('submit',CLEAN_STRING);
			$this->SetParameterType('cancel',CLEAN_STRING);
		}

		$this->mCachable = false;

	}

	/*---------------------------------------------------------
	   GetDashboardOutput()
	   This function is used by Admin\dashboard.php.
	   The string that is prepared in this function is displayed on the dashboard.
	  ---------------------------------------------------------*/
	function GetDashboardOutput()
	{
		global $gCms;
		$db =& $gCms->GetDb();

		$query = "SELECT count(*) FROM ".cms_db_prefix ()."module_servicedesk_incidents WHERE 
			status != ?";
		$row = &$db->GetRow($query, array('CL'));
		$countincidents = $row['count(*)'];
		switch ($countincidents) {
			case 0:
				$output = $this->Lang('openincidentsnone');
				break;
			case 1:
				$output = $this->Lang('openincidentsone');
				break;
			default:
				$output = $this->Lang('openincidents', $countincidents);
				break;
		}
		return $output;
	}

	/*---------------------------------------------------------
	   GetFEUUseremail()
	   This function retrieves the email of the logged in user
	  ---------------------------------------------------------*/
	function GetFEUUseremail($userid)
	{
		$useremail = false;
		$module =& $this->GetModuleInstance('FrontEndUsers');
		if( !$module ) return false;
		$useremail = $module->GetEmail($userid);
		return $useremail;
	}

	/*---------------------------------------------------------
	   GetFEUUsername()
	   This function retrieves the name of the logged in user
	  ---------------------------------------------------------*/
	function GetFEUUsername($userid)
	{
		$username = false;
		$module =& $this->GetModuleInstance('FrontEndUsers');
		if( !$module ) return false;
		$username = $module->GetUserName($userid);
		return $username;
	}

	/*---------------------------------------------------------
	   GetFEUProperty()
	   This function retrieves a passed property of the logged in user
	  ---------------------------------------------------------*/
	function GetFEUProperty($propname)
	{
		$txt = false;
		if( $this->_uid != -1 )
		{
			$module =& $this->GetModuleInstance('FrontEndUsers');
			if( !$module ) return false;
			$txt = $module->GetUserPropertyFull($propname,$this->_uid);
		}
		return $txt;
	}

	/*---------------------------------------------------------
	   GetFEUUserid()
	   This function retrieves the user id of the logged in user
	  ---------------------------------------------------------*/
	function GetFEUUserid()
	{
		if( $this->_uid == -1 || $this->_uid == NULL )
		{
			$module =& $this->GetModuleInstance('FrontEndUsers');
			if( !$module ) return 0;
			$this->_uid = $module->LoggedInId();
		}
		return $this->_uid;
	}

	/* --------------------------------------------------------
		GetListContent()
		A function to return all possible pages in an array
		--------------------------------------------------------*/	
	function GetListContent()
	{
		// Initialize the Database
		$db = cmsms()->GetDb();

		$contentlist = array();
		$query = 'SELECT * FROM '.cms_db_prefix().'content 
			WHERE active = 1
			ORDER BY menu_text';
		$dbresult = $db->Execute($query);
		while ($dbresult && $row = $dbresult->FetchRow())
		{
			$contentlist[$row['menu_text']] = $row['content_alias'];
		}
		
		return $contentlist;
	}

}

?>