{* summary template *}
{if $pagecount > 1}
{if isset($firstpage_url)}
  <a href="{$firstpage_url}" title="{$mod->Lang('firstpage')}">{$mod->Lang('firstpage')}</a>
  <a href="{$prevpage_url}" title="{$mod->Lang('prevpage')}">{$mod->Lang('prevpage')}</a>
{/if}

{if isset($lastpage_url)}
  <a href="{$nextpage_url}" title="{$mod->Lang('nextpage')}">{$mod->Lang('nextpage')}</a>
  <a href="{$lastpage_url}" title="{$mod->Lang('lastpage')}">{$mod->Lang('lastpage')}</a>
{/if}
{/if}

{if isset($rsrcs)}
<div class="availability_summary">
  {foreach from=$rsrcs item='one'}
  <div class="summary_item">
     <div>{$mod->Lang('id')}: {$one.id}</div>
     <div>{$mod->Lang('name')}: {$one.name}</div>
     <div>{$mod->Lang('base_price')}: {$mod->GetPreference('currency_symbol')}{$one.base_price}</div>
     <div><a href="{$one.detail_url}" title="{$one.name}">{$mod->Lang('more')}</a>
     <div>
       {* Description *}
       {$one.description}
     </div>

     {* attributes *}
     {* attributes are also available by name as $one.attribs_byname.<name> *}
     <fieldset style="width: 80%;">
       <legend>{$mod->Lang('attributes')}:&nbsp;</legend>
       {foreach from=$one.attribs item='attrib'}
         <span>{$attrib.name} </span>
       {/foreach}
     </fieldset>

     {* fields *}
     {* fields are also available by name as $one.fields_byname.<name> *}
     {if count($one.fields) > 0}
     <fieldset style="width: 80%;">
       <legend>{$mod->Lang('fields')}:&nbsp;</legend>
       {foreach from=$one.fields item='field'}
         <div>{$field.prompt}: {if isset($field.thumbnail)}<a href="{$one.file_location}/{$field.value}"><img src="{$one.file_location}/{$field.thumbnail}"/></a>{else}{$field.value}{/if}</div>
       {/foreach}
     </fieldset>
     {/if}
  </div>
  {/foreach}
</div>
{/if}