{* reservation form template *}
{if isset($resv_id)}
<h3>{$mod->Lang('edit_reservation')}</h3>
{else}
<h3>{$mod->Lang('create_reservation')}</h3>
{/if}

{if !isset($formstart)}
<p>{$mod->Lang('error_notloggedin_feu')}</p>
{else}
<div id="reservation_form_cont">

{if isset($status) && !empty($status)}
{cgerror}{$message}{/cgerror}
{/if}

{$formstart}

{*
 * ====
 * NOTE
 *
 * THIS IS NOT YOUR TYPICAL TEMPLATE FOR A CMSMS MODULE
 * -
 * This template makes extensive use of javascript,jquery,and ajax to perform its functions.  
 * although it is possible to modify the appearance, layout and behavour of this module extreme
 * caution must be taken with each modification.
 *
 * The ids, class names, and where necessary parent/child relationships used throughout this template are not
 * merely examples, they are tied together through the javascript/jquery, and testing should be done at every
 * step for each modification.
 * ====
 *}

{*
 * BEGIN JQUERY / JAVASCRIPT
 *}
{jsmin}{literal}<script type="text/javascript">
//<![CDATA[
  // 
  // some initial checks
  //
  var check_url = "{/literal}{module_action_link module=Availability action=json_check_avail urlonly=1}{literal}";
  check_url = check_url.replace(/amp;/g,'')+'&showtemplate=false';
  var deposit_url = "{/literal}{module_action_link module=Availability action=json_resvn_deposit urlonly=1}{literal}";
  deposit_url = deposit_url.replace(/amp;/g,'')+'&showtemplate=false';
  var rsrc_url = "{/literal}{module_action_link module=Availability action=json_rsrc_info urlonly=1}{literal}";
  rsrc_url = rsrc_url.replace(/amp;/g,'')+'&showtemplate=false';
  var actionid = '{/literal}{$actionid}{literal}';
  var currency_symbol = '{/literal}{$mod->GetPreference('currency_symbol','$')}{literal}';
  var date_format = '{/literal}{$date_format}{literal}';
  var error_resvn_conflict = '{/literal}{$mod->Lang('error_reservation_conflict')}{literal}';
  var error_no_resvn_parts = '{/literal}{$mod->Lang('error_no_reservation_parts')}{literal}';
//]]>
</script>{/literal}{/jsmin}
<script type="text/javascript" src="modules/{$mod->GetName()}/templates/orig_resvn_template.js"></script>

{* this is the template used for each individual part of the reservation *}
<div id="reservation_part_template" class="reservation_part" style="display: none; clear: left;">
 <p class="row_partnum" style="float: left; margin-right: 0.5em; width: 2em;"></p>
 <p style="float: left;">
   <input type="hidden" class="row_rsrc_id" name="YY_selrsrc_XX" value="-1"/>
   <input type="hidden" class="row_serdata" name="YY_serdata_XX" value=""/>
   <input type="hidden" class="row_startdate" name="YY_startdate_XX" value="-1"/>
   <input type="hidden" class="row_meridian" name="YY_startdate_XXmeridian" value="-1"/>
   <input type="hidden" class="row_enddate" name="YY_enddate_XX" value="-1"/>
   <input type="hidden" class="row_numpeople" name="YY_numpeople_XX" value="-1"/>
   <input type="hidden" class="row_price" name="YY_price_XX" value="-1"/>
   <span class="row_resource"></span><br/>
   {$mod->Lang('from')}: <span class="row_start_date"></span>
   {$mod->Lang('to')}: <span class="row_end_date"></span><br/>
   {$mod->Lang('num_people')}: <span class="row_num_people"></span><br/>
   {$mod->Lang('price')}: {$mod->GetPreference('currency_symbol','$')}<span class="row_show_price"></span><br/>
   <span class="actions">
     <img src="{root_url}/modules/Availability/icons/delete.gif" class="row_delete" alt="{$mod->Lang('delete')}"/>
   </span>
 </p>
</div>{* end reservation_part_template *}

<fieldset>
<legend>{$mod->Lang('reservation_parts')}</legend>
 {* the area where the completed reservation parts are going to go *}
 <div id="reservation_parts_list" style="width: 39%; float: left;">

 {if isset($reservation.id) && $reservation.id > 0}
 {foreach from=$reservation.parts item='part' name='part'}
 {assign var='idx' value=$smarty.foreach.part.iteration}
 {assign var='rsrc_id' value=$part.ext_rsrcid}
 <div id="reservation_part_{$smarty.foreach.part.iteration}" class="reservation_part" style="clear: left;">
   <p class="row_partnum" style="float: left; margin-right: 0.5em; width: 2em;">{$idx}</p>
   <p style="float: left;">
     <input type="hidden" class="row_rsrc_id" name="{$actionid}part_selrsrc_{$idx}" value="{$part.rsrc_id}"/>
     <input type="hidden" class="row_startdate" name="{$actionid}part_startdate_{$idx}" value="{$part.start_date|strtotime}"/>
     <input type="hidden" class="row_enddate" name="{$actionid}part_enddate_{$idx}" value="{$part.end_date|strtotime}"/>
     <input type="hidden" class="row_numpeople" name="{$actionid}part_numpeople_{$idx}" value="{$part.num_people}"/>
     <input type="hidden" class="row_price" name="{$actionid}part_price_{$idx}" value="{$part.price}"/>
     <span class="row_resource">{$rsrc_list.$rsrc_id}</span><br/>
     {$mod->Lang('from')}: <span class="row_start_date">{$part.start_date|cms_date_format}</span>
     {$mod->Lang('to')}: <span class="row_end_date">{$part.end_date|cms_date_format}</span><br/>
     {$mod->Lang('num_people')}: <span class="row_num_people">{$part.num_people}</span><br/>
     {$mod->Lang('price')}: {$mod->GetPreference('currency_symbol','$')}<span class="row_price">{$part.price}</span><br/>  
     <span class="actions">
       <img src="{root_url}/modules/Availability/icons/delete.gif" class="row_delete" alt="{$mod->Lang('delete')}"/>
     </span>
   </p>
  </div>
  {/foreach}
  {/if}  
 </div>


{* 
 * the area where we will edit a reservation part 
 *}
<div id="reservation_part_edit" style="width: 59%; float: right; padding-left: 0.5em; border-left: 1px solid;">
 <input type="hidden" id="sel_dyn_start_date" value="-1"/>
 <input type="hidden" id="sel_dyn_end_date" value="-1"/>
 <div>
   <p style="float: left; width: 30%;">{$mod->GetResourceType()}:</p>
   <p style="float: right; width: 69%;">
     <select id="sel_rsrc">
     {html_options options=$rsrc_list selected=$sel_rsrc}
     </select>
   </p>
   <p id="sel_rsrc_summary" style="margin-left: 1em;"></p>
 </div>
 <div id="rsrc_period_d" class="rsrc_period" style="clear: right; display: none;">
   <p style="float: left; width: 30%;">{$mod->Lang('start_date')}:</p>
   <p style="float: right; width: 69%;">
     {html_select_date prefix="sel_startdate_d_" end_year="+2" time=$init_start_date}
   </p>
   <p style="float: left; width: 30%;">{$mod->Lang('end_date')}:</p>
   <p style="float: right; width: 69%;">
     {html_select_date prefix="sel_enddate_d_" end_year="+2" time=$init_end_date}
   </p>
 </div>
 <div id="rsrc_period_p" class="rsrc_period" style="clear: right; display: none;">
   <p style="float: left; width: 30%;">{$mod->Lang('start_date')}:</p>
   <p style="float: right; width: 69%;">
     {html_select_date prefix="sel_startdate_p_" end_year="+2" time=$init_start_date}
     {$mod->Lang('at')}
     <select id='sel_meridian_p'>
       {html_options options=$meridians}
     </select>     
   </p>
 </div>
 <div id="rsrc_period_h" class="rsrc_period" style="clear: right; display: none;">
   <p style="float: left; width: 30%;">{$mod->Lang('start_date')}:</p>
   <p style="float: right; width: 69%;">
     {html_select_date prefix="sel_startdate_h_" end_year="+2" time=$init_start_date}
     {$mod->Lang('at')}
     {html_select_time display_seconds=false minute_interval=15 prefix="sel_startdate_h_"}
   </p>
 </div>
 <div id="sel_row_numpeople" style="clear: right; display: none;">
   <p style="float: left; width: 30%;">{$mod->Lang('num_people')}:</p>
   <p style="float: right; width: 69%;">
     <select id="sel_numpeople">
     {html_options options=$people_list}
     </select>
   </p>
 </div>
 <div id="sel_message" style="clear: right; display: none;"></div>
 <div id="sel_int_price" style="clear: right; display: none;"></div>
 <div id="sel_int_status" style="clear: right; display: none;"></div>
 <div id="sel_price" style="clear: right; display: none;">
   <p style="float: left; width: 30%;">{$mod->Lang('price')}</p>
   <p id="sel_price_amt" style="float: right; width: 69%;">
   </p>
 </div>
 <div id="sel_btns" style="clear: right; display: none;">
   <p style="float: left; width: 30%;"></p>
   <p style="float: right; width: 69%;">
     <input type="submit" id="sel_btn_check" value="{$mod->Lang('check')}"/>
     <input type="submit" id="sel_btn_add" value="{$mod->Lang('add')}" style="display: none;"/>
   </p>
 </div>
</div>
</fieldset>


{* this is the area for the rest of the form *}
<div class="form_row">
  <p class="form_text">{$mod->Lang('price')}:</p>
  <p class="form_input">{$mod->GetPreference('currency_symbol')}<span id="calcprice"></span></p>
</div>
{if $reservation_require_deposit == 1}
<div class="form_row">
  <p class="form_text">{$mod->Lang('minimum_deposit_required')}:</p>
  <p class="form_input">{$mod->GetPreference('currency_symbol')}<span id="calcdeposit"></span></p>
</div>
{/if}
<div class="form_row">
  <p class="form_text">{$mod->Lang('notes')}:</p>
  <p class="form_input">
    {assign var='txt' value=''}<textarea name="{$actionid}avail_order_notes" rows="5" cols="40">{$txt}</textarea>
  </p>
</div>
{if $reservation_require_deposit == 1}
<div class="form_row">
  <p class="form_text">{$mod->Lang('deposit_amount')}:</p>
  <p class="form_input">
    {$mod->GetPreference('currency_symbol','$')}
    <input type="text" id="userdeposit" name="{$actionid}avail_deposit_amount" value="" size="10" maxlength="10"/>
  </p>
</div>
{/if}

{*
 * The following is an example of how to prepare input elements to allow adding additional items to the reservation.
 * note, they are not added to the cart, but it does require the CGEcommerceBase and cart modules 
 * commented out by default.
{* copy the action id *}
{assign var='a_actionid' value=$actionid}

{* display some products we want to add on .. calling Products messes with the actionid var *}
{Products assign='junk'}
{foreach from=$items item='entry' name='prod'}
  <div style="border: 1px solid grey; margin-bottom: 0.5em;">
  {cgecomm_get_productinfo itemid=$entry->id assign='product'}
  <input type="checkbox" name="{$a_actionid}avail_extra_itemid[]" value="Products;;{$entry->id}"/>
  <input type="text" name="{$a_actionid}avail_extra_quantity[Products;;{$entry->id}]" value="{$smarty.foreach.prod.index}" size="2" maxlength="2"/>
  {$entry->product_name}
  {assign var='n_attrs' value=$product->count_attributes()}
  {if $n_attrs gt 0}
     {section name='s_attr' start=0 loop=$n_attrs step=1}
        {assign var='attr' value=$product->get_attr_by_idx($smarty.section.s_attr.index)}
         <select name="{$a_actionid}avail_extra_attrib_Products;;{$entry->id}x{$attr->get_id()}">
        {html_options options=$attr->get_dropdown_options()}
        </select>         
     {/section}
  {/if}
  </div>
{/foreach}
*}

<div class="form_row">
  <p class="form_text"></p>
  <p class="form_input">
    <input type="submit" id="submit_btn" name="{$a_actionid}avail_submit" value="{$mod->Lang('submit')}"/>
  </p>
</div>


{$formend}
</div>{* reservation_form_cont *}
{/if}
