  // 
  // some initial checks
  //
  if( !jQuery || !strftime || !strtotime )
  {
    alert('FATAL ERROR -- Necessary utilities required for this functionality to operate have not been loaded');
  }

  jQuery.extend({
      postJSON: function( url, data, callback ) {
           return jQuery.post(url, data, callback, "json");
      }
  });

  function _format_price(val)
  {
    str = currency_symbol + val;
    return str;
  }

  function _add_row(rsrc_id,rsrc_type,rsrc_str,start_date,end_date,num_people,meridian,price,serialized)
  {
     // get the number of children of class reservation_part
     var idx = 0;
     jQuery('#reservation_parts_list').children('.reservation_part').each(function(elem){
       var tmp = jQuery(this).find('.row_partnum').html();
       if( tmp > idx ) idx = tmp;
     });
     idx++;

     newrow = jQuery('#reservation_part_template').clone(true);
     newrow.attr('id','reservation_part_'+idx);
     newrow.find('input').each(function() {
       var name = jQuery(this).attr('name');
       name = name.replace('XX',idx);
       name = name.replace('YY',actionid+'avail_part');
       jQuery(this).attr('name',name);
     });

     newrow.find('input.row_rsrc_id').attr('value',rsrc_id);
     newrow.find('input.row_serdata').attr('value',serialized);
     newrow.find('input.row_meridian').attr('value',meridian);
     newrow.find('input.row_startdate').attr('value',strtotime(start_date));
     newrow.find('input.row_enddate').attr('value',strtotime(end_date));
     newrow.find('input.row_numpeople').attr('value',num_people);
     newrow.find('input.row_price').attr('value',price);

     newrow.find('.row_start_date').html(strftime(date_format,start_date));
     newrow.find('.row_end_date').html(strftime(date_format,end_date));
     newrow.find('.row_partnum').html(idx);
     newrow.find('.row_resource').html(rsrc_str);
     newrow.find('.row_num_people').html(num_people);
     newrow.find('.row_show_price').html(price);

     newrow.find('.row_delete').click(function(){
       // handle the delete button on reservation parts.
       var container = jQuery(this).parents('.reservation_part');
       _delete_row(container);
       return false;
     });

     newrow.find('.row_edit').click(function(){
       // handle the edit button on reservation parts.
       var container = jQuery(this).parents('.reservation_part');
       var rsrc_id = container.find('input.row_rsrc_id').attr('value');
       var start_date = container.find('input.row_startdate').attr('value');
       var serdata = container.find('input.row_serdata').val();
       if( serdata.length > 0 )
	 {
           // we have serialized data
	   jQuery('#reservation_part_edit').form_populate_serialized(serdata);
         }
       _on_change_rsrc();
       return false;
     });     
     
     newrow.appendTo('#reservation_parts_list');
     newrow.fadeIn();
  }

  function calc_total_price() 
  {
    var totalprice = 0;
    jQuery('#reservation_parts_list').children('.reservation_part').each(function(elem){
      val = jQuery(this).find('input.row_price').val();
      totalprice += parseFloat(val);	
    });
    return totalprice;
  }

  function _update_dates(rsrc_type,start_date,end_date)
  {
    var container = jQuery('#rsrc_period_'+rsrc_type);
    if( rsrc_type == 'd' )
    {
      container.form_set_datetime(strtotime(start_date),'sel_startdate_d_');
      container.form_set_datetime(strtotime(end_date),'sel_enddate_d_');
    }
    else if( rsrc_type == 'h' )
    {
      container.form_set_datetime(strtotime(start_date),'sel_startdate_d_',1);
    }
  }

  function _on_change_rsrc()
  {
    jQuery('#sel_btn_add').hide();
    var tmp = jQuery('#sel_rsrc').val().split(',');
    if( tmp[1] == '-1' )
    { 
      jQuery('#sel_btns').hide();
      jQuery('#sel_row_numpeople').hide();
      jQuery('#sel_rsrc_summary').html('');
    }
    else
    {
      jQuery('#sel_btns').show();
      jQuery('#sel_row_numpeople').show();
    }
    jQuery('.rsrc_period').hide();
    jQuery('#rsrc_period_'+tmp[1]).show();
    jQuery('#sel_message').hide();
    jQuery('#sel_price').hide();

    var obj = new Object();
    obj.rsrc_id = tmp[0];
    var str = $.toJSON(obj);
    $.post(rsrc_url, { data: str },
       function(response){
         if(response.result == 'success' ) {
           jQuery('#sel_rsrc_summary').html(response.summary);
         }
       },
       'json');
  }

  function _update_totals()
  {
    // recalculate totals
    var price = calc_total_price();
    jQuery('#calcprice').html(price);

    var obj = new Object();
    obj.price = price;
    var str = $.toJSON(obj);
    $.post(deposit_url, { data: str },
       function(response){
         if( response.result == 'success' )
	 {
           jQuery('#calcdeposit').html(response.value);
           jQuery('#userdeposit').val(response.value);
         }
       },
       'json');
  }

  function _delete_row(obj)
  {
    obj.remove();

    var idx = 1;
    jQuery('#reservation_parts_list').children('.reservation_part').each(function(elem){
      jQuery(this).find('.row_partnum').html(idx++);
    });
    _update_totals();
  }

  function _check_existing_parts(obj)
  {
    var res = 1;
    jQuery('#reservation_parts_list').children('.reservation_part').each(function(elem){
       var rsrc_id = jQuery(this).find('input.row_rsrc_id').val();
       var start = jQuery(this).find('input.row_startdate').val();
       var end = jQuery(this).find('input.row_enddate').val();

       var ostart = strtotime(obj.start_date);
       var oend = strtotime(obj.end_date);
       if( obj.rsrc_id == rsrc_id )
       {
	 if( ostart == start || oend == end )
         {
           res = 0;
         }
       }
    });
    return res;
  }

  jQuery(document).ready(function() {
    $.ajaxSetup({
      timeout: 2000
    });

    // hide and show various fields based on the resource selected 
    jQuery('#sel_rsrc').change(function() {
      _on_change_rsrc();
    });

    // handle the check button click
    jQuery('#sel_btn_check').click(function() {
      var container = jQuery('#reservation_part_edit');

      // build the json data
      var obj = new Object();
      var val = jQuery('#sel_rsrc').val();
      obj.rsrc_id = val.split(',')[0];
      var rsrc_type = val.split(',')[1];
      if( rsrc_type == 'd' )
        {
          obj.start_date = container.form_get_datetime('sel_startdate_d_');
          obj.end_date = container.form_get_datetime('sel_enddate_d_');
        }
      else if( rsrc_type == 'h' )
        {
          obj.start_date = container.form_get_datetime('sel_startdate_h_',1)
        }
      else if( rsrc_type == 'p' )
        {
          obj.start_date = container.form_get_datetime('sel_startdate_p_')
          obj.meridian = container.find('#sel_meridian_p').val(); 
        }
      obj.num_people = container.find('#sel_numpeople').val();

      var str = $.toJSON(obj);

      // do json request
      var json = $.post(check_url, { data: str },
          function(response){
            jQuery('#sel_int_status').html(response.result);
            jQuery('#sel_int_price').html(response.price);
	    jQuery('#sel_message').html(response.message);

            if( response.result == 'available' )
            {
                obj.start_date = response.start_date;
                obj.end_date = response.end_date;
                res = _check_existing_parts(obj);
                if( !res )
                {
       	           jQuery('#sel_message').html(error_resvn_conflict).show();
                   return false;
                }

	        // got an available period
	        jQuery('#sel_btn_add').show();
                jQuery('#sel_price_amt').html(_format_price(response.price));
                jQuery('#sel_price').show();
                jQuery('#sel_message').show();
                jQuery('#sel_dyn_start_date').val(response.start_date);
                jQuery('#sel_dyn_end_date').val(response.end_date);
 
                // update the dates from what we have
                //_update_dates(rsrc_type,response.start_date,response.end_date);
            }
            else
            {
                jQuery('#sel_price').hide();
                jQuery('#sel_message').show();
                jQuery('#sel_dyn_start_date').val('-1');
                jQuery('#sel_dyn_end_date').val('-1');
            }
          }, 
          'json');

      // no more processing.
      return false;
    });

    // handle the select fields changing.
    jQuery('#reservation_part_edit select').change(function(){
      // select field has changed.
      jQuery('#sel_dyn_start_date').val('-1');
      jQuery('#sel_dyn_end_date').val('-1');
      jQuery('#sel_btn_add').hide();

      // this part automaticall updates the end-date on start-date modification.
      var name = jQuery(this).attr('name');
      var namer = name.replace('startdate','enddate');
      if( name != namer )
	{
          jQuery(":input[name='"+namer+"']").val(jQuery(":input[name='"+name+"']").val());
        }
    });

    // handle the add button.
    jQuery('#sel_btn_add').click(function() {
      // have to add a row to the reservations parts list
      var container = jQuery('#reservation_part_edit');
      var val = jQuery('#sel_rsrc').val();
      var rsrc_id = val.split(',')[0];
      var rsrc_type = val.split(',')[1];
      var rsrc_str = jQuery('#sel_rsrc :selected').text();
      var num_people = jQuery('#sel_numpeople').val();
      var price = jQuery('#sel_int_price').html();
      var start_date = jQuery('#sel_dyn_start_date').val();
      var end_date = jQuery('#sel_dyn_end_date').val();
      var meridian = '';

      if( start_date == '-1' || end_date == '-1' )
      {
	alert('cannot add');
        return false;
      }
      if( rsrc_type == 'p' )
      {
	meridian = jQuery('#sel_meridian').val();
      }

      // add the row
      var serialized = jQuery('#reservation_part_edit').serializeAnything();
      _add_row(rsrc_id,rsrc_type,rsrc_str,start_date,end_date,num_people,meridian,price,serialized);

      // update totals.
      _update_totals();

      // no more processing.
      jQuery('#sel_btn_add').hide();
      return false;
    });

    // handle form submission.
    jQuery('#submit_btn').click(function(){
      // submit button pressed.
      var count = jQuery('#reservation_parts_list').children('.reservation_part').size();
      if( count == 0 )
      {
        alert(error_no_resvn_parts);
        return false;
      }
    });

    // handle row deletion.
    jQuery('#reservation_parts_list').find('.row_delete').click(function(){
      var container = jQuery(this).parents('.reservation_part');
      _delete_row(container);
      return false;
    });

    // handle row edit.
    jQuery('#reservation_parts_list').find('.row_edit').click(function(){
       var container = jQuery(this).parents('.reservation_part');
       var serdata = container.find('input.row_serdata').val();
       if( serdata.length > 0 )
	 {
           // we have serialized data
	   jQuery('#reservation_part_edit').form_populate_serialized(serdata);
         }
       _on_change_rsrc();
       return false;
    });

    //now handle the latest stuff
    _on_change_rsrc();
  });
