{* reservation confirmation template *}
<h3>{$mod->Lang('reservation_created')}</h3>
<p>Thank you {$userinfo->properties.full_name->value} <em>({$userinfo->email})</em>.  Your reservation (id {"%06d"|sprintf:$reservation.id}) has been created.</p>

<h4>{$mod->Lang('reservation_details')}:</h4>
<table>
  <tr>
    <td>{$Availability->Lang('your_name')}:</td>
    <td>{$userinfo->properties.full_name->value}</td>
  </tr>
  <tr>
    <td>{$Availability->Lang('price')}:</td>
    <td>{cgecomm_currency_symbol}{$reservation.price|number_format:2}</td>
  </tr>
  <tr>
    <td>{$Availability->Lang('created')}:</td>
    <td>{$reservation.create_date|cms_date_format}</td>
  </tr>
</table>

{if isset($reservation.parts) && count($reservation.parts)}
<br/>
<h4>{$mod->GetResourcetype(1)}:</h4>
<table>
  <thead>
   <tr>
     <th>{$Availability->GetResourceType()}</th>
     <th>{$Availability->Lang('date')}</th>
     <th align="right">{$Availability->Lang('num_people')}</th>
     <th align="right">{$Availability->Lang('price')}</th>
   </tr>
  </thead>
  <tbody>
  {foreach from=$reservation.parts item='onepart'}
    <tr>
      <td>{$reservation.resource[$onepart.rsrc_id].name}</td>
      <td>{$onepart.start_date|cms_date_format}</td>
      <td align="right">{$onepart.num_people}</td>
      <td align="right">{cgecomm_currency_symbol}{$onepart.price|number_format:2}</td>
    </tr>
  {/foreach}
  </tbody>
</table>
<br/>
{/if}

{if isset($reservation.extra) && $reservation.extra|@count gt 0}
<h4>{$Availability->Lang('lbl_extra_purchases')}:</h4>
<table>
  <thead>
    <tr>
      <th width="59%">{$Availability->Lang('name')}</th>
      <th width="10%">{$Availability->Lang('source')}</th>
      <th width="10%">{$Availability->Lang('sku')}</th>
      <th width="10%">{$Availability->Lang('quantity')}</th>
      <th width="10%">{$Availability->Lang('price')}</th>
    </tr>
  </thead>
  <tbody>
  {foreach from=$reservation.extra item='one'}
    <tr>
       <td>{$one.desc}</td>
       <td>{$one.source}/{$one.itemid}</td>
       <td>{$one.sku}</td>
       <td>{$one.qty}</td>
       <td>{cgecomm_currency_symbol}{$one.itemamt|number_format:2}</td>
    </tr>
  {/foreach}
  </tbody>
</table>
<br/>
{/if}


<h4>{$mod->Lang('notes')}:</h4>
{foreach from=$reservation.notes item='onenote'}
{if !$onenote.admin_note}
  {* only display user notes here *}
  <div class="row" style="margin-bottom: 0.5em;">
    <div style="width: 50%; float: left;">{$mod->Lang('subject')}:&nbsp;{$onenote.subject}</div>
    <div style="width: 49%; float: left;">{$mod->Lang('created')}:&nbsp;{$onenote.create_date|cms_date_format}</div>
    <p>{$onenote.text}</p>
  </div>
{/if}
{/foreach}
<br/>
<p>An email has been sent to the address specified above with the details of your reservation, and instructions as to how to arrange payment.</p>
