{* reservation confirmation email *}
<html>
<body>

<h3>{$Availability->Lang('reservation_created')}</h3>
<p>Thank you {$userinfo->properties.full_name->value} <em>({$userinfo->email})</em>.  For submitting a reservation with {sitename}</p> reservation (id {"%06d"|sprintf:$reservation.id}) has been created.</p>

<h4>{$Availability->Lang('reservation_details')}:</h4>
<div style="margin-bottom: 1em;">
<div style="width: 80%; margin-left: 3em;">
  <div style="width: 30%; float: left;">{$Availability->Lang('reservation_id')}</div>
  <div style="width: 69%;">{$reservation.id}</div>
</div>

<div style="margin-bottom: 1em;">
<div style="width: 80%; margin-left: 3em;">
  <div style="width: 30%; float: left;">{$Availability->Lang('status')}</div>
  <div style="width: 69%;">{$Availability->Lang($reservation.status)}</div>
</div>

<div style="margin-bottom: 1em;">
<div style="width: 80%; margin-left: 3em;">
  <div style="width: 30%; float: left;">{$Availability->Lang('your_name')}</div>
  <div style="width: 69%;">{$userinfo->properties.full_name->value}</div>
</div>

<div style="width: 80%; margin-left: 3em;">
  <div style="width: 30%; float: left;">{$Availability->Lang('price')}</div>
  <div style="width: 69%;">${$reservation.price|number_format:2}</div>
</div>

<div style="width: 80%; margin-left: 3em;">
  <div style="width: 30%; float: left;">{$Availability->Lang('created')}</div>
  <div style="width: 69%;">{$reservation.create_date|cms_date_format}</div>
</div>
</div>

{if isset($reservation.parts) && count($reservation.parts)}
<h4>{$Availability->GetResourcetype(1)}:</h4>
<table>
 <thead>
   <tr>
     <th width="59%" align="left">{$Availability->GetResourceType()}</th>
     <th width="10%" align="right">{$Availability->Lang('start_date')}</th>
     <th width="10%" align="right">{$Availability->Lang('end_date')}</th>
     <th width="10%" align="right">{$Availability->Lang('num_people')}</th>
     <th width="10%" align="right">{$Availability->Lang('price')}</th>
   </tr>
 </thead>
 <tbody>
 {foreach from=$reservation.parts item='onepart'}
   <tr>
    <td align="left">{$reservation.resources[$onepart.rsrc_id].name}</td>
    <td align="right">{$onepart.start_date|cms_date_format}</td>
    <td align="right">{$onepart.end_date|cms_date_format}</td>
    <td align="right">{$onepart.num_people}</td>
    <td align="right">${$onepart.price|number_format:2}</td>
   </tr>
 {/foreach}
 </tbody>
</table>
<br/>
{/if}

{if isset($reservation.extra) && $reservation.extra|@count gt 0}
<h4>{$Availability->Lang('lbl_extra_purchases')}:</h4>
<table>
  <thead>
    <tr>
      <th width="59%">{$Availability->Lang('name')}</th>
      <th width="10%">{$Availability->Lang('source')}</th>
      <th width="10%">{$Availability->Lang('sku')}</th>
      <th width="10%">{$Availability->Lang('quantity')}</th>
      <th width="10%">{$Availability->Lang('price')}</th>
    </tr>
  </thead>
  <tbody>
  {foreach from=$reservation.extra item='one'}
    <tr>
       <td>{$one.desc}</td>
       <td>{$one.source}/{$one.itemid}</td>
       <td>{$one.sku}</td>
       <td>{$one.qty}</td>
       <td>{cgecomm_currency_symbol}{$one.itemamt|number_format:2}</td>
    </tr>
  {/foreach}
  </tbody>
</table>
{/if}

<br/>
<h4>{$Availability->Lang('notes')}:</h4>
{foreach from=$notes item='onenote'}
  <div style="width: 80%; margin-left: 3em; margin-bottom: 0.5em;">
    <div style="width: 50%; float: left;">{$Availability->Lang('subject')}:&nbsp;{$onenote.subject}</div>
    <div style="width: 49%; float: left;">{$Availability->Lang('created')}:&nbsp;{$onenote.create_date|cms_date_format}</div>
    <p>{$onenote.text}</p>
  </div>
{/foreach}

<p>If there are errors in your reservation, you can edit it by clicking <a href="{$edit_url}">here</a>. This link will work until the date of the reservation.</p>
<p>If you would like to contact the business to further discuss your reservation, please click <a href="{$email_url}">here</a>.</p>
</body>
</html>