{literal}
<script type="text/javascript">
function toggleDisplay(elem)
{
  var el = document.getElementById(elem);
  var txt = el.style.display;
  if( txt == 'none' )
    {
      txt = 'block';
    }
  else
    {
      txt = 'none';
    }
  el.style.display = txt;
}
</script>
{/literal}

<h3>{$mod->Lang('manage_customer_contact_resvn')}: {$resv_id}</h3>

{if isset($resvn)}
<fieldset>
  <legend>{$mod->Lang('reservation_details')}</legend>
  <div class="pageoverflow">
    <p class="pagetext">{$mod->Lang('customer')}:</p>
    <p class="pageinput">{$userinfo.display} ({$userinfo.email})</p>
  </div>
  <div class="pageoverflow">
    <p class="pagetext">{$mod->GetResourceType(1)}:</p>
    <p class="pageinput">{', '|implode:$resvn.rsrcs}</p>
  </div>
  <div class="pageoverflow">
    <p class="pagetext">{$mod->Lang('checkin')}:</p>
    <p class="pageinput">{$resvn.start_date|cms_date_format}</p>
  </div>
  <div class="pageoverflow">
    <p class="pagetext">{$mod->Lang('checkout')}:</p>
    <p class="pageinput">{$resvn.end_date|cms_date_format}</p>
  </div>
  <div class="pageoverflow">
    <p class="pagetext">{$mod->Lang('created')}:</p>
    <p class="pageinput">{$resvn.create_date|cms_date_format}</p>
  </div>
  <div class="pageoverflow">
    <p class="pagetext">{$mod->Lang('last_modified')}:</p>
    <p class="pageinput">{$resvn.modified_date|cms_date_format}</p>
  </div>
  <div class="pageoverflow">
    <p class="pagetext">{$mod->Lang('price')}:</p>
    <p class="pageinput">{$mod->GetPreference('currency_symbol')}{$resvn.price|number_format:2}</p>
  </div>
</fieldset>
{/if}

{if isset($notes)}
<fieldset>
<legend>{$mod->Lang('past_messages')}</legend>
{foreach from=$notes item='one'}
  <div class="pageoverflow pagetable">
    <p><strong>{$mod->Lang('subject')}:</strong>&nbsp;{$one.subject}&nbsp;<a onclick="toggleDisplay('note{$one.id}');">+</a></p>
    <p style="margin-left: 3em;"><strong>{$mod->Lang('sent')}:</strong>&nbsp;{$one.create_date|cms_date_format}</p>
    <div id="note{$one.id}" style="margin-left: 3em; display: none;">
        {$one.text}
    </div>
  </div> 
{/foreach}
</fieldset>
{/if}

{$formstart}
<fieldset>
<legend>{$mod->Lang('send_email')}:&nbsp;</legend>
<div class="pageoverflow">
  <p class="pagetext">{$mod->Lang('message_template')}</p>
  <p class="pageinput">{$input_template}</p>
</div>
<div class="pageoverflow">
  <p class="pagetext">{$mod->Lang('subject')}</p>
  <p class="pageinput">
     <input type="text" name="{$actionid}input_subject" size="80" maxlength="255" value="{$mod->Lang('subj_re_resvn',$resvn_id)}" />
  </p>
</div>
<div class="pageoverflow">
  <p class="pagetext">{$mod->Lang('message_text')}</p>
  <p class="pageinput">{$input_body}</p>
  </p>
</div>
<div class="pageoverflow">
  <p class="pagetext">{$mod->Lang('attachment')}</p>
  <p class="pageinput">{$input_file}</p>
  </p>
</div>
<div class="pageoverflow">
  <p class="pagetext">&nbsp;</p>
  <p class="pageinput">
    <input type="submit" name="{$actionid}submit" value="{$mod->Lang('send')}" />
    <input type="submit" name="{$actionid}cancel" value="{$mod->Lang('cancel')}" />
</div>
{$formend}