{$formstart}
<fieldset>
  <legend>{$mod->Lang('filter')}:</legend>
  <div class="pageoverflow">
    <p class="pagetext">{$mod->Lang('use_dates_in_filter')}:</p>
    <p class="pageinput">{$input_use_dates}</p>
  </div>
  <div class="pageoverflow">
    {capture assign='tmp'}{$actionid}input_startdate_{/capture}
    <p class="pagetext">{$mod->Lang('start_date')}:</p>
    <p class="pageinput">{html_select_date prefix=$tmp start_year=-20 end_year=+20 time=$input_startdate}</p>
  </div>
  <div class="pageoverflow">
    {capture assign='tmp'}{$actionid}input_enddate_{/capture}
    <p class="pagetext">{$mod->Lang('end_date')}:</p>
    <p class="pageinput">{html_select_date prefix=$tmp end_year=-20 end_year=+20 time=$input_enddate}</p>
  </div>
  <div class="pageoverflow">
    <p class="pagetext">{$mod->Lang('event_type')}:</p>
    <p class="pageinput">{$input_type}</p>
  </div>
  <div class="pageoverflow">
    <p class="pagetext">{$mod->Lang('bookable_br')}:</p>
    <p class="pageinput">{$input_bookable}</p>
  </div>
  <div class="pageoverflow">
    <p class="pagetext">{$mod->Lang('page_limit')}:</p>
    <p class="pageinput">{$input_pagelimit}</p>
  </div>
  <div class="pageoverflow">
    <p class="pagetext">&nbsp;</p>
    <p class="pageinput">{$btnfilter}</p>
  </div>
</fieldset>
<br/>
{$formend}

{if isset($events)}
  {if $pagecount > 1}
  <p class="pageoverflow">
    {if $curpage_ev > 1}
      {module_action_link module='Availability' action='defaultadmin' curpage_ev=1 text=$mod->Lang('firstpage') cg_activetab='events'}&nbsp;
      {module_action_link module='Availability' action='defaultadmin' curpage_ev=$prevpage text=$mod->Lang('prevpage') cg_activetab='events'}&nbsp;
    {/if}
    {$mod->Lang('page')} {$curpage_ev} {$mod->Lang('of')} {$pagecount}&nbsp;
    {if $curpage_ev < $pagecount}
      {module_action_link module='Availability' action='defaultadmin' curpage_ev=$nextpage text=$mod->Lang('nextpage') cg_activetab='events'}&nbsp;
      {module_action_link module='Availability' action='defaultadmin' curpage_ev=$pagecount text=$mod->Lang('lastpage') cg_activetab='events'}&nbsp;
    {/if}
  </p>
  {/if}
  <table class="pagetable" cellspacing="0">
    <thead> 
      <tr>
        <th>{$mod->Lang('name')}</th>
        <th>{$mod->Lang('type')}</th>
	<th>{$mod->Lang('start_date')}</th>
	<th>{$mod->Lang('end_date')}</th>
        <th>{$mod->Lang('bookable_br')}</th>
        <th>{$mod->Lang('description')}</th>
        <th class="pageicon">&nbsp;</th>
        <th class="pageicon">&nbsp;</th>
      </tr>
    </thead>
    <tbody>
    {foreach from=$events item='oneevent'}
      {cycle values="row1,row2" assign='rowclass'}
      <tr class="{$rowclass}" onmouseover="this.className='{$rowclass}hover';" onmouseout="this.className='{$rowclass}';">
        <td>{module_action_link module='Availability' action='admin_edit_event' eventid=$oneevent.id text=$oneevent.name title=$mod->Lang('edit_event')}</td>
        <td>{$mod->GetEventTypeFromID($oneevent.event_type_id)}</td>
    	<td>{$oneevent.start_date|cms_date_format}</td>
    	<td>{$oneevent.end_date|cms_date_format}</td>
        <td>{if $oneevent.bookable}{$mod->Lang('yes')}{else}&nbsp;{/if}</td>
	<td>{$oneevent.description|strip_tags|summarize:20}</td>
        <td>{module_action_link module='Availability' action='admin_edit_event' image='icons/system/edit.gif' imageonly=1 eventid=$oneevent.id text=$mod->Lang('edit_event')}</td>
        <td>{module_action_link module='Availability' action='admin_delete_event' image='icons/system/delete.gif' imageonly=1 eventid=$oneevent.id text=$mod->Lang('delete_event') confmessage=$mod->Lang('ask_deleteevent')}</td>
      </tr>
    {/foreach}
    </tbody>
  </table>
{/if}

<p class="pageoverflow">
{if $mod->HaveEventTypes() && $mod->HaveResources()}
  {module_action_link module='Availability' action='admin_edit_event' text=$mod->Lang('add_event') image='icons/system/newobject.gif'}
{else}
  {if !$mod->HaveEventTypes()}
    {$mod->ShowErrors($mod->Lang('error_no_event_types'))}
  {elseif !$mod->HaveResources()}
    {capture assign='tmp'}{$mod->Lang('error_no_resources',$mod->GetResourceType(1))}{/capture}
    {$mod->ShowErrors($tmp)}
  {/if}
{/if}
</p>