{literal}
<script type="text/javascript">
function view_user()
{
  var bare_url = "{/literal}{module_action_link module=FrontEndUsers action=viewuser uid=changeme page=$default_content_id urlonly=1}{literal}";
  var el   = document.getElementById('input_customer_id');
  var idx  = el.selectedIndex;
  var val  = el[idx].value;
  var tmp  = bare_url.replace('changeme',val) + '&showtemplate=false';
  var url  = tmp.replace(/amp;/g,'');

  el = document.getElementById('userinfo');
  // do jquery ajax stuff
  jQuery('#userinfo').load(url);
  // and display the element (be nice if we could animate this)
  el.style.display = 'block';
}
</script>
{/literal}

{literal}
<script type="text/javascript">
  var check_url = "{/literal}{module_action_link module=Availability action=json_check_avail urlonly=1}{literal}";
  check_url = check_url.replace(/amp;/g,'')+'&showtemplate=false';
  var rsrc_url = "{/literal}{module_action_link module=Availability action=json_rsrc_info urlonly=1}{literal}";
  rsrc_url = rsrc_url.replace(/amp;/g,'')+'&showtemplate=false';
  var actionid = '{/literal}{$actionid}{literal}';
  var currency_symbol = '{/literal}{$mod->GetPreference('currency_symbol','$')}{literal}';
  var date_format = '{/literal}{$date_format}{literal}';

  jQuery.extend({
      postJSON: function( url, data, callback ) {
           return jQuery.post(url, data, callback, "json");
      }
  });

  function _format_price(val)
  {
    str = currency_symbol + val;
    return str;
  }

  function add_row(rsrc_id,rsrc_type,rsrc_str,start_date,end_date,num_people,meridian,price,serialized)
  {
     // get the number of children of class reservation_part
     var idx = 0;
     jQuery('#reservation_parts_list').children('.reservation_part').each(function(elem){
       var tmp = jQuery(this).find('.row_partnum').html();
       if( tmp > idx ) idx = tmp;
     });
     idx++;

     newrow = jQuery('#reservation_part_template').clone(true);
     newrow.attr('id','reservation_part_'+idx);
     newrow.find('input').each(function() {
       var name = jQuery(this).attr('name');
       name = name.replace('XX',idx);
       name = name.replace('YY','part');
       jQuery(this).attr('name',name);
     });

     newrow.find('input.row_rsrc_id').attr('value',rsrc_id);
     newrow.find('input.row_serdata').attr('value',serialized);
     newrow.find('input.row_meridian').attr('value',meridian);
     newrow.find('input.row_startdate').attr('value',strtotime(start_date));
     newrow.find('input.row_enddate').attr('value',strtotime(end_date));
     newrow.find('input.row_numpeople').attr('value',num_people);
     newrow.find('input.row_price').attr('value',price);

     newrow.find('.row_start_date').html(strftime(date_format,start_date));
     newrow.find('.row_end_date').html(strftime(date_format,end_date));
     newrow.find('.row_partnum').html(idx);
     newrow.find('.row_resource').html(rsrc_str);
     newrow.find('.row_num_people').html(num_people);
     newrow.find('.row_show_price').html(price);

     newrow.find('.row_delete').click(function(){
       // handle the delete button on reservation parts.
       var container = jQuery(this).parents('.reservation_part');
       _delete_row(container);
       return false;
     });

     newrow.find('.row_edit').click(function(){
       // handle the edit button on reservation parts.
       var container = jQuery(this).parents('.reservation_part');
       _on_row_edit(container);
       _delete_row(container);
     });     
     
     newrow.appendTo('#reservation_parts_list');
     newrow.fadeIn();
  }


  function _calc_total_price() 
  {
    var totalprice = 0;
    jQuery('#reservation_parts_list').children('.reservation_part').each(function(elem){
      val = jQuery(this).find('input.row_price').val();
      totalprice += parseFloat(val);	
    });
    return totalprice;
  }


  function _update_dates(rsrc_type,start_date,end_date)
  {
    var container = jQuery('#rsrc_period_'+rsrc_type);
    if( rsrc_type == 'd' )
    {
      container.form_set_datetime(strtotime(start_date),'sel_startdate_d_');
      container.form_set_datetime(strtotime(end_date),'sel_enddate_d_');
    }
    else if( rsrc_type == 'h' )
    {
      container.form_set_datetime(strtotime(start_date),'sel_startdate_d_',1);
    }
  }


  function _on_row_edit(container)
  {
    var serdata = container.find('input.row_serdata').val();
    if( serdata.length > 0 )
    {
      // we have serialized data
      jQuery('#reservation_part_edit').form_populate_serialized(serdata);
    }
    else
    { 
      // get the curren rsrc id.
      var rsrc_id = container.find('.row_rsrc_id').val();
      var start_date = container.find('.row_startdate').val();
      var meridian = container.find('.row_meridian').val();
      var end_date = container.find('.row_enddate').val();
      var num_people = container.find('.row_numpeople').val();
      var price = container.find('.row_price').val();

      // get the selected resource type (d,p, or h)
      var type = '';
      jQuery('#sel_rsrc').children('option').each(function(){
        var tmp = $(this).val().split(',');
        if( tmp[0] == rsrc_id )
        {
          type = tmp[1];
        }
      });

      // now repopulate things
      jQuery('#sel_rsrc').val(rsrc_id+","+type);
      jQuery('#sel_numpeople').val(num_people);
      jQuery('#sel_int_price').html(_format_price(price));
      if( type == 'd' )
      {
	jQuery('#reservation_part_edit').form_set_datetime(start_date,'sel_startdate_d_');
	jQuery('#reservation_part_edit').form_set_datetime(end_date,'sel_enddate_d_');
      }
      else if( type == 'p' )
      {
        jQuery('#reservation_part_edit').form_set_datetime(start_date,'sel_startdate_p_');
        jQuery('#sel_meridian_p').val(meridian);
      }
      else if( type == 'h' )
      {
	jQuery('#reservation_part_edit').form_set_datetime(start_date,'sel_startdate_h_',1);
      }
    }
    _on_change_rsrc();
  }


  function _on_change_rsrc()
  {
    jQuery('#sel_btn_add').hide();
    var tmp = jQuery('#sel_rsrc').val().split(',');
    if( tmp[1] == '-1' )
    { 
      jQuery('#sel_btns').hide();
      jQuery('#sel_row_numpeople').hide();
    }
    else
    {
      jQuery('#sel_btns').show();
      jQuery('#sel_row_numpeople').show();
    }
    jQuery('.rsrc_period').hide();
    jQuery('#rsrc_period_'+tmp[1]).show();
    jQuery('#sel_message').hide();
    jQuery('#sel_price').hide();

    var obj = new Object();
    obj.rsrc_id = tmp[0];
    var str = $.toJSON(obj);
    var res = $.post(rsrc_url, { data: str },
       function(response){
         if(response.result == 'success' ) {
           jQuery('#sel_rsrc_summary').show();
           jQuery('#sel_rsrc_summary').html(response.summary);
         }
       },
       'json');
  }


  function _delete_row(obj)
  {
    obj.remove();

    var idx = 1;
    jQuery('#reservation_parts_list').children('.reservation_part').each(function(elem){
      jQuery(this).find('.row_partnum').html(idx++);
    });

    // recalculate totals
    jQuery('#calcprice').html(_calc_total_price());
  }


  function _check_existing_parts(obj)
  {
    var res = 1;
    jQuery('#reservation_parts_list').children('.reservation_part').each(function(elem){
       var rsrc_id = jQuery(this).find('input.row_rsrc_id').val();
       var start = jQuery(this).find('input.row_startdate').val();
       var end = jQuery(this).find('input.row_enddate').val();

       var ostart = strtotime(obj.start_date);
       var oend = strtotime(obj.end_date);
       if( obj.rsrc_id == rsrc_id )
       {
	 if( ostart == start || oend == end )
         {
           res = 0;
         }
       }
    });

    return res;
  }


  jQuery(document).ready(function() {
    {/literal}{if isset($reservation_history)}
    jQuery('#view_history').fancybox();
    {/if}{literal}

    $.ajaxSetup({
      timeout: 2000
    });

    // calculate a meridian from the start date... just incase.
    jQuery('#reservation_parts_list').children('.reservation_part').each(function(){
      var str = $(this).find('.row_startdate').val();
      var date = new Date(str);
      var meridian = 'am';
      var hrs = date.getHours();
      if( hrs > 11 )
        {
          meridian = 'pm';
        }
      $(this).find('.row_meridian').val(meridian);
    });

    // hide and show various fields based on the resource selected 
    jQuery('#sel_rsrc').change(function() {
      _on_change_rsrc();
    });

    // handle the check button click
    jQuery('#sel_btn_check').click(function() {
      var container = jQuery('#reservation_part_edit');

      // build the json data
      var obj = new Object();
      var val = jQuery('#sel_rsrc').val();
      obj.rsrc_id = val.split(',')[0];
      var rsrc_type = val.split(',')[1];
      if( rsrc_type == 'd' )
        {
          obj.start_date = container.form_get_datetime('sel_startdate_d_');
          obj.end_date = container.form_get_datetime('sel_enddate_d_');
        }
      else if( rsrc_type == 'h' )
        {
          obj.start_date = container.form_get_datetime('sel_startdate_h_',1)
        }
      else if( rsrc_type == 'p' )
        {
          obj.start_date = container.form_get_datetime('sel_startdate_p_')
          obj.meridian = container.find('#sel_meridian_p').val(); 
        }
      obj.num_people = container.find('#sel_numpeople').val();

      if( rsrc_type == 'd' )
	{
          var res = _check_existing_parts(obj);
          if( !res )
          {
            var msg = '{/literal}{$mod->Lang('error_reservation_conflict')}{literal}';
  	    jQuery('#sel_message').html(msg).show();
  	    return false;
          }
        }

      var str = $.toJSON(obj);

      // do json request
      var json = $.post(check_url, { data: str },
          function(response){
            jQuery('#sel_int_status').html(response.result);
            jQuery('#sel_int_price').html(response.price);
	    jQuery('#sel_message').html(response.message);

            if( response.result == 'available' )
            {
                if( rsrc_type != 'd' )
	          {
                    obj.end_date = response.end_date;
                    res = _check_existing_parts(obj);
                    if( !res )
		      {
                        var msg = '{/literal}{$mod->Lang('error_reservation_conflict')}{literal}';
       	                jQuery('#sel_message').html(msg).show();
           	        return false;
                      }
                  }

	        // got an available period
	        jQuery('#sel_btn_add').show();
                jQuery('#sel_price_amt').html(_format_price(response.price));
                jQuery('#sel_price').show();
                jQuery('#sel_message').show();
                jQuery('#sel_dyn_start_date').val(response.start_date);
                jQuery('#sel_dyn_end_date').val(response.end_date);
 
                // update the dates from what we have
                _update_dates(rsrc_type,response.start_date,response.end_date);
            }
            else
            {
                jQuery('#sel_price').hide();
                jQuery('#sel_message').show();
                jQuery('#sel_dyn_start_date').val('-1');
                jQuery('#sel_dyn_end_date').val('-1');
            }
          }, 
          'json');

      // no more processing.
      return false;
    });

    // handle the select fields changing.
    jQuery('#reservation_part_edit select').change(function(){
      // select field has changed.
      jQuery('#sel_dyn_start_date').val('-1');
      jQuery('#sel_dyn_end_date').val('-1');
      jQuery('#sel_btn_add').hide();

      // this part automaticall updates the end-date on start-date modification.
      var name = jQuery(this).attr('name');
      var namer = name.replace('startdate','enddate');
      if( name != namer )
	{
          jQuery(":input[name='"+namer+"']").val(jQuery(":input[name='"+name+"']").val());
        }
    });

    // handle the add button.
    jQuery('#sel_btn_add').click(function() {
      // have to add a row to the reservations parts list
      var container = jQuery('#reservation_part_edit');
      var val = jQuery('#sel_rsrc').val();
      var rsrc_id = val.split(',')[0];
      var rsrc_type = val.split(',')[1];
      var rsrc_str = jQuery('#sel_rsrc :selected').text();
      var num_people = jQuery('#sel_numpeople').val();
      var price = jQuery('#sel_int_price').html();
      var start_date = jQuery('#sel_dyn_start_date').val();
      var end_date = jQuery('#sel_dyn_end_date').val();
      var meridian = '';

      if( start_date == '-1' || end_date == '-1' )
      {
	alert('cannot add');
        return false;
      }

      if( rsrc_type == 'p' )
      {
	meridian = jQuery('#sel_meridian').val();
      }

      // add the row
      var serialized = jQuery('#reservation_part_edit').serializeAnything();
      add_row(rsrc_id,rsrc_type,rsrc_str,start_date,end_date,num_people,meridian,price,serialized);

      // update totals.
      var total_price = _calc_total_price();
      jQuery('#calcprice').html(total_price);

      // no more processing.
      jQuery('#sel_btn_add').hide();
      return false;
    });

    // handle form submission.
    jQuery('#submit_btn').click(function(){
      // submit button pressed.
      var count = jQuery('#reservation_parts_list').children('.reservation_part').size();
      if( count == 0 )
      {
        alert('{/literal}{$mod->Lang('error_no_reservation_parts')}{literal}');
        return false;
      }
    });

    // handle row deletion.
    jQuery('#reservation_parts_list').find('.row_delete').click(function(){
      var container = jQuery(this).parents('.reservation_part');
      _delete_row(container);
      return false;
    });

    // handle row edit.
    jQuery('#reservation_parts_list').find('.row_edit').click(function(){
       var container = jQuery(this).parents('.reservation_part');
       _on_row_edit(container);
       _delete_row(container);
       return false;
    });

    // handle extra delete
    $('img.extra_delete').click(function(){
       $(this).closest('tr').remove();
    });
    // and setup
    _on_change_rsrc();
  });
</script>
{/literal}


{if isset($actionparams.resvnid)}
<h3>{$mod->Lang('edit_reservation')}</h3>
{else}
<h3>{$mod->Lang('add_reservation')}</h3>
{/if}

{$formstart}
<div class="pageoverflow">
  <p class="pagetext">{$mod->Lang('customer_name')}:</p>
  <p class="pageinput">
  {$input_customer_id}&nbsp;
  <a href="javascript:view_user();" title="{$mod->Lang('info_view_user')}">{cgimage image="icons/system/view.gif" alt=$mod->Lang('view_user')}</a>&nbsp;
  {module_action_link module='FrontEndUsers' action='adduser' urlonly=1 memberof=$memberof returnto='Availability,admin_edit_resvn' assign='url'}<a href="{$url}" title="{$mod->Lang('info_add_user_account')}">{cgimage image="icons/system/newobject.gif" alt=""}&nbsp;{$mod->Lang('add_user_account')}</a></p>
</div>
<div class="pagetext" id="userinfo" style="border: 1px dashed red; width: 40%; display: none; font-weight: normal;">
</div>

{if isset($actionparams.resvnid)}
<div class="pageoverflow">
  <p class="pagetext">{$mod->Lang('create_date')}</p>
  <p class="pageinput">{$data.create_date|cms_date_format}</p>
</di9>
{/if}

<div class="pageoverflow">
  <p class="pagetext">{$mod->Lang('price')}:</p>
  <p class="pageinput">
    {$mod->GetPreference('currency_symbol','$')}<input type="text" name="{$actionid}input_price" id="price" value="{$data.price}" size="10" maxlength="10">
    &nbsp;&nbsp;{$mod->Lang('calculated_price')}:&nbsp;{$mod->GetPreference('currency_symbol','$')}&nbsp;<span id="calcprice">{$mod->Lang('not_calculated')}</span>
  </p>
</div>

<div id="reservation_part_template" class="reservation_part" style="display: none; clear: left;">
 <p class="row_partnum" style="float: left; margin-right: 0.5em; width: 2em;"></p>
 <p style="float: left;">
   <input type="hidden" class="row_rsrc_id" name="{$actionid}YY_selrsrc_XX" value="-1"/>
   <input type="hidden" class="row_serdata" name="{$actionid}YY_serdata_XX" value="-1"/>
   <input type="hidden" class="row_startdate" name="{$actionid}YY_startdate_XX" value="-1"/>
   <input type="hidden" class="row_meridian" name="{$actionid}YY_startdate_XXmeridian" value="-1"/>
   <input type="hidden" class="row_enddate" name="{$actionid}YY_enddate_XX" value="-1"/>
   <input type="hidden" class="row_numpeople" name="{$actionid}YY_numpeople_XX" value="-1"/>
   <input type="hidden" class="row_price" name="{$actionid}YY_price_XX" value="-1"/>
   <span class="row_resource"></span><br/>
   {$mod->Lang('from')}:&nbsp;<span class="row_start_date"></span>&nbsp;
   {$mod->Lang('to')}:&nbsp;<span class="row_end_date"></span><br/>
   {$mod->Lang('num_people')}:&nbsp;<span class="row_num_people"></span><br/>
   {$mod->Lang('price')}:&nbsp;{$mod->GetPreference('currency_symbol','$')}<span class="row_show_price"></span><br/>
   <span class="actions">
     {cgimage class="row_delete" image='icons/system/delete.gif' alt=$mod->Lang('delete')}&nbsp;
     {cgimage class="row_edit" image='icons/system/edit.gif' alt=$mod->Lang('edit')}
   </span>
 </p>
</div>

<div class="pagetext">
<fieldset>
<legend>{$mod->Lang('reservation_parts')}:&nbsp;</legend>
{* the area where the completed reservation parts are going to go *}
<div id="reservation_parts_list" style="width: 39%; float: left;">
{foreach from=$data.parts item='part' name='part'}
 {assign var='idx' value=$smarty.foreach.part.iteration}
 {assign var='rsrc_id' value=$part.ext_rsrcid}
 <div id="reservation_part_{$smarty.foreach.part.iteration}" class="reservation_part" style="clear: left;">
   <p class="row_partnum" style="float: left; margin-right: 0.5em; width: 2em;">{$idx}</p>
   <p style="float: left;">
     <input type="hidden" class="row_rsrc_id" name="{$actionid}part_selrsrc_{$idx}" value="{$part.rsrc_id}"/>
     <input type="hidden" class="row_serdata" name="{$actionid}part_seldata_{$idx}" value=""/>
     <input type="hidden" class="row_startdate" name="{$actionid}part_startdate_{$idx}" value="{$part.start_date|strtotime}"/>
     <input type="hidden" class="row_meridian" name="{$actionid}part_startdate_{$idx}meridian" value="-1"/>
     <input type="hidden" class="row_enddate" name="{$actionid}part_enddate_{$idx}" value="{$part.end_date|strtotime}"/>
     <input type="hidden" class="row_numpeople" name="{$actionid}part_numpeople_{$idx}" value="{$part.num_people}"/>
     <input type="hidden" class="row_price" name="{$actionid}part_price_{$idx}" value="{$part.price}"/>
     <span class="row_resource">{$rsrc_list.$rsrc_id}</span><br/>
     {$mod->Lang('from')}:&nbsp;<span class="row_start_date">{$part.start_date|cms_date_format}</span>&nbsp;
     {$mod->Lang('to')}:&nbsp;<span class="row_end_date">{$part.end_date|cms_date_format}</span><br/>
     {$mod->Lang('num_people')}:&nbsp;<span class="row_num_people">{$part.num_people}</span><br/>
     {$mod->Lang('price')}:&nbsp;{$mod->GetPreference('currency_symbol','$')}<span class="row_price">{$part.price}</span><br/>  
     <span class="actions">
       {cgimage class="row_delete" image='icons/system/delete.gif' alt=$mod->Lang('delete')}&nbsp;
       {cgimage class="row_edit" image='icons/system/edit.gif' alt=$mod->Lang('edit')}
     </span>
   </p>
  </div>
  
{/foreach}
</div>

{* the area where we will edit a reservation part *}
<div id="reservation_part_edit" style="width: 59%; float: right; padding-left: 0.5em; border-left: 1px solid;">
 <input type="hidden" id="sel_dyn_start_date" value="-1"/>
 <input type="hidden" id="sel_dyn_end_date" value="-1"/>
 <div>
   <p style="float: left; width: 30%;">{$mod->GetResourceType()}:</p>
   <p style="float: right; width: 69%;">
     <select id="sel_rsrc" name="sel_rsrc">
     {html_options options=$rsrc_list}
     </select>
   </p>
   <p id="sel_rsrc_summary" style="margin-left: 1em;"></p>
 </div>

 <div id="rsrc_period_d" class="rsrc_period" style="clear: right; display: none;">
   <p style="float: left; width: 30%;">{$mod->Lang('start_date')}:</p>
   <p style="float: right; width: 69%;">
     {html_select_date prefix="sel_startdate_d_" start_year=$admin_startyear end_year="+2"}
   </p>
   <p style="float: left; width: 30%;">{$mod->Lang('end_date')}:</p>
   <p style="float: right; width: 69%;">
     {html_select_date prefix="sel_enddate_d_" start_year=$admin_startyear end_year="+2"}
   </p>
 </div>

 <div id="rsrc_period_p" class="rsrc_period" style="clear: right; display: none;">
   <p style="float: left; width: 30%;">{$mod->Lang('start_date')}:</p>
   <p style="float: right; width: 69%;">
     {html_select_date prefix="sel_startdate_p_" end_year="+2"}
     &nbsp;{$mod->Lang('at')}&nbsp;
     <select id='sel_meridian_p' name='sel_meridian_p'>
       {html_options options=$meridians}
     </select>     
   </p>
 </div>

 <div id="rsrc_period_h" class="rsrc_period" style="clear: right; display: none;">
   <p style="float: left; width: 30%;">{$mod->Lang('start_date')}:</p>
   <p style="float: right; width: 69%;">
     {html_select_date prefix="sel_startdate_h_" start_year=$admin_startyear end_year="+2"}
     &nbsp;{$mod->Lang('at')}&nbsp;
     {html_select_time display_seconds=false minute_interval=15 prefix="sel_startdate_h_"}
   </p>
 </div>

 <div id="sel_row_numpeople" style="clear: right; display: none;">
   <p style="float: left; width: 30%;">{$mod->Lang('num_people')}:</p>
   <p style="float: right; width: 69%;">
     <select id="sel_numpeople" name="sel_numpeople">
     {html_options options=$people_list}
     </select>
   </p>
 </div>

 <div id="sel_message" style="clear: right; display: none;">
 </div>

 <div id="sel_int_price" style="clear: right; display: none;">
 </div>

 <div id="sel_int_status" style="clear: right; display: none;">
 </div>

 <div id="sel_price" style="clear: right; display: none;">
   <p style="float: left; width: 30%;">{$mod->Lang('price')}</p>
   <p id="sel_price_amt" style="float: right; width: 69%;">
   </p>
 </div>

 <div id="sel_btns" style="clear: right; display: none;">
   <p style="float: left; width: 30%;">&nbsp;</p>
   <p style="float: right; width: 69%;">
     <input type="submit" id="sel_btn_check" value="{$mod->Lang('check')}"/>
     <input type="submit" id="sel_btn_add" value="{$mod->Lang('add')}" style="display: none;"/>
   </p>
 </div>
</div>

</fieldset>
</div>

{* this area displays addons to the reservation *}
{if isset($data.extra) && count($data.extra)}
<div class="pagetext">
<fieldset>
<legend>{$mod->Lang('lbl_extra_purchases')}:</legend>
<table class="pagetable" cellspacing="0">
 <thead>
  <tr>
    <th>{$mod->Lang('name')}</th>
    <th>{$mod->Lang('sku')}</th>
    <th>{$mod->Lang('quantity')}</th>
    <th>{$mod->Lang('price')}</th>
    <th class="pageicon"></th>
  </tr>
 </thead>
 <tbody>
 {foreach from=$data.extra item='extra'}
   <tr> 
     <input type="hidden" name="{$actionid}resvn_extra_{$extra.id}" value="1"/>
     <td>{$extra.desc}</td>
     <td>{$extra.sku}</td>
     <td>{$extra.qty}</td>
     <td>{$mod->GetPreference('currency_symbol','$')}{$extra.itemamt|number_format:2}</td>
     <td>{cgimage class='extra_delete' image='icons/system/delete.gif' alt=$mod->Lang('delete')}</td>
   </tr>
 {/foreach}
 </tbody>
</table>
</fieldset>
</div>
{/if}

<div class="pageoverflow">
  <p class="pagetext">{$mod->Lang('status')}:</p>
  <p class="pageinput">
   <select name="{$actionid}input_status">
     {html_options options=$statuses selected=$data.status}
   </select>
  </p>
</div>
<div class="pageoverflow">
  <p class="pagetext">{$mod->Lang('admin_notes')}:</p>
  <p class="pageinput">{$input_admin_notes}</p>
</div>
{if isset($input_sendmessage)}
<div class="pageoverflow">
  <p class="pagetext">{$mod->Lang('send_customer_mail')}</p>
  <p class="pageinput">{$input_sendmessage}</p>
</div>
{/if}
<div class="pageoverflow">
  <p class="pagetext">{$mod->Lang('change_notes')}</p>
  <p class="pageinput">
  <textarea class="resvn_change_notes" name="{$actionid}change_note"></textarea>
  {if isset($reservation_history)}
  <a href="#reservation_history" id="view_history">{assign var='tmp' value=$mod->Lang('view_history')}{cgimage image='icons/system/view.gif' alt=$tmp}</a>
  {/if}
  </p>
</div>
<div class="pageoverflow">
  <p class="pagetext">&nbsp;</p>
  <p class="pageinput">
     <input type="submit" id="submit_btn" name="{$actionid}submit" value="{$mod->Lang('submit')}"/>
     <input type="submit" name="{$actionid}cancel" value="{$mod->Lang('cancel')}"/>
     {if $mod->CanEditReservations() && $data.id > 0}{module_action_link module='Availability' action='admin_delete_resvn' image='icons/system/delete.gif' imageonly=1 resvnid=$data.id text=$mod->Lang('delete') confmessage=$mod->Lang('ask_delete_reservation')}{/if}</p>
</div>
{$formend}

{* the reservation history stuff *}
{if isset($reservation_history)}
<div style="display: none;">
<div id="reservation_history">
 {foreach from=$reservation_history item='item'}
 <div class="history_item">
   <div class="history_item_when">{$item.changed|cms_date_format}</div>
   <div class="history_item_name"><strong>{$mod->Lang('name')}:</strong>&nbsp;{$item.who}</div>
   <div class="history_item_clear"></div>
   {if !empty($item.note)}
   <div class="history_item_note">{$item.note}</div>
   {/if}
 </div> 
 {/foreach}
</div>
</div>
{/if}