{* calendar tab template *}

{literal}
<script type="text/javascript">
function clearCategories()
{
  var ctl = "filter_cats";
  var el = document.getElementById(ctl);
  el.selectedIndex=-1;
}

function clearResources()
{
  var ctl = "filter_rsrcs";
  var el = document.getElementById(ctl);
  el.selectedIndex=-1;
}

jQuery(document).ready(function() {
  jQuery('a.avail_tip').cluetip({splitTitle: '|'});
});
</script>
{/literal}

<div class="pageoverflow">
{$formstart}
<table class="pagetable">
  <tr valign="top">
    <td>
      <fieldset>
      <legend>{$mod->Lang('filter')}:&nbsp;</legend>
      <div class="pageoverflow">
        <p class="pagetext">{$mod->Lang('categories')}:</p>
        <p class="pageinput">{$filter_categories}</p>
      </div>
      <div class="pageoverflow">
        <p class="pagetext">{$mod->GetResourceType(true)}:</p>
        <p class="pageinput">{$filter_resources}</p>
      </div>
      <div class="pageoverflow">
        <p class="pagetext">{$mod->Lang('month')}:</p>
        {capture assign='tmp'}{$actionid}calendar_date{/capture}
        <p class="pageinput">{html_select_date prefix=$tmp start_year=-20 end_year=+1 display_days=false time=$dispdate}</p>
      </div>
      <div class="pageoverflow">
        <p class="pagetext">&nbsp;</p>
        <p class="pageinput">{$filter_submit}{$filter_reset}</p>
      </div>
      </fieldset>
    </td>

    <td>
      <fieldset>
      <legend>{$mod->Lang('display')}:&nbsp;</legend>
      <div class="pageoverflow">
        <p class="pagetext">{$mod->Lang('event_types')}:</p>
        <p class="pageinput">{$filter_etypes}</p>
      </div>
      <div class="pageoverflow">
        <p class="pagetext">&nbsp;</p>
        <p class="pageinput">{$filter_submit}{$filter_reset}</p>
      </div>
      </fieldset>
    </td>

    {if isset($statistics)}
    <td>
      <fieldset>
      <legend>{$mod->Lang('statistics')}:&nbsp;</legend>
        <table>
          <tr>
            <td>{$mod->Lang('total_blocks')}:</td>
            <td>{$statistics.total}</td>
          </tr>
          <tr>
            <td>{$mod->Lang('nonbookable_blocks')}:</td>
            <td>{$statistics.closed}</td>
          </tr>
          <tr>
            <td>{$mod->Lang('bookable_event_blocks')}:</td>
            <td>{$statistics.event}</td>
          </tr>
          <tr>
            <td>{$mod->Lang('booked_blocks')}:</td>
            <td>{$statistics.reserved}</td>
          </tr>
          <tr>
            <td>{$mod->Lang('percent_booked')}:</td>
            <td>{if $statistics.total > 0}{math equation='(a+b) / (c-d) * 100' a=$statistics.reserved b=$statistics.numparts c=$statistics.total d=$statistics.closed assign='num'}{$num|number_format:2}%{/if}</td>
          </tr>
	  {if isset($graphing_url)}
          <tr>
            <td colspan="2" style="text-align: center;"><a href="{$graphing_url}" title="{$mod->Lang('title_graphing')}"><img src="{$graph_icon_url}"/>&nbsp;{$mod->Lang('historical_comparison')}</td>
          </tr>
          {/if}
        </table>
      </fieldset>
    </td>
   {/if}

   {if isset($legend)}
    <td>
      <fieldset>
      <legend>{$mod->Lang('legend')}:&nbsp;</legend>
        <table>
        {foreach from=$legend key='name' item='item'}
          <tr>
            <td>{$name}:</td>
            <td style="background-color: {$item->bg}; color: {$item->fg};">
              {$item->label}
            </td>   
          </tr>
        {/foreach}
        </table>
      </fieldset>
    </td>
   {/if}
  </tr>
  
</table>
{$formend}
</div>
<br/>

<div class="pageoverflow">
  <p style="float: left; width: 24%;">{$prevmonth_link}</p>
  <p style="float: left; text-align: center; width: 50%;"><strong>{$dispdate|cms_date_format:"%B %Y"}</strong></p>
  <p style="float: right; text-align: right; width: 24%;">{$nextmonth_link}</p>
</div>

<div style="width: 100%; overflow: auto;">
<table class="pagetable" cellspacing="0">
<thead>
{section name='day' loop=$grid max=1}
  <tr>
  {section name='rsrc' loop=$grid[day]}
    {if $smarty.section.rsrc.index == 0}
    <th style="text-align: center;" width="2%">{$grid[day][rsrc]|cms_date_format:"%m/%y"}</th>
    {else}
    <th style="width: 200px; text-align: center;">{$grid[day][rsrc]}</th>
    {/if}
  {/section}
  </tr>
{/section}
</thead>

<tbody>
{section name='day' loop=$grid start=1}
  <tr>
    {section name='rsrc' loop=$grid[day]}
      {if $smarty.section.rsrc.index == 0 }
        <td class="avail_cell" style="text-align: right; background-color: #ccc;">{$grid[day][rsrc]}</td>
      {else} 
        <td class="avail_cell" style="text-align: center; background-color: {$grid[day][rsrc]->bg}; color: {$grid[day][rsrc]->fg};">
        {if isset($grid[day][rsrc]->url)}
        <a class="avail_link{if isset($grid[day][rsrc]->title)} avail_tip{/if}" style="background-color: {$grid[day][rsrc]->bg}; color: {$grid[day][rsrc]->fg};" href="{$grid[day][rsrc]->url}" {if isset($grid[day][rsrc]->title)}title="{$grid[day][rsrc]->title}"{/if}>{$grid[day][rsrc]->label}</a>
        {else}
        {$grid[day][rsrc]->label}
        {/if}
        </td>
      {/if}
    {/section}
  </tr>
{/section}
</tbody>
</table>
</div>