<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

$current_version = $oldversion;
$db =& $this->GetDb();
$dict = NewDataDictionary($db);
$taboptarray = array('mysql'=>'TYPE=MyISAM');

switch($current_version)
  {
  case "1.0":
  case "1.1":
    {
      $sqlarray = $dict->AddColumnSQL(AVAILABILITY_TABLE_RESERVATION_NOTES,
				      "admin_note I1");
      $dict->ExecuteSQLArray($sqlarray);
    }
  case '1.2':
    {
      $this->SetPreference('checkin_time','14:00');
      $this->SetPreference('checkout_time','11:00');

      // update all end_dates to have a time at the checkout time
      $query = 'UPDATE '.AVAILABILITY_TABLE_RESERVATIONS."
                   SET end_date = DATE_FORMAT(end_date,'%Y-%m-%d 11:00:00') 
                 WHERE TIME_FORMAT(end_date,'%H:%i') = '23:59'";
      $db->Execute($query);
      $query = 'UPDATE '.AVAILABILITY_TABLE_RESERVATIONS."
                   SET end_date = DATE_FORMAT(end_date,'%Y-%m-%d 11:00:00') 
                 WHERE TIME_FORMAT(end_date,'%H:%i') = '00:00'";
      $db->Execute($query);

      // update all start dates to have a time at the checkin time
      $query = 'UPDATE '.AVAILABILITY_TABLE_RESERVATIONS." SET start_date = DATE_FORMAT(start_date,'%Y-%m-%d 14:00:00')";
      $db->Execute($query);
      $query = 'UPDATE '.AVAILABILITY_TABLE_RESERVATION_PARTS." SET date = DATE_FORMAT(date,'%Y-%m-%d 14:00:00')";
      $db->Execute($query);
    }

  case '1.3':
    {
      $sqlarray = $dict->AddColumnSQL(AVAILABILITY_TABLE_RSRCS,
				      "capacity I");
      $dict->ExecuteSQLArray($sqlarray);

      $sqlarray = $dict->AddColumnSQL(AVAILABILITY_TABLE_RSRC_PRICES,
				      "weekly C(20),overcap C(20)");
      $dict->ExecuteSQLArray($sqlarray);
    }

  case '1.4':
    {
      $sqlarray = $dict->AddColumnSQL(AVAILABILITY_TABLE_RSRC_PRICES,
				      "discount_days I,discount_adjust C(20)");
      $dict->ExecuteSQLArray($sqlarray);
    }

  case '1.5':
  case '1.5.1':
    {
      $sqlarray = $dict->AddColumnSQL(AVAILABILITY_TABLE_RESERVATIONS,
				      "status C(20)");
      $dict->ExecuteSQLArray($sqlarray);
    }

  case '1.5.2':
    {
      $sqlarray = $dict->AddColumnSQL(AVAILABILITY_TABLE_RSRC_PRICES,
				      "discount_type I");
      $dict->ExecuteSQLArray($sqlarray);
    }

  case '1.5.3':
    {
      # Day View Template(s)
      $fn = dirname(__FILE__).'/templates/orig_day_template.tpl';
      if( file_exists($fn) )
	{
	  $template = file_get_contents($fn);
	  $this->SetPreference(AVAILABILITY_PREF_NEWDAY_TEMPLATE,$template);
	  $this->SetTemplate('day_Sample',$template);
	  $this->SetPreference(AVAILABILITY_PREF_DFLTDAY_TEMPLATE,'Sample');
	}

      # Fix all event end times
      $query = 'UPDATE '.AVAILABILITY_TABLE_EVENTS." SET start_date = DATE_FORMAT(start_date,'%Y-%m-%d 0:0:0')";
      $db->Execute($query);
      $query = 'UPDATE '.AVAILABILITY_TABLE_EVENTS." SET end_date = DATE_FORMAT(end_date,'%Y-%m-%d 23:59:59')";
      $db->Execute($query);
    }

  case '1.6':
    {
      # New preferences
      $this->SetPreference('starttime_1','08:00');
      $this->SetPreference('starttime_2','12:00');
      $this->SetPreference('endtime_1','13:00');
      $this->SetPreference('endtime_2','17:00');
      $this->SetPreference('default_interval','daily');
      $this->SetPreference('default_granularity','half_hour');
      
      # New DB Fields
      $sqlarray = $dict->AddColumnSQL(AVAILABILITY_TABLE_RSRCS,
				      "res_interval C(20), granularity C(20),
                                       starttime1 C(6), endtime1 C(6), 
                                       starttime2 C(6), endtime2 C(6),
                                       checkintime C(6), checkouttime C(6)");
      $dict->ExecuteSQLArray($sqlarray);

      $sqlarray = $dict->AddColumnSQL(AVAILABILITY_TABLE_RESERVATION_PARTS,
				      "num_people I, start_date ".CMS_ADODB_DT.", end_date ".CMS_ADODB_DT);
      $dict->ExecuteSQLArray($sqlarray);


      # Populate New DB Fields
      $query = 'UPDATE '.AVAILABILITY_TABLE_RSRCS.' 
                   SET res_interval = ?, granularity = ?,
                       starttime1 = ?, endtime1 = ?,
                       starttime2 = ?, endtime2 = ?,
                       checkintime = ?, checkouttime = ?';
      $db->Execute($query,array('daily','half_hour',
                                '08:00','12:00','13:00','17:00',
				'14:00','11:00'));

      // grab the reservation start date, and end date
      // and update the reservation parts.
      $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RESERVATIONS;
      $dbr = $db->Execute($query);
      $q2 = 'UPDATE '.AVAILABILITY_TABLE_RESERVATION_PARTS.'
                SET start_date = ?, end_date = ?, num_people = ?
              WHERE resv_id = ?';
      while( $dbr && $row = $dbr->FetchRow() )
	{
	  $db->Execute($q2, array($row['start_date'],$row['end_date'],$row['num_people'],$row['id']));
	}

      // now drop the start and end date fields from the reservation table.
      $sqlarray = $dict->DropColumnSQL(AVAILABILITY_TABLE_RESERVATIONS,
				       'start_date,end_date,num_people');
      $dict->ExecuteSQLArray($sqlarray);
    }

  case '1.7':
  case '1.7.1':
  case '1.7.2':
  case '1.7.3':
  case '1.7.4':
  case '1.7.5':
  case '1.7.6':
  case '1.7.7':
    {
      // now drop the start and end date fields from the reservation table.
      $sqlarray = $dict->AddColumnSQL(AVAILABILITY_TABLE_RSRCS,'allow_overcapacity I1,sorting I');
      $dict->ExecuteSQLArray($sqlarray);

      $sql = 'UPDATE '.AVAILABILITY_TABLE_RSRCS.' SET allow_overcapacity = 1';
      $db->Execute($sql);

      $query1 = 'SELECT id FROM '.AVAILABILITY_TABLE_RSRCS;
      $rsrc_ids = $db->GetCol($query1);
      $num = 1;
      $query = 'UPDATE '.AVAILABILITY_TABLE_RSRCS.' SET sorting = ? WHERE id = ?';
      foreach( $rsrc_ids as $one_rsrc )
	{
	  $db->Execute($query,array($num++,$one_rsrc));
	}
    }

  case '1.7.8':
    {
      $this->AddEventHandler('CGEcommerceBase','CartAdjusted',false);
      $this->AddEventHandler('CGEcommerceBase','OrderCreated',false);
      $this->AddEventHandler('CGEcommerceBase','OrderUpdated',false);
      $this->AddEventHandler('CGEcommerceBase','OrderDeleted',false);
    }

  case '1.7.9':
  case '1.7.10':
    $flds = "
         id       I KEY AUTO NOT NULL,
         resv_id  I NOT NULL,
         who      C(50) NOT NULL,
         action   C(50) NOT NULL,
         changed  ".CMS_ADODB_DT.",
         note     X";
    $sqlarray = $dict->CreateTableSQL(AVAILABILITY_TABLE_RESERVATION_HIST,
				  $flds,$taboptarray);
    $dict->ExecuteSQLArray($sqlarray);

  case '1.7.11':
  case '1.7.12':
    $flds = "
             id       I KEY AUTO NOT NULL,
             resv_id  I NOT NULL,
             source   C(50) NOT NULL,
             itemid   I NOT NULL,
             sku      C(50),
             name     C(255),
             qty      I NOT NULL,
             itemamt  F NOT NULL,
             data     X
            ";
    $sqlarray = $dict->CreateTableSQL(AVAILABILITY_TABLE_RESERVATION_EXTRA,
				      $flds,$taboptarray);
    $res = $dict->ExecuteSQLArray($sqlarray);
    if( !$res )
      {
	debug_display($db->sql);
	debug_display($db->ErrorMsg());
	die();
      }
    
  }


#
# EOF
#
?>
