<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE
if( !isset($gCms) ) exit;

$db =& $this->GetDb();
$dict = NewDataDictionary($db);
$taboptarray = array('mysql'=>'TYPE=MyISAM');

// Event types table
$flds = "
         id     I KEY AUTO NOT NULL,
         name   C(255) NOT NULL,
         color  C(15),
         background C(15),
         iorder I";
$sqlarray = $dict->CreateTableSQL(AVAILABILITY_TABLE_EVENT_TYPES,
				  $flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

# Events Table
$flds = "
         id            I KEY AUTO NOT NULL,
         name          C(255) NOT NULL,
         description   X,
         event_type_id I,
         start_date   ".CMS_ADODB_DT.",
         end_date     ".CMS_ADODB_DT.",
         bookable      I1,
         price_adjust  C(15),
         admin_notes   X";
$sqlarray = $dict->CreateTableSQL(AVAILABILITY_TABLE_EVENTS,
				  $flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "
         id   I KEY AUTO NOT NULL,
         name C(255)";
$sqlarray = $dict->CreateTableSQL(AVAILABILITY_TABLE_CATS,
				  $flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "
         id          I KEY AUTO NOT NULL,
         name        C(255),
         active      I1,
         description X,
         base_price  F,
         admin_notes X,
         capacity    I,
         res_interval    C(20),
         granularity C(20),
         starttime1  C(6),
         endtime1    C(6),
         starttime2  C(6),
         endtime2    C(6),
         checkintime C(6),
         checkouttime C(6),
         allow_overcapacity I1,
         sorting I";
$sqlarray = $dict->CreateTableSQL(AVAILABILITY_TABLE_RSRCS,
				  $flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "
         rsrc_id     I KEY NOT NULL,
         sunday      C(20),
         monday      C(20),
         tuesday     C(20),
         wednesday   C(20),
         thursday    C(20),
         friday      C(20),
         saturday    C(20),
         weekly      C(20),
         overcap     C(20),
         discount_type I,
         discount_days I,
         discount_adjust C(20).
         ";
$sqlarray = $dict->CreateTableSQL(AVAILABILITY_TABLE_RSRC_PRICES,
				  $flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "
         rsrc_id     I KEY NOT NULL,
         category_id I KEY NOT NULL";
$sqlarray = $dict->CreateTableSQL(AVAILABILITY_TABLE_RSRC_CATS,
				  $flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);


$flds = "
         event_id    I KEY NOT NULL,
         rsrc_id     I KEY NOT NULL";
$sqlarray = $dict->CreateTableSQL(AVAILABILITY_TABLE_RSRC_EVENTS,
				  $flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "
         id            I KEY AUTO NOT NULL,
         customer_id   I,
         price         F,
         status        C(20),
         admin_notes   X,
         create_date   ".CMS_ADODB_DT.",
         modified_date ".CMS_ADODB_DT;
$sqlarray = $dict->CreateTableSQL(AVAILABILITY_TABLE_RESERVATIONS,
				  $flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "
         id            I KEY AUTO NOT NULL,
         resv_id       I KEY NOT NULL,
         rsrc_id       I KEY NOT NULL,
         start_date    ".CMS_ADODB_DT.",
         end_date      ".CMS_ADODB_DT.",
         num_people    I,
         price         F";
$sqlarray = $dict->CreateTableSQL(AVAILABILITY_TABLE_RESERVATION_PARTS,
				  $flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);
         
$flds = "
         id       I KEY AUTO NOT NULL,
         resv_id  I NOT NULL,
         subject  C(255),
         text     X,
         admin_note   I1,
         create_date   ".CMS_ADODB_DT;
$sqlarray = $dict->CreateTableSQL(AVAILABILITY_TABLE_RESERVATION_NOTES,
				  $flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "
         id       I KEY AUTO NOT NULL,
         resv_id  I NOT NULL,
         source   C(50) NOT NULL,
         itemid   I NOT NULL,
         sku      C(50),
         name     C(255),
         qty      I NOT NULL,
         itemamt  F NOT NULL,
         data     X
        ";
$sqlarray = $dict->CreateTableSQL(AVAILABILITY_TABLE_RESERVATION_EXTRA);
$dict->ExecuteSQLArray($sqlarray);
        

$flds = "
         id       I KEY AUTO NOT NULL,
         resv_id  I NOT NULL,
         name     C(255),
         value    X";
$sqlarray = $dict->CreateTableSQL(AVAILABILITY_TABLE_RESERVATION_ATTRIBS,
				  $flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "
         id       I KEY AUTO NOT NULL,
         resv_id  I NOT NULL,
         who      C(50) NOT NULL,
         action   C(50) NOT NULL,
         changed  ".CMS_ADODB_DT.",
         note     X";
$sqlarray = $dict->CreateTableSQL(AVAILABILITY_TABLE_RESERVATION_HIST,
				  $flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

$flds = "
  id            I KEY AUTO NOT NULL,
  name          C(255) NOT NULL,
  prompt        C(255),
  type          C(20),
  max_length    I,
  options       X,
  item_order    I,
  public        I1";
$sqlarray = $dict->CreateTableSQL(AVAILABILITY_TABLE_FIELDDEFS,
				  $flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);
$flds = "
  rsrc_id       I NOT NULL,
  fielddef_id   I NOT NULL,
  value         X";
$sqlarray = $dict->CreateTableSQL(AVAILABILITY_TABLE_FIELDVALS,
				  $flds,$taboptarray);
$dict->ExecuteSQLArray($sqlarray);

#
# Indexes - TODO
#

#
# Templates
#

# Customer Email Templates
$fn = dirname(__FILE__).'/templates/orig_customer_email_template.tpl';
if( file_exists($fn) )
  {
    $template = file_get_contents($fn);
    $this->SetPreference(AVAILABILITY_PREF_NEWCUSTEMAIL_TEMPLATE,$template);
    $this->SetTemplate('custemail_Sample',$template);
    $this->SetPreference(AVAILABILITY_PREF_DFLTCUSTEMAIL_TEMPLATE,'Sample');
  }

# Summary Template
$fn = dirname(__FILE__).'/templates/orig_summary_template.tpl';
if( file_exists($fn) )
  {
    $template = file_get_contents($fn);
    $this->SetPreference(AVAILABILITY_PREF_NEWSUMMARY_TEMPLATE,$template);
    $this->SetTemplate('summary_Sample',$template);
    $this->SetPreference(AVAILABILITY_PREF_DFLTSUMMARY_TEMPLATE,'Sample');
  }

# Detail Template
$fn = dirname(__FILE__).'/templates/orig_detail_template.tpl';
if( file_exists($fn) )
  {
    $template = file_get_contents($fn);
    $this->SetPreference(AVAILABILITY_PREF_NEWDETAIL_TEMPLATE,$template);
    $this->SetTemplate('detail_Sample',$template);
    $this->SetPreference(AVAILABILITY_PREF_DFLTDETAIL_TEMPLATE,'Sample');
  }

# Calendar Template(s)
$fn = dirname(__FILE__).'/templates/orig_calendar_template.tpl';
if( file_exists($fn) )
  {
    $template = file_get_contents($fn);
    $this->SetPreference(AVAILABILITY_PREF_NEWCALENDAR_TEMPLATE,$template);
    $this->SetTemplate('calendar_Sample',$template);
    $this->SetPreference(AVAILABILITY_PREF_DFLTCALENDAR_TEMPLATE,'Sample');
  }
$fn = dirname(__FILE__).'/templates/orig_calendar_dates_across.tpl';
if( file_exists($fn) )
  {
    $template = file_get_contents($fn);
    $this->SetTemplate('calendar_Dates_Across',$template);
  }

# Day View Template(s)
$fn = dirname(__FILE__).'/templates/orig_day_template.tpl';
if( file_exists($fn) )
  {
    $template = file_get_contents($fn);
    $this->SetPreference(AVAILABILITY_PREF_NEWDAY_TEMPLATE,$template);
    $this->SetTemplate('day_Sample',$template);
    $this->SetPreference(AVAILABILITY_PREF_DFLTDAY_TEMPLATE,'Sample');
  }

# Resvervation Form Template
$fn = dirname(__FILE__).'/templates/orig_resvn_template.tpl';
if( file_exists($fn) )
  {
    $template = file_get_contents($fn);
    $this->SetPreference(AVAILABILITY_PREF_NEWRESVN_TEMPLATE,$template);
    $this->SetTemplate('resvn_Sample',$template);
    $this->SetPreference(AVAILABILITY_PREF_DFLTRESVN_TEMPLATE,'Sample');
  }

# Resvervation Confirm Template
$fn = dirname(__FILE__).'/templates/orig_resvn_confirm_template.tpl';
if( file_exists($fn) )
  {
    $template = file_get_contents($fn);
    $this->SetPreference(AVAILABILITY_PREF_NEWRESVNCONFIRM_TEMPLATE,$template);
    $this->SetTemplate('resvncfm_Sample',$template);
    $this->SetPreference(AVAILABILITY_PREF_DFLTRESVNCONFIRM_TEMPLATE,'Sample');
  }

# Resvervation Confirm Email Template
$fn = dirname(__FILE__).'/templates/orig_resvn_confirm_email_template.tpl';
if( file_exists($fn) )
  {
    $template = file_get_contents($fn);
    $this->SetPreference(AVAILABILITY_PREF_NEWRESVNCONFIRMEMAIL_TEMPLATE,$template);
    $this->SetTemplate('resvncfmemail_Sample',$template);
    $this->SetPreference(AVAILABILITY_PREF_DFLTRESVNCONFIRMEMAIL_TEMPLATE,'Sample');
  }

# Advanced Search Form Template
$fn = dirname(__FILE__).'/templates/orig_advanced_search_form_template.tpl';
if( file_exists($fn) )
  {
    $template = file_get_contents($fn);
    $this->SetPreference(AVAILABILITY_PREF_NEWADVSEARCHFORM_TEMPLATE,$template);
    $this->SetTemplate('advsearchform_Sample',$template);
    $this->SetPreference(AVAILABILITY_PREF_DFLTADVSEARCHFORM_TEMPLATE,'Sample');
  }

# My Reservations views
$fn = dirname(__FILE__).'/templates/orig_myreservations_template.tpl';
if( file_exists($fn) )
  {
    $template = file_get_contents($fn);
    $this->SetPreference(AVAILABILITY_PREF_NEWMYRESV_TEMPLATE,$template);
    $this->SetTemplate('myresv_Sample',$template);
    $this->SetPreference(AVAILABILITY_PREF_DFLTMYRESV_TEMPLATE,'Sample');
  }

# Send Email Forms
$fn = dirname(__FILE__).'/templates/orig_sendemail_template.tpl';
if( file_exists($fn) )
  {
    $template = file_get_contents($fn);
    $this->SetPreference(AVAILABILITY_PREF_NEWSENDEMAIL_TEMPLATE,$template);
    $this->SetTemplate('sendemail_Sample',$template);
    $this->SetPreference(AVAILABILITY_PREF_DFLTSENDEMAIL_TEMPLATE,'Sample');
  }


# Events
$this->AddEventHandler('CGEcommerceBase','CartAdjusted',false);
$this->AddEventHandler('CGEcommerceBase','OrderCreated',false);
$this->AddEventHandler('CGEcommerceBase','OrderUpdated',false);
$this->AddEventHandler('CGEcommerceBase','OrderDeleted',false);

# Permissions
$this->CreatePermission(AVAILABILITY_PERM_CONTACTCUSTOMER,'Email Reservation Contacts');
$this->CreatePermission(AVAILABILITY_PERM_EVENTS,'Manage Events');
$this->CreatePermission(AVAILABILITY_PERM_RESERVATIONS,'Manage Reservations');
$this->CreatePermission(AVAILABILITY_PERM_VIEWRESV,'View Reservations');
$this->CreatePermission(AVAILABILITY_PERM_RESOURCES,'Manage Resources');

# Preference
$this->SetPreference('resource_type','room');
$this->SetPreference('image_types','png,jpg,jpeg,gif');
$this->SetPreference('file_types','pdf,txt');
$this->SetPreference('auto_thumbnail',1);
$this->SetPreference('customer_display_template','{$username}');
$this->SetPreference('checkin_time','14:00');
$this->SetPreference('checkout_time','11:00');
$this->SetPreference('resvn_foreground','#ffffff');
$this->SetPreference('resvn_background','#00ff00');
$this->SetPreference('conflict_foreground','#ffffff');
$this->SetPreference('conflict_background','#00ffff');
$this->SetPreference('pending_foreground','#ffffff');
$this->SetPreference('pending_background','#0000ff');
$this->SetPreference('starttime_1','08:00');
$this->SetPreference('endtime_1','12:00');
$this->SetPreference('starttime_2','13:00');
$this->SetPreference('endtime_2','17:00');
$this->SetPreference('default_interval','daily');
$this->SetPreference('default_granularity','half_hour');
$this->SetPreference('default_capacity','50');

#
# EOF
#
?>