<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class reservation_ops
{
  static public function &load_by_id($resv_id)
  {
    $db = cmsms()->GetDb();

    $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RESERVATIONS.' 
               WHERE id = ?';
    $row = $db->GetRow($query,array($resv_id));
    if( !$row ) return;
    
    $reservation = new availability_reservation();
    $reservation->from_array($row);

    // get the parts.
    $query = 'SELECT id FROM '.AVAILABILITY_TABLE_RESERVATION_PARTS.'
               WHERE resv_id = ?';
    $part_ids = $db->GetCol($query,array($resv_id));
    if( is_array($part_ids) && count($part_ids) )
      {
	foreach( $part_ids as $one_part )
	  {
	    $part = reservation_part_ops::load_by_id($one_part);
	    if( $part )
	      {
		$reservation->add_part($part);
	      }
	  }
      }


    // get the notes
    $query = 'SELECT id FROM '.AVAILABILITY_TABLE_RESERVATION_NOTES.'
               WHERE resv_id = ?';
    $note_ids = $db->GetCol($query,array($resv_id));
    if( is_array($note_ids) && count($note_ids) )
      {
	foreach( $note_ids as $one_note )
	  {
	    $note = reservation_note_ops::load_by_id($one_note);
	    if( $note )
	      {
		$reservation->add_note($note);
	      }
	  }
      }
    
    // get extra data
    $query = 'SELECT id FROM '.AVAILABILITY_TABLE_RESERVATION_EXTRA.'
               WHERE resv_id = ?';
    $extra_ids = $db->GetCol($query,array($resv_id));
    if( is_array($extra_ids) && count($extra_ids) )
      {
	foreach( $extra_ids as $one_extra )
	  {
	    $extra = reservation_extra_ops::load_by_id($one_extra);
	    if( $extra )
	      {
		$reservation->add_extra($extra);
	      }
	  }
      }
    return $reservation;
  }


  static public function insert(&$reservation)
  {
    $db = cmsms()->GetDb();

    $query = 'INSERT INTO '.AVAILABILITY_TABLE_RESERVATIONS.'
      (customer_id,price,status,admin_notes,create_date,modified_date)
      VALUES(?,?,?,?,?,?)';

    $now = trim($db->DbTimeStamp(time()),"'");
    $dbr = $db->Execute($query,
			array($reservation->get_customer_id(),
			      $reservation->get_price(),
			      $reservation->get_status(),
			      $reservation->get_admin_notes(),
			      $now,
			      $now));
    if( !$dbr ) 
      {
	echo "DEBUG: ".$db->sql.'<br/>'.$db->ErrorMsg().'<br/>'; die();
	return FALSE;
      }
    
    // get the insert id
    $reservation->set_id($db->Insert_Id());
    $reservation->set_create_date($now);
    $reservation->set_create_date($now);

    // now save the parts.
    for( $i = 0; $i < $reservation->count_parts(); $i++ )
      {
	$part = $reservation->get_part_by_idx($i);
	$part->set_resv_id($reservation->get_id());
	$part->save();
      }

    // now save the notes
    for( $i = 0; $i < $reservation->count_notes(); $i++ )
      {
	$note = $reservation->get_note_by_idx($i);
	$note->set_resv_id($reservation->get_id());
	$note->save();
      }


    // save the extra info
    for( $i = 0; $i < $reservation->count_extra(); $i++ )
      {
	$extra = $reservation->get_extra_by_idx($i);
	$extra->set_resv_id($reservation->get_id());
	$extra->save();
      }

    // save a history item.
    $query = 'INSERT INTO '.AVAILABILITY_TABLE_RESERVATION_HIST.'
              (resv_id,who,action,changed)
              VALUES (?,?,?,NOW())';
    $db->Execute($query,array($reservation->get_id(),
			      $reservation->get_actor(), // the person that's actually doing the operation.
			      'created'));
    return TRUE;
  }


  static public function update(&$reservation)
  {
    $db = cmsms()->GetDb();
    $now = trim($db->DbTimeStamp(time()),"'");

    $query = 'UPDATE '.AVAILABILITY_TABLE_RESERVATIONS.'
                 SET customer_id = ?, price = ?,
                     status = ?,
                     admin_notes = ?, 
                     modified_date = ?
               WHERE id = ?';
    $dbr = $db->Execute( $query,
			 array( $reservation->get_customer_id(),
				$reservation->get_price(),
				$reservation->get_status(),
				$reservation->get_admin_notes(),
				$now,
				$reservation->get_id() ) );
    if( !$dbr ) 
      {
	echo "DEBUG: ".$db->sql.'<br/>'.$db->ErrorMsg().'<br/>'; die();
	return FALSE;
      }

    $reservation->set_modified_date($now);

    $query = 'DELETE FROM '.AVAILABILITY_TABLE_RESERVATION_PARTS.'
                WHERE resv_id = ?';
    $db->Execute($query,array($reservation->get_id()));

    // now save the parts.
    for( $i = 0; $i < $reservation->count_parts(); $i++ )
      {
	$part = $reservation->get_part_by_idx($i);
	$part->set_id('');
	$part->set_resv_id($reservation->get_id());
	$part->save();
      }

    // now save the notes
    for( $i = 0; $i < $reservation->count_notes(); $i++ )
      {
	$note = $reservation->get_note_by_idx($i);
	$note->set_id('');
	$note->set_resv_id($reservation->get_id());
	$note->save();
      }

    // now save the extra
    for( $i = 0; $i < $reservation->count_extra(); $i++ )
      {
	$note = $reservation->get_extra_by_idx($i);
	$note->set_resv_id($reservation->get_id());
	$note->save();
      }

    // save a history item.
    $query = 'INSERT INTO '.AVAILABILITY_TABLE_RESERVATION_HIST.'
              (resv_id,who,action,changed)
              VALUES (?,?,?,NOW())';
    $db->Execute($query,array($reservation->get_id(),
			      $reservation->get_actor(), // the person that's actually doing the operation.
			      'created'));

    return TRUE;
  }


  /**
   * convert a reservation object into hashes
   * so that it's more suitable for use in old code.
   */
  static public function to_array($resvn)
  {
    $start_ut = -1;
    $end_ut   = -1;
    $data = $resvn->to_array();
    if( $resvn->count_parts() )
      {
	$data['parts'] = array();
	for( $i = 0; $i < $resvn->count_parts(); $i++ )
        {
	  $part = $resvn->get_part_by_idx($i);
	  $t_start = cge_date_utils::str_to_timestamp($part->get_start_date());
	  $t_end = cge_date_utils::str_to_timestamp($part->get_end_date());
	  if( $t_start < $start_ut || $start_ut == -1 )
	    {
	      $start_ut = $t_start;
	    }
	  if( $t_end > $end_ut )
	    {
	      $end_ut = $t_end;
	    }
	  $data['parts'][] = $part->to_array();
        }
      }
    if( $resvn->count_notes() )
      {
	$data['notes'] = array();
	for( $i = 0; $i < $resvn->count_notes(); $i++ )
        {
	  $note = $resvn->get_note_by_idx($i);
	  $data['notes'][] = $note->to_array();
        }
      }
    if( $resvn->count_extra() )
      {
	$data['extra'] = array();
	for( $i = 0; $i < $resvn->count_extra(); $i++ )
	  {
	    $extra = $resvn->get_extra_by_idx($i);
	    $data['extra'][] = $extra->to_array();
	  }
      }

    $data['start_date'] = cge_date_utils::ts_to_dbformat($start_ut);
    $data['end_date'] = cge_date_utils::ts_to_dbformat($end_ut);
    return $data;
  }


  /**
   * delete reservation by id
   */
  static public function delete_by_id($resv_id,$status = '')
  {
    $db = cmsms()->GetDb();

    if( $status != '' )
      {
	$query = 'SELECT id FROM '.AVAILABILITY_TABLE_RESERVATIONS.'
                   WHERE id = ? AND status = ?';
	$tmp = $db->GetOne($query,array($resv_id,$status));
	if( !$tmp ) return;
      }
    $query = 'DELETE FROM '.AVAILABILITY_TABLE_RESERVATION_ATTRIBS.'
           WHERE resv_id = ?';
    $db->Execute($query,array($resv_id));

    $query = 'DELETE FROM '.AVAILABILITY_TABLE_RESERVATION_NOTES.'
           WHERE resv_id = ?';
    $db->Execute($query,array($resv_id));

    $query = 'DELETE FROM '.AVAILABILITY_TABLE_RESERVATION_EXTRA.'
           WHERE resv_id = ?';
    $db->Execute($query,array($resv_id));

    $query = 'DELETE FROM '.AVAILABILITY_TABLE_RESERVATION_PARTS.'
           WHERE resv_id = ?';
    $db->Execute($query,array($resv_id));

    $query = 'DELETE FROM '.AVAILABILITY_TABLE_RESERVATIONS.'
           WHERE id = ?';
    $dbr = $db->Execute($query,array($resv_id));
    if( !$dbr )
      {
	throw new Exception('Query Failed: '.$db->sql);
      }

    audit($resv_id,'Availability','Reservation Deleted');
  }
} // end of class

#
# EOF
#
?>
