<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class reservation_extra_ops
{
  protected function __construct() {}

  static public function &load_by_id($extra_id)
  {
    $db = cmsms()->GetDb();

    $query = 'SELECT * FROM '.AVAILABILITY_TABLE_RESERVATION_EXTRA.'
              WHERE id = ?';
    $row = $db->GetRow($query,array($extra_id));
    if( !$row ) return;
    $row['desc'] = $row['name']; unset($row['name']);

    $extra = new availability_reservation_extra();
    $extra->from_array($row);

    return $extra;
  }


  static public function insert(availability_reservation_extra $extra)
  {
    $db = cmsms()->GetDb();
    $query = 'INSERT INTO '.AVAILABILITY_TABLE_RESERVATION_EXTRA.'
              (resv_id,source,itemid,sku,name,qty,itemamt,data)
              VALUES (?,?,?,?,?,?,?,?)';
    $dbr = $db->Execute($query,
			array($extra->get_resv_id(),$extra->get_source(),
			      $extra->get_itemid(),$extra->get_sku(),$extra->get_desc(),$extra->get_qty(),
			      $extra->get_itemamt(),$extra->get_data()));
    if( !$dbr )
      {
	throw new Exception('ERROR: '.$db->sql.' -- '.$db->ErrorMsg());
      }
    $extra->set_id($db->Insert_id());
    return TRUE;
  }


  static public function update(availability_reservation_extra $extra)
  {
    $db = cmsms()->GetDb();
    $query = 'UPDATE '.AVAILABILITY_TABLE_RESERVATIONS_EXTRA.'
              SET source = ?, itemid = ?, sku = ?, name = ?, qty = ?, itemamt = ?, data = ?
              WHERE id = ? AND resv_id = ?';
    $dbr = $db->Execute($query,
			array($extra->get_source(),
			      $extra->get_itemid(),
			      $extra->get_sku(),
			      $extra->get_desc(),
			      $extra->get_qty(),
			      $extra->get_itemamt(),
			      $extra->get_data(),
			      $extra->get_id(),
			      $extra->get_resv_id()));
    if( !$dbr )
      {
	throw new Exception('ERROR: '.$db->sql.' -- '.$db->ErrorMsg());
      }
    return TRUE;
  }

} // end of class

#
# EOF
#
?>