<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class availability_reservation_part
{
  private $_id;
  private $_resv_id;
  private $_rsrc_id;
  private $_start_date;
  private $_end_date;
  private $_num_people;
  private $_price;

  public function get_id()
  {
    return $this->_id;
  }

  public function set_id($id)
  {
    $this->_id = $id;
  }

  public function get_resv_id()
  {
    return $this->_resv_id;
  }

  public function set_resv_id($resv_id)
  {
    $this->_resv_id = $resv_id;
  }

  public function get_rsrc_id()
  {
    return $this->_rsrc_id;
  }

  public function set_rsrc_id($rsrc_id)
  {
    $this->_rsrc_id = $rsrc_id;
  }

  public function get_start_date()
  {
    return $this->_start_date;
  }

  public function set_start_date($start_date)
  {
    $this->_start_date = $start_date;
  }

  public function get_end_date()
  {
    return $this->_end_date;
  }

  public function set_end_date($end_date)
  {
    $this->_end_date = $end_date;
  }

  public function get_num_people()
  {
    return $this->_num_people;
  }

  public function set_num_people($num_people)
  {
    $this->_num_people = $num_people;
  }

  public function get_price()
  {
    return $this->_price;
  }

  public function set_price($price)
  {
    $this->_price = $price;
  }

  public function from_array($data)
  {
    $this->_id = $data['id'];
    $this->_resv_id = $data['resv_id'];
    $this->_rsrc_id = $data['rsrc_id'];
    $this->_start_date = $data['start_date'];
    $this->_end_date = $data['end_date'];
    $this->_num_people = $data['num_people'];
    $this->_price = $data['price'];
  }

  public function to_array()
  {
    $data = array();
    $data['id'] = $this->_id;
    $data['resv_id'] = $this->_resv_id;
    $data['rsrc_id'] = $this->_rsrc_id;
    $data['start_date'] = $this->_start_date;
    $data['end_date'] = $this->_end_date;
    $data['num_people'] = $this->_num_people;
    $data['price'] = $this->_price;
    return $data;
  }

  public function save()
  {
    if( $this->get_id() <= 0 )
      {
	return reservation_part_ops::insert($this);
      }
    else
      {
	return reservation_part_ops::update($this);
      }
  }
} // end of class

#
# EOF
#
?>