<?php
#BEGIN_LICENSE
#-------------------------------------------------------------------------
# Module: Availability (c) 2008 by Robert Campbell 
#         (calguy1000@cmsmadesimple.org)
#  An addon module for CMS Made Simple to provide full resource management
#  capabilities and reservation support.  It is designed to be a resource
#  manager for hotels, or cars, or other complex items that are reserved
#  on a daily basis.
#
#-------------------------------------------------------------------------
# CMS - CMS Made Simple is (c) 2005 by Ted Kulp (wishy@cmsmadesimple.org)
# This project's homepage is: http://www.cmsmadesimple.org
#
#-------------------------------------------------------------------------
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# However, as a special exception to the GPL, this software is distributed
# as an addon module to CMS Made Simple.  You may not use this software
# in any Non GPL version of CMS Made simple, or in any version of CMS
# Made simple that does not indicate clearly and obviously in its admin 
# section that the site was built with CMS Made simple.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# Or read it online: http://www.gnu.org/licenses/licenses.html#GPL
#
#-------------------------------------------------------------------------
#END_LICENSE

class availability_reservation_note
{
  private $_data;

  public function __construct()
  {
    $this->_data = array();
  }

  public function get_id()
  {
    if( isset($this->_data['id']) )
      return $this->_data['id'];
  }

  public function set_id($id)
  {
    $this->_data['id'] = $id;
  }

  public function get_resv_id()
  {
    if( isset($this->_data['resv_id']) )
      return $this->_data['resv_id'];
  }

  public function set_resv_id($resv_id)
  {
    $this->_data['resv_id'] = (int)$resv_id;
  }

  public function get_subject()
  {
    if( isset($this->_data['subject']) )
      return $this->_data['subject'];
  }

  public function set_subject($subject)
  {
    $this->_data['subject'] = $subject;
  }

  public function get_text()
  {
    if( isset($this->_data['text']) )
      return $this->_data['text'];
  }

  public function set_text($text)
  {
    $this->_data['text'] = $text;
  }

  public function get_admin_note()
  {
    if( isset($this->_data['admin_note']) )
      return $this->_data['admin_note'];
  }

  public function set_admin_note($admin_note)
  {
    $this->_data['admin_note'] = $admin_note;
  }

  public function get_create_date()
  {
    if( isset($this->_data['create_date']) )
      return $this->_data['create_date'];
  }

  public function set_create_date($create_date)
  {
    $this->_data['create_date'] = $create_date;
  }

  public function from_array($data)
  {
    $this->_data = $data;
  }

  public function to_array()
  {
    return $this->_data;
  }

  public function save()
  {
    if( $this->get_id() <= 0 )
      {
	return reservation_note_ops::insert($this);
      }
    else
      {
	return reservation_note_ops::update($this);
      }
  }

} // end of class

#
# EOF
#
?>